/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PlacementGroupState;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.services.ec2.model.SpreadLevel;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(PlacementGroup.getter(PlacementGroup::groupName)).setter(PlacementGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(PlacementGroup.getter(PlacementGroup::stateAsString)).setter(PlacementGroup.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(PlacementGroup.getter(PlacementGroup::strategyAsString)).setter(PlacementGroup.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").unmarshallLocationName("strategy").build()}).build();
    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionCount").getter(PlacementGroup.getter(PlacementGroup::partitionCount)).setter(PlacementGroup.setter(Builder::partitionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount").unmarshallLocationName("partitionCount").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(PlacementGroup.getter(PlacementGroup::groupId)).setter(PlacementGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PlacementGroup.getter(PlacementGroup::tags)).setter(PlacementGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupArn").getter(PlacementGroup.getter(PlacementGroup::groupArn)).setter(PlacementGroup.setter(Builder::groupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").unmarshallLocationName("groupArn").build()}).build();
    private static final SdkField<String> SPREAD_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpreadLevel").getter(PlacementGroup.getter(PlacementGroup::spreadLevelAsString)).setter(PlacementGroup.setter(Builder::spreadLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadLevel").unmarshallLocationName("spreadLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STATE_FIELD, STRATEGY_FIELD, PARTITION_COUNT_FIELD, GROUP_ID_FIELD, TAGS_FIELD, GROUP_ARN_FIELD, SPREAD_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PlacementGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String state;
    private final String strategy;
    private final Integer partitionCount;
    private final String groupId;
    private final List<Tag> tags;
    private final String groupArn;
    private final String spreadLevel;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
        this.partitionCount = builder.partitionCount;
        this.groupId = builder.groupId;
        this.tags = builder.tags;
        this.groupArn = builder.groupArn;
        this.spreadLevel = builder.spreadLevel;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final PlacementGroupState state() {
        return PlacementGroupState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final Integer partitionCount() {
        return this.partitionCount;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String groupArn() {
        return this.groupArn;
    }

    public final SpreadLevel spreadLevel() {
        return SpreadLevel.fromValue(this.spreadLevel);
    }

    public final String spreadLevelAsString() {
        return this.spreadLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.partitionCount(), other.partitionCount()) && Objects.equals(this.groupId(), other.groupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.groupArn(), other.groupArn()) && Objects.equals(this.spreadLevelAsString(), other.spreadLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementGroup").add("GroupName", (Object)this.groupName()).add("State", (Object)this.stateAsString()).add("Strategy", (Object)this.strategyAsString()).add("PartitionCount", (Object)this.partitionCount()).add("GroupId", (Object)this.groupId()).add("Tags", this.hasTags() ? this.tags() : null).add("GroupArn", (Object)this.groupArn()).add("SpreadLevel", (Object)this.spreadLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "PartitionCount": {
                return Optional.ofNullable(clazz.cast(this.partitionCount()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "GroupArn": {
                return Optional.ofNullable(clazz.cast(this.groupArn()));
            }
            case "SpreadLevel": {
                return Optional.ofNullable(clazz.cast(this.spreadLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Strategy", STRATEGY_FIELD);
        map.put("PartitionCount", PARTITION_COUNT_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("GroupArn", GROUP_ARN_FIELD);
        map.put("SpreadLevel", SPREAD_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroup, T> g) {
        return obj -> g.apply((PlacementGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String state;
        private String strategy;
        private Integer partitionCount;
        private String groupId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String groupArn;
        private String spreadLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            this.groupName(model.groupName);
            this.state(model.state);
            this.strategy(model.strategy);
            this.partitionCount(model.partitionCount);
            this.groupId(model.groupId);
            this.tags(model.tags);
            this.groupArn(model.groupArn);
            this.spreadLevel(model.spreadLevel);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getPartitionCount() {
            return this.partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGroupArn() {
            return this.groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getSpreadLevel() {
            return this.spreadLevel;
        }

        public final void setSpreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
        }

        @Override
        public final Builder spreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
            return this;
        }

        @Override
        public final Builder spreadLevel(SpreadLevel spreadLevel) {
            this.spreadLevel(spreadLevel == null ? null : spreadLevel.toString());
            return this;
        }

        public PlacementGroup build() {
            return new PlacementGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementGroup> {
        public Builder groupName(String var1);

        public Builder state(String var1);

        public Builder state(PlacementGroupState var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);

        public Builder partitionCount(Integer var1);

        public Builder groupId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder groupArn(String var1);

        public Builder spreadLevel(String var1);

        public Builder spreadLevel(SpreadLevel var1);
    }
}

