/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionPublicIpv4PoolCidrResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ProvisionPublicIpv4PoolCidrResponse> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(ProvisionPublicIpv4PoolCidrResponse.getter(ProvisionPublicIpv4PoolCidrResponse::poolId)).setter(ProvisionPublicIpv4PoolCidrResponse.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("poolId").build()}).build();
    private static final SdkField<PublicIpv4PoolRange> POOL_ADDRESS_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PoolAddressRange").getter(ProvisionPublicIpv4PoolCidrResponse.getter(ProvisionPublicIpv4PoolCidrResponse::poolAddressRange)).setter(ProvisionPublicIpv4PoolCidrResponse.setter(Builder::poolAddressRange)).constructor(PublicIpv4PoolRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolAddressRange").unmarshallLocationName("poolAddressRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, POOL_ADDRESS_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionPublicIpv4PoolCidrResponse.memberNameToFieldInitializer();
    private final String poolId;
    private final PublicIpv4PoolRange poolAddressRange;

    private ProvisionPublicIpv4PoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.poolAddressRange = builder.poolAddressRange;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final PublicIpv4PoolRange poolAddressRange() {
        return this.poolAddressRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolAddressRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionPublicIpv4PoolCidrResponse)) {
            return false;
        }
        ProvisionPublicIpv4PoolCidrResponse other = (ProvisionPublicIpv4PoolCidrResponse)((Object)obj);
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.poolAddressRange(), other.poolAddressRange());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionPublicIpv4PoolCidrResponse").add("PoolId", (Object)this.poolId()).add("PoolAddressRange", (Object)this.poolAddressRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "PoolAddressRange": {
                return Optional.ofNullable(clazz.cast(this.poolAddressRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("PoolAddressRange", POOL_ADDRESS_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionPublicIpv4PoolCidrResponse, T> g) {
        return obj -> g.apply((ProvisionPublicIpv4PoolCidrResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String poolId;
        private PublicIpv4PoolRange poolAddressRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionPublicIpv4PoolCidrResponse model) {
            super(model);
            this.poolId(model.poolId);
            this.poolAddressRange(model.poolAddressRange);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final PublicIpv4PoolRange.Builder getPoolAddressRange() {
            return this.poolAddressRange != null ? this.poolAddressRange.toBuilder() : null;
        }

        public final void setPoolAddressRange(PublicIpv4PoolRange.BuilderImpl poolAddressRange) {
            this.poolAddressRange = poolAddressRange != null ? poolAddressRange.build() : null;
        }

        @Override
        public final Builder poolAddressRange(PublicIpv4PoolRange poolAddressRange) {
            this.poolAddressRange = poolAddressRange;
            return this;
        }

        @Override
        public ProvisionPublicIpv4PoolCidrResponse build() {
            return new ProvisionPublicIpv4PoolCidrResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionPublicIpv4PoolCidrResponse> {
        public Builder poolId(String var1);

        public Builder poolAddressRange(PublicIpv4PoolRange var1);

        default public Builder poolAddressRange(Consumer<PublicIpv4PoolRange.Builder> poolAddressRange) {
            return this.poolAddressRange((PublicIpv4PoolRange)((PublicIpv4PoolRange.Builder)PublicIpv4PoolRange.builder().applyMutation(poolAddressRange)).build());
        }
    }
}

