/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedAccessEndpointsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeVerifiedAccessEndpointsRequest> {
    private static final SdkField<List<String>> VERIFIED_ACCESS_ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessEndpointIds").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessEndpointIds)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::verifiedAccessEndpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId").unmarshallLocationName("VerifiedAccessEndpointId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessInstanceId)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("VerifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::verifiedAccessGroupId)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("VerifiedAccessGroupId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::maxResults)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::nextToken)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::filters)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeVerifiedAccessEndpointsRequest.getter(DescribeVerifiedAccessEndpointsRequest::dryRun)).setter(DescribeVerifiedAccessEndpointsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_ENDPOINT_IDS_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, VERIFIED_ACCESS_GROUP_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VerifiedAccessEndpointId", VERIFIED_ACCESS_ENDPOINT_IDS_FIELD);
            this.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
            this.put("VerifiedAccessGroupId", VERIFIED_ACCESS_GROUP_ID_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Filter", FILTERS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final List<String> verifiedAccessEndpointIds;
    private final String verifiedAccessInstanceId;
    private final String verifiedAccessGroupId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<Filter> filters;
    private final Boolean dryRun;

    private DescribeVerifiedAccessEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointIds = builder.verifiedAccessEndpointIds;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.dryRun = builder.dryRun;
    }

    public final boolean hasVerifiedAccessEndpointIds() {
        return this.verifiedAccessEndpointIds != null && !(this.verifiedAccessEndpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> verifiedAccessEndpointIds() {
        return this.verifiedAccessEndpointIds;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessEndpointIds() ? this.verifiedAccessEndpointIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessEndpointsRequest)) {
            return false;
        }
        DescribeVerifiedAccessEndpointsRequest other = (DescribeVerifiedAccessEndpointsRequest)((Object)obj);
        return this.hasVerifiedAccessEndpointIds() == other.hasVerifiedAccessEndpointIds() && Objects.equals(this.verifiedAccessEndpointIds(), other.verifiedAccessEndpointIds()) && Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedAccessEndpointsRequest").add("VerifiedAccessEndpointIds", this.hasVerifiedAccessEndpointIds() ? this.verifiedAccessEndpointIds() : null).add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Filters", this.hasFilters() ? this.filters() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessEndpointIds": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpointIds()));
            }
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessEndpointsRequest, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessEndpointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> verifiedAccessEndpointIds = DefaultSdkAutoConstructList.getInstance();
        private String verifiedAccessInstanceId;
        private String verifiedAccessGroupId;
        private Integer maxResults;
        private String nextToken;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessEndpointsRequest model) {
            super(model);
            this.verifiedAccessEndpointIds(model.verifiedAccessEndpointIds);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
            this.dryRun(model.dryRun);
        }

        public final Collection<String> getVerifiedAccessEndpointIds() {
            if (this.verifiedAccessEndpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.verifiedAccessEndpointIds;
        }

        public final void setVerifiedAccessEndpointIds(Collection<String> verifiedAccessEndpointIds) {
            this.verifiedAccessEndpointIds = VerifiedAccessEndpointIdListCopier.copy(verifiedAccessEndpointIds);
        }

        @Override
        public final Builder verifiedAccessEndpointIds(Collection<String> verifiedAccessEndpointIds) {
            this.verifiedAccessEndpointIds = VerifiedAccessEndpointIdListCopier.copy(verifiedAccessEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpointIds(String ... verifiedAccessEndpointIds) {
            this.verifiedAccessEndpointIds(Arrays.asList(verifiedAccessEndpointIds));
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVerifiedAccessEndpointsRequest build() {
            return new DescribeVerifiedAccessEndpointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedAccessEndpointsRequest> {
        public Builder verifiedAccessEndpointIds(Collection<String> var1);

        public Builder verifiedAccessEndpointIds(String ... var1);

        public Builder verifiedAccessInstanceId(String var1);

        public Builder verifiedAccessGroupId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

