/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroupSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocalGatewayVirtualInterfaceGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLocalGatewayVirtualInterfaceGroupsResponse> {
    private static final SdkField<List<LocalGatewayVirtualInterfaceGroup>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalGatewayVirtualInterfaceGroups").getter(DescribeLocalGatewayVirtualInterfaceGroupsResponse.getter(DescribeLocalGatewayVirtualInterfaceGroupsResponse::localGatewayVirtualInterfaceGroups)).setter(DescribeLocalGatewayVirtualInterfaceGroupsResponse.setter(Builder::localGatewayVirtualInterfaceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupSet").unmarshallLocationName("localGatewayVirtualInterfaceGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalGatewayVirtualInterfaceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLocalGatewayVirtualInterfaceGroupsResponse.getter(DescribeLocalGatewayVirtualInterfaceGroupsResponse::nextToken)).setter(DescribeLocalGatewayVirtualInterfaceGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LocalGatewayVirtualInterfaceGroupSet", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUPS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LocalGatewayVirtualInterfaceGroup> localGatewayVirtualInterfaceGroups;
    private final String nextToken;

    private DescribeLocalGatewayVirtualInterfaceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayVirtualInterfaceGroups = builder.localGatewayVirtualInterfaceGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLocalGatewayVirtualInterfaceGroups() {
        return this.localGatewayVirtualInterfaceGroups != null && !(this.localGatewayVirtualInterfaceGroups instanceof SdkAutoConstructList);
    }

    public final List<LocalGatewayVirtualInterfaceGroup> localGatewayVirtualInterfaceGroups() {
        return this.localGatewayVirtualInterfaceGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalGatewayVirtualInterfaceGroups() ? this.localGatewayVirtualInterfaceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayVirtualInterfaceGroupsResponse)) {
            return false;
        }
        DescribeLocalGatewayVirtualInterfaceGroupsResponse other = (DescribeLocalGatewayVirtualInterfaceGroupsResponse)((Object)obj);
        return this.hasLocalGatewayVirtualInterfaceGroups() == other.hasLocalGatewayVirtualInterfaceGroups() && Objects.equals(this.localGatewayVirtualInterfaceGroups(), other.localGatewayVirtualInterfaceGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocalGatewayVirtualInterfaceGroupsResponse").add("LocalGatewayVirtualInterfaceGroups", this.hasLocalGatewayVirtualInterfaceGroups() ? this.localGatewayVirtualInterfaceGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaceGroups": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayVirtualInterfaceGroupsResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayVirtualInterfaceGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LocalGatewayVirtualInterfaceGroup> localGatewayVirtualInterfaceGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayVirtualInterfaceGroupsResponse model) {
            super(model);
            this.localGatewayVirtualInterfaceGroups(model.localGatewayVirtualInterfaceGroups);
            this.nextToken(model.nextToken);
        }

        public final List<LocalGatewayVirtualInterfaceGroup.Builder> getLocalGatewayVirtualInterfaceGroups() {
            List<LocalGatewayVirtualInterfaceGroup.Builder> result = LocalGatewayVirtualInterfaceGroupSetCopier.copyToBuilder(this.localGatewayVirtualInterfaceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalGatewayVirtualInterfaceGroups(Collection<LocalGatewayVirtualInterfaceGroup.BuilderImpl> localGatewayVirtualInterfaceGroups) {
            this.localGatewayVirtualInterfaceGroups = LocalGatewayVirtualInterfaceGroupSetCopier.copyFromBuilder(localGatewayVirtualInterfaceGroups);
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroups(Collection<LocalGatewayVirtualInterfaceGroup> localGatewayVirtualInterfaceGroups) {
            this.localGatewayVirtualInterfaceGroups = LocalGatewayVirtualInterfaceGroupSetCopier.copy(localGatewayVirtualInterfaceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceGroups(LocalGatewayVirtualInterfaceGroup ... localGatewayVirtualInterfaceGroups) {
            this.localGatewayVirtualInterfaceGroups(Arrays.asList(localGatewayVirtualInterfaceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceGroups(Consumer<LocalGatewayVirtualInterfaceGroup.Builder> ... localGatewayVirtualInterfaceGroups) {
            this.localGatewayVirtualInterfaceGroups(Stream.of(localGatewayVirtualInterfaceGroups).map(c -> (LocalGatewayVirtualInterfaceGroup)((LocalGatewayVirtualInterfaceGroup.Builder)LocalGatewayVirtualInterfaceGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLocalGatewayVirtualInterfaceGroupsResponse build() {
            return new DescribeLocalGatewayVirtualInterfaceGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocalGatewayVirtualInterfaceGroupsResponse> {
        public Builder localGatewayVirtualInterfaceGroups(Collection<LocalGatewayVirtualInterfaceGroup> var1);

        public Builder localGatewayVirtualInterfaceGroups(LocalGatewayVirtualInterfaceGroup ... var1);

        public Builder localGatewayVirtualInterfaceGroups(Consumer<LocalGatewayVirtualInterfaceGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

