/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignIpv6AddressesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssignIpv6AddressesRequest> {
    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6PrefixCount").getter(AssignIpv6AddressesRequest.getter(AssignIpv6AddressesRequest::ipv6PrefixCount)).setter(AssignIpv6AddressesRequest.setter(Builder::ipv6PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").unmarshallLocationName("Ipv6PrefixCount").build()}).build();
    private static final SdkField<List<String>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(AssignIpv6AddressesRequest.getter(AssignIpv6AddressesRequest::ipv6Prefixes)).setter(AssignIpv6AddressesRequest.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix").unmarshallLocationName("Ipv6Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AssignIpv6AddressesRequest.getter(AssignIpv6AddressesRequest::networkInterfaceId)).setter(AssignIpv6AddressesRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(AssignIpv6AddressesRequest.getter(AssignIpv6AddressesRequest::ipv6Addresses)).setter(AssignIpv6AddressesRequest.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").unmarshallLocationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(AssignIpv6AddressesRequest.getter(AssignIpv6AddressesRequest::ipv6AddressCount)).setter(AssignIpv6AddressesRequest.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("ipv6AddressCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, NETWORK_INTERFACE_ID_FIELD, IPV6_ADDRESSES_FIELD, IPV6_ADDRESS_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Ipv6PrefixCount", IPV6_PREFIX_COUNT_FIELD);
            this.put("Ipv6Prefix", IPV6_PREFIXES_FIELD);
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
            this.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        }
    });
    private final Integer ipv6PrefixCount;
    private final List<String> ipv6Prefixes;
    private final String networkInterfaceId;
    private final List<String> ipv6Addresses;
    private final Integer ipv6AddressCount;

    private AssignIpv6AddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6AddressCount = builder.ipv6AddressCount;
    }

    public final Integer ipv6PrefixCount() {
        return this.ipv6PrefixCount;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesRequest)) {
            return false;
        }
        AssignIpv6AddressesRequest other = (AssignIpv6AddressesRequest)((Object)obj);
        return Objects.equals(this.ipv6PrefixCount(), other.ipv6PrefixCount()) && this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount());
    }

    public final String toString() {
        return ToString.builder((String)"AssignIpv6AddressesRequest").add("Ipv6PrefixCount", (Object)this.ipv6PrefixCount()).add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6PrefixCount()));
            }
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssignIpv6AddressesRequest, T> g) {
        return obj -> g.apply((AssignIpv6AddressesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Integer ipv6PrefixCount;
        private List<String> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesRequest model) {
            super(model);
            this.ipv6PrefixCount(model.ipv6PrefixCount);
            this.ipv6Prefixes(model.ipv6Prefixes);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ipv6Addresses(model.ipv6Addresses);
            this.ipv6AddressCount(model.ipv6AddressCount);
        }

        public final Integer getIpv6PrefixCount() {
            return this.ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final Collection<String> getIpv6Prefixes() {
            if (this.ipv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Prefixes;
        }

        public final void setIpv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(String ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (this.ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignIpv6AddressesRequest build() {
            return new AssignIpv6AddressesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignIpv6AddressesRequest> {
        public Builder ipv6PrefixCount(Integer var1);

        public Builder ipv6Prefixes(Collection<String> var1);

        public Builder ipv6Prefixes(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

