/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget;

public class DescribeTrafficMirrorTargetsIterable
implements SdkIterable<DescribeTrafficMirrorTargetsResponse> {
    private final Ec2Client client;
    private final DescribeTrafficMirrorTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrafficMirrorTargetsIterable(Ec2Client client, DescribeTrafficMirrorTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrafficMirrorTargetsResponseFetcher();
    }

    public Iterator<DescribeTrafficMirrorTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficMirrorTarget> trafficMirrorTargets() {
        Function<DescribeTrafficMirrorTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficMirrorTargets() != null) {
                return response.trafficMirrorTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrafficMirrorTargetsResponseFetcher
    implements SyncPageFetcher<DescribeTrafficMirrorTargetsResponse> {
        private DescribeTrafficMirrorTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrafficMirrorTargetsResponse nextPage(DescribeTrafficMirrorTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorTargetsIterable.this.client.describeTrafficMirrorTargets(DescribeTrafficMirrorTargetsIterable.this.firstRequest);
            }
            return DescribeTrafficMirrorTargetsIterable.this.client.describeTrafficMirrorTargets((DescribeTrafficMirrorTargetsRequest)((Object)DescribeTrafficMirrorTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

