/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociation;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecurityGroupVpcAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSecurityGroupVpcAssociationsResponse> {
    private static final SdkField<List<SecurityGroupVpcAssociation>> SECURITY_GROUP_VPC_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupVpcAssociations").getter(DescribeSecurityGroupVpcAssociationsResponse.getter(DescribeSecurityGroupVpcAssociationsResponse::securityGroupVpcAssociations)).setter(DescribeSecurityGroupVpcAssociationsResponse.setter(Builder::securityGroupVpcAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupVpcAssociationSet").unmarshallLocationName("securityGroupVpcAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupVpcAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSecurityGroupVpcAssociationsResponse.getter(DescribeSecurityGroupVpcAssociationsResponse::nextToken)).setter(DescribeSecurityGroupVpcAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_VPC_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SecurityGroupVpcAssociation> securityGroupVpcAssociations;
    private final String nextToken;

    private DescribeSecurityGroupVpcAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupVpcAssociations = builder.securityGroupVpcAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityGroupVpcAssociations() {
        return this.securityGroupVpcAssociations != null && !(this.securityGroupVpcAssociations instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupVpcAssociation> securityGroupVpcAssociations() {
        return this.securityGroupVpcAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupVpcAssociations() ? this.securityGroupVpcAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupVpcAssociationsResponse)) {
            return false;
        }
        DescribeSecurityGroupVpcAssociationsResponse other = (DescribeSecurityGroupVpcAssociationsResponse)((Object)obj);
        return this.hasSecurityGroupVpcAssociations() == other.hasSecurityGroupVpcAssociations() && Objects.equals(this.securityGroupVpcAssociations(), other.securityGroupVpcAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSecurityGroupVpcAssociationsResponse").add("SecurityGroupVpcAssociations", this.hasSecurityGroupVpcAssociations() ? this.securityGroupVpcAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupVpcAssociations": {
                return Optional.ofNullable(clazz.cast(this.securityGroupVpcAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupVpcAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeSecurityGroupVpcAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SecurityGroupVpcAssociation> securityGroupVpcAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupVpcAssociationsResponse model) {
            super(model);
            this.securityGroupVpcAssociations(model.securityGroupVpcAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityGroupVpcAssociation.Builder> getSecurityGroupVpcAssociations() {
            List<SecurityGroupVpcAssociation.Builder> result = SecurityGroupVpcAssociationListCopier.copyToBuilder(this.securityGroupVpcAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupVpcAssociations(Collection<SecurityGroupVpcAssociation.BuilderImpl> securityGroupVpcAssociations) {
            this.securityGroupVpcAssociations = SecurityGroupVpcAssociationListCopier.copyFromBuilder(securityGroupVpcAssociations);
        }

        @Override
        public final Builder securityGroupVpcAssociations(Collection<SecurityGroupVpcAssociation> securityGroupVpcAssociations) {
            this.securityGroupVpcAssociations = SecurityGroupVpcAssociationListCopier.copy(securityGroupVpcAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupVpcAssociations(SecurityGroupVpcAssociation ... securityGroupVpcAssociations) {
            this.securityGroupVpcAssociations(Arrays.asList(securityGroupVpcAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupVpcAssociations(Consumer<SecurityGroupVpcAssociation.Builder> ... securityGroupVpcAssociations) {
            this.securityGroupVpcAssociations(Stream.of(securityGroupVpcAssociations).map(c -> (SecurityGroupVpcAssociation)((SecurityGroupVpcAssociation.Builder)SecurityGroupVpcAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSecurityGroupVpcAssociationsResponse build() {
            return new DescribeSecurityGroupVpcAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSecurityGroupVpcAssociationsResponse> {
        public Builder securityGroupVpcAssociations(Collection<SecurityGroupVpcAssociation> var1);

        public Builder securityGroupVpcAssociations(SecurityGroupVpcAssociation ... var1);

        public Builder securityGroupVpcAssociations(Consumer<SecurityGroupVpcAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

