/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateSecurityGroupVpcResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DisassociateSecurityGroupVpcResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DisassociateSecurityGroupVpcResponse.getter(DisassociateSecurityGroupVpcResponse::stateAsString)).setter(DisassociateSecurityGroupVpcResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateSecurityGroupVpcResponse.memberNameToFieldInitializer();
    private final String state;

    private DisassociateSecurityGroupVpcResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
    }

    public final SecurityGroupVpcAssociationState state() {
        return SecurityGroupVpcAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSecurityGroupVpcResponse)) {
            return false;
        }
        DisassociateSecurityGroupVpcResponse other = (DisassociateSecurityGroupVpcResponse)((Object)obj);
        return Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateSecurityGroupVpcResponse").add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSecurityGroupVpcResponse, T> g) {
        return obj -> g.apply((DisassociateSecurityGroupVpcResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSecurityGroupVpcResponse model) {
            super(model);
            this.state(model.state);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecurityGroupVpcAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DisassociateSecurityGroupVpcResponse build() {
            return new DisassociateSecurityGroupVpcResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateSecurityGroupVpcResponse> {
        public Builder state(String var1);

        public Builder state(SecurityGroupVpcAssociationState var1);
    }
}

