/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceBandwidthWeighting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceNetworkPerformanceOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceNetworkPerformanceOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceNetworkPerformanceOptionsResponse.getter(ModifyInstanceNetworkPerformanceOptionsResponse::instanceId)).setter(ModifyInstanceNetworkPerformanceOptionsResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> BANDWIDTH_WEIGHTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BandwidthWeighting").getter(ModifyInstanceNetworkPerformanceOptionsResponse.getter(ModifyInstanceNetworkPerformanceOptionsResponse::bandwidthWeightingAsString)).setter(ModifyInstanceNetworkPerformanceOptionsResponse.setter(Builder::bandwidthWeighting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthWeighting").unmarshallLocationName("bandwidthWeighting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, BANDWIDTH_WEIGHTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("BandwidthWeighting", BANDWIDTH_WEIGHTING_FIELD);
        }
    });
    private final String instanceId;
    private final String bandwidthWeighting;

    private ModifyInstanceNetworkPerformanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.bandwidthWeighting = builder.bandwidthWeighting;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceBandwidthWeighting bandwidthWeighting() {
        return InstanceBandwidthWeighting.fromValue(this.bandwidthWeighting);
    }

    public final String bandwidthWeightingAsString() {
        return this.bandwidthWeighting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthWeightingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceNetworkPerformanceOptionsResponse)) {
            return false;
        }
        ModifyInstanceNetworkPerformanceOptionsResponse other = (ModifyInstanceNetworkPerformanceOptionsResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.bandwidthWeightingAsString(), other.bandwidthWeightingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceNetworkPerformanceOptionsResponse").add("InstanceId", (Object)this.instanceId()).add("BandwidthWeighting", (Object)this.bandwidthWeightingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "BandwidthWeighting": {
                return Optional.ofNullable(clazz.cast(this.bandwidthWeightingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceNetworkPerformanceOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceNetworkPerformanceOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String bandwidthWeighting;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceNetworkPerformanceOptionsResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.bandwidthWeighting(model.bandwidthWeighting);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getBandwidthWeighting() {
            return this.bandwidthWeighting;
        }

        public final void setBandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
        }

        @Override
        public final Builder bandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
            return this;
        }

        @Override
        public final Builder bandwidthWeighting(InstanceBandwidthWeighting bandwidthWeighting) {
            this.bandwidthWeighting(bandwidthWeighting == null ? null : bandwidthWeighting.toString());
            return this;
        }

        @Override
        public ModifyInstanceNetworkPerformanceOptionsResponse build() {
            return new ModifyInstanceNetworkPerformanceOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceNetworkPerformanceOptionsResponse> {
        public Builder instanceId(String var1);

        public Builder bandwidthWeighting(String var1);

        public Builder bandwidthWeighting(InstanceBandwidthWeighting var1);
    }
}

