/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3Destination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessLogs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessLogs> {
    private static final SdkField<VerifiedAccessLogS3Destination> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(VerifiedAccessLogs.getter(VerifiedAccessLogs::s3)).setter(VerifiedAccessLogs.setter(Builder::s3)).constructor(VerifiedAccessLogS3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").unmarshallLocationName("s3").build()}).build();
    private static final SdkField<VerifiedAccessLogCloudWatchLogsDestination> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogs").getter(VerifiedAccessLogs.getter(VerifiedAccessLogs::cloudWatchLogs)).setter(VerifiedAccessLogs.setter(Builder::cloudWatchLogs)).constructor(VerifiedAccessLogCloudWatchLogsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogs").unmarshallLocationName("cloudWatchLogs").build()}).build();
    private static final SdkField<VerifiedAccessLogKinesisDataFirehoseDestination> KINESIS_DATA_FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisDataFirehose").getter(VerifiedAccessLogs.getter(VerifiedAccessLogs::kinesisDataFirehose)).setter(VerifiedAccessLogs.setter(Builder::kinesisDataFirehose)).constructor(VerifiedAccessLogKinesisDataFirehoseDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataFirehose").unmarshallLocationName("kinesisDataFirehose").build()}).build();
    private static final SdkField<String> LOG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogVersion").getter(VerifiedAccessLogs.getter(VerifiedAccessLogs::logVersion)).setter(VerifiedAccessLogs.setter(Builder::logVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogVersion").unmarshallLocationName("logVersion").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TRUST_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTrustContext").getter(VerifiedAccessLogs.getter(VerifiedAccessLogs::includeTrustContext)).setter(VerifiedAccessLogs.setter(Builder::includeTrustContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTrustContext").unmarshallLocationName("includeTrustContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, CLOUD_WATCH_LOGS_FIELD, KINESIS_DATA_FIREHOSE_FIELD, LOG_VERSION_FIELD, INCLUDE_TRUST_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3", S3_FIELD);
            this.put("CloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
            this.put("KinesisDataFirehose", KINESIS_DATA_FIREHOSE_FIELD);
            this.put("LogVersion", LOG_VERSION_FIELD);
            this.put("IncludeTrustContext", INCLUDE_TRUST_CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final VerifiedAccessLogS3Destination s3;
    private final VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs;
    private final VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose;
    private final String logVersion;
    private final Boolean includeTrustContext;

    private VerifiedAccessLogs(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.kinesisDataFirehose = builder.kinesisDataFirehose;
        this.logVersion = builder.logVersion;
        this.includeTrustContext = builder.includeTrustContext;
    }

    public final VerifiedAccessLogS3Destination s3() {
        return this.s3;
    }

    public final VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose() {
        return this.kinesisDataFirehose;
    }

    public final String logVersion() {
        return this.logVersion;
    }

    public final Boolean includeTrustContext() {
        return this.includeTrustContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisDataFirehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.logVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTrustContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogs)) {
            return false;
        }
        VerifiedAccessLogs other = (VerifiedAccessLogs)obj;
        return Objects.equals(this.s3(), other.s3()) && Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.kinesisDataFirehose(), other.kinesisDataFirehose()) && Objects.equals(this.logVersion(), other.logVersion()) && Objects.equals(this.includeTrustContext(), other.includeTrustContext());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessLogs").add("S3", (Object)this.s3()).add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("KinesisDataFirehose", (Object)this.kinesisDataFirehose()).add("LogVersion", (Object)this.logVersion()).add("IncludeTrustContext", (Object)this.includeTrustContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "CloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "KinesisDataFirehose": {
                return Optional.ofNullable(clazz.cast(this.kinesisDataFirehose()));
            }
            case "LogVersion": {
                return Optional.ofNullable(clazz.cast(this.logVersion()));
            }
            case "IncludeTrustContext": {
                return Optional.ofNullable(clazz.cast(this.includeTrustContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogs, T> g) {
        return obj -> g.apply((VerifiedAccessLogs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VerifiedAccessLogS3Destination s3;
        private VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs;
        private VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose;
        private String logVersion;
        private Boolean includeTrustContext;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogs model) {
            this.s3(model.s3);
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.kinesisDataFirehose(model.kinesisDataFirehose);
            this.logVersion(model.logVersion);
            this.includeTrustContext(model.includeTrustContext);
        }

        public final VerifiedAccessLogS3Destination.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(VerifiedAccessLogS3Destination.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(VerifiedAccessLogS3Destination s3) {
            this.s3 = s3;
            return this;
        }

        public final VerifiedAccessLogCloudWatchLogsDestination.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final VerifiedAccessLogKinesisDataFirehoseDestination.Builder getKinesisDataFirehose() {
            return this.kinesisDataFirehose != null ? this.kinesisDataFirehose.toBuilder() : null;
        }

        public final void setKinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination.BuilderImpl kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose != null ? kinesisDataFirehose.build() : null;
        }

        @Override
        public final Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose;
            return this;
        }

        public final String getLogVersion() {
            return this.logVersion;
        }

        public final void setLogVersion(String logVersion) {
            this.logVersion = logVersion;
        }

        @Override
        public final Builder logVersion(String logVersion) {
            this.logVersion = logVersion;
            return this;
        }

        public final Boolean getIncludeTrustContext() {
            return this.includeTrustContext;
        }

        public final void setIncludeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
        }

        @Override
        public final Builder includeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
            return this;
        }

        public VerifiedAccessLogs build() {
            return new VerifiedAccessLogs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessLogs> {
        public Builder s3(VerifiedAccessLogS3Destination var1);

        default public Builder s3(Consumer<VerifiedAccessLogS3Destination.Builder> s3) {
            return this.s3((VerifiedAccessLogS3Destination)((VerifiedAccessLogS3Destination.Builder)VerifiedAccessLogS3Destination.builder().applyMutation(s3)).build());
        }

        public Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestination var1);

        default public Builder cloudWatchLogs(Consumer<VerifiedAccessLogCloudWatchLogsDestination.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((VerifiedAccessLogCloudWatchLogsDestination)((VerifiedAccessLogCloudWatchLogsDestination.Builder)VerifiedAccessLogCloudWatchLogsDestination.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestination var1);

        default public Builder kinesisDataFirehose(Consumer<VerifiedAccessLogKinesisDataFirehoseDestination.Builder> kinesisDataFirehose) {
            return this.kinesisDataFirehose((VerifiedAccessLogKinesisDataFirehoseDestination)((VerifiedAccessLogKinesisDataFirehoseDestination.Builder)VerifiedAccessLogKinesisDataFirehoseDestination.builder().applyMutation(kinesisDataFirehose)).build());
        }

        public Builder logVersion(String var1);

        public Builder includeTrustContext(Boolean var1);
    }
}

