/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AdditionalDetail;
import software.amazon.awssdk.services.ec2.model.AdditionalDetailListCopier;
import software.amazon.awssdk.services.ec2.model.AnalysisAclRule;
import software.amazon.awssdk.services.ec2.model.AnalysisComponent;
import software.amazon.awssdk.services.ec2.model.AnalysisPacketHeader;
import software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute;
import software.amazon.awssdk.services.ec2.model.AnalysisSecurityGroupRule;
import software.amazon.awssdk.services.ec2.model.Explanation;
import software.amazon.awssdk.services.ec2.model.ExplanationListCopier;
import software.amazon.awssdk.services.ec2.model.FirewallStatefulRule;
import software.amazon.awssdk.services.ec2.model.FirewallStatelessRule;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SequenceNumber").getter(PathComponent.getter(PathComponent::sequenceNumber)).setter(PathComponent.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").unmarshallLocationName("sequenceNumber").build()}).build();
    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AclRule").getter(PathComponent.getter(PathComponent::aclRule)).setter(PathComponent.setter(Builder::aclRule)).constructor(AnalysisAclRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule").unmarshallLocationName("aclRule").build()}).build();
    private static final SdkField<AnalysisComponent> ATTACHED_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachedTo").getter(PathComponent.getter(PathComponent::attachedTo)).setter(PathComponent.setter(Builder::attachedTo)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedTo").unmarshallLocationName("attachedTo").build()}).build();
    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Component").getter(PathComponent.getter(PathComponent::component)).setter(PathComponent.setter(Builder::component)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").unmarshallLocationName("component").build()}).build();
    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationVpc").getter(PathComponent.getter(PathComponent::destinationVpc)).setter(PathComponent.setter(Builder::destinationVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc").unmarshallLocationName("destinationVpc").build()}).build();
    private static final SdkField<AnalysisPacketHeader> OUTBOUND_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundHeader").getter(PathComponent.getter(PathComponent::outboundHeader)).setter(PathComponent.setter(Builder::outboundHeader)).constructor(AnalysisPacketHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHeader").unmarshallLocationName("outboundHeader").build()}).build();
    private static final SdkField<AnalysisPacketHeader> INBOUND_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InboundHeader").getter(PathComponent.getter(PathComponent::inboundHeader)).setter(PathComponent.setter(Builder::inboundHeader)).constructor(AnalysisPacketHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundHeader").unmarshallLocationName("inboundHeader").build()}).build();
    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableRoute").getter(PathComponent.getter(PathComponent::routeTableRoute)).setter(PathComponent.setter(Builder::routeTableRoute)).constructor(AnalysisRouteTableRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute").unmarshallLocationName("routeTableRoute").build()}).build();
    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityGroupRule").getter(PathComponent.getter(PathComponent::securityGroupRule)).setter(PathComponent.setter(Builder::securityGroupRule)).constructor(AnalysisSecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule").unmarshallLocationName("securityGroupRule").build()}).build();
    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceVpc").getter(PathComponent.getter(PathComponent::sourceVpc)).setter(PathComponent.setter(Builder::sourceVpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc").unmarshallLocationName("sourceVpc").build()}).build();
    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(PathComponent.getter(PathComponent::subnet)).setter(PathComponent.setter(Builder::subnet)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(PathComponent.getter(PathComponent::vpc)).setter(PathComponent.setter(Builder::vpc)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc").build()}).build();
    private static final SdkField<List<AdditionalDetail>> ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalDetails").getter(PathComponent.getter(PathComponent::additionalDetails)).setter(PathComponent.setter(Builder::additionalDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetailSet").unmarshallLocationName("additionalDetailSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> TRANSIT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGateway").getter(PathComponent.getter(PathComponent::transitGateway)).setter(PathComponent.setter(Builder::transitGateway)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGateway").unmarshallLocationName("transitGateway").build()}).build();
    private static final SdkField<TransitGatewayRouteTableRoute> TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitGatewayRouteTableRoute").getter(PathComponent.getter(PathComponent::transitGatewayRouteTableRoute)).setter(PathComponent.setter(Builder::transitGatewayRouteTableRoute)).constructor(TransitGatewayRouteTableRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableRoute").unmarshallLocationName("transitGatewayRouteTableRoute").build()}).build();
    private static final SdkField<List<Explanation>> EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Explanations").getter(PathComponent.getter(PathComponent::explanations)).setter(PathComponent.setter(Builder::explanations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplanationSet").unmarshallLocationName("explanationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Explanation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AnalysisComponent> ELASTIC_LOAD_BALANCER_LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticLoadBalancerListener").getter(PathComponent.getter(PathComponent::elasticLoadBalancerListener)).setter(PathComponent.setter(Builder::elasticLoadBalancerListener)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerListener").unmarshallLocationName("elasticLoadBalancerListener").build()}).build();
    private static final SdkField<FirewallStatelessRule> FIREWALL_STATELESS_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallStatelessRule").getter(PathComponent.getter(PathComponent::firewallStatelessRule)).setter(PathComponent.setter(Builder::firewallStatelessRule)).constructor(FirewallStatelessRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatelessRule").unmarshallLocationName("firewallStatelessRule").build()}).build();
    private static final SdkField<FirewallStatefulRule> FIREWALL_STATEFUL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallStatefulRule").getter(PathComponent.getter(PathComponent::firewallStatefulRule)).setter(PathComponent.setter(Builder::firewallStatefulRule)).constructor(FirewallStatefulRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallStatefulRule").unmarshallLocationName("firewallStatefulRule").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(PathComponent.getter(PathComponent::serviceName)).setter(PathComponent.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_NUMBER_FIELD, ACL_RULE_FIELD, ATTACHED_TO_FIELD, COMPONENT_FIELD, DESTINATION_VPC_FIELD, OUTBOUND_HEADER_FIELD, INBOUND_HEADER_FIELD, ROUTE_TABLE_ROUTE_FIELD, SECURITY_GROUP_RULE_FIELD, SOURCE_VPC_FIELD, SUBNET_FIELD, VPC_FIELD, ADDITIONAL_DETAILS_FIELD, TRANSIT_GATEWAY_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD, EXPLANATIONS_FIELD, ELASTIC_LOAD_BALANCER_LISTENER_FIELD, FIREWALL_STATELESS_RULE_FIELD, FIREWALL_STATEFUL_RULE_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SequenceNumber", SEQUENCE_NUMBER_FIELD);
            this.put("AclRule", ACL_RULE_FIELD);
            this.put("AttachedTo", ATTACHED_TO_FIELD);
            this.put("Component", COMPONENT_FIELD);
            this.put("DestinationVpc", DESTINATION_VPC_FIELD);
            this.put("OutboundHeader", OUTBOUND_HEADER_FIELD);
            this.put("InboundHeader", INBOUND_HEADER_FIELD);
            this.put("RouteTableRoute", ROUTE_TABLE_ROUTE_FIELD);
            this.put("SecurityGroupRule", SECURITY_GROUP_RULE_FIELD);
            this.put("SourceVpc", SOURCE_VPC_FIELD);
            this.put("Subnet", SUBNET_FIELD);
            this.put("Vpc", VPC_FIELD);
            this.put("AdditionalDetailSet", ADDITIONAL_DETAILS_FIELD);
            this.put("TransitGateway", TRANSIT_GATEWAY_FIELD);
            this.put("TransitGatewayRouteTableRoute", TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD);
            this.put("ExplanationSet", EXPLANATIONS_FIELD);
            this.put("ElasticLoadBalancerListener", ELASTIC_LOAD_BALANCER_LISTENER_FIELD);
            this.put("FirewallStatelessRule", FIREWALL_STATELESS_RULE_FIELD);
            this.put("FirewallStatefulRule", FIREWALL_STATEFUL_RULE_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer sequenceNumber;
    private final AnalysisAclRule aclRule;
    private final AnalysisComponent attachedTo;
    private final AnalysisComponent component;
    private final AnalysisComponent destinationVpc;
    private final AnalysisPacketHeader outboundHeader;
    private final AnalysisPacketHeader inboundHeader;
    private final AnalysisRouteTableRoute routeTableRoute;
    private final AnalysisSecurityGroupRule securityGroupRule;
    private final AnalysisComponent sourceVpc;
    private final AnalysisComponent subnet;
    private final AnalysisComponent vpc;
    private final List<AdditionalDetail> additionalDetails;
    private final AnalysisComponent transitGateway;
    private final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;
    private final List<Explanation> explanations;
    private final AnalysisComponent elasticLoadBalancerListener;
    private final FirewallStatelessRule firewallStatelessRule;
    private final FirewallStatefulRule firewallStatefulRule;
    private final String serviceName;

    private PathComponent(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.aclRule = builder.aclRule;
        this.attachedTo = builder.attachedTo;
        this.component = builder.component;
        this.destinationVpc = builder.destinationVpc;
        this.outboundHeader = builder.outboundHeader;
        this.inboundHeader = builder.inboundHeader;
        this.routeTableRoute = builder.routeTableRoute;
        this.securityGroupRule = builder.securityGroupRule;
        this.sourceVpc = builder.sourceVpc;
        this.subnet = builder.subnet;
        this.vpc = builder.vpc;
        this.additionalDetails = builder.additionalDetails;
        this.transitGateway = builder.transitGateway;
        this.transitGatewayRouteTableRoute = builder.transitGatewayRouteTableRoute;
        this.explanations = builder.explanations;
        this.elasticLoadBalancerListener = builder.elasticLoadBalancerListener;
        this.firewallStatelessRule = builder.firewallStatelessRule;
        this.firewallStatefulRule = builder.firewallStatefulRule;
        this.serviceName = builder.serviceName;
    }

    public final Integer sequenceNumber() {
        return this.sequenceNumber;
    }

    public final AnalysisAclRule aclRule() {
        return this.aclRule;
    }

    public final AnalysisComponent attachedTo() {
        return this.attachedTo;
    }

    public final AnalysisComponent component() {
        return this.component;
    }

    public final AnalysisComponent destinationVpc() {
        return this.destinationVpc;
    }

    public final AnalysisPacketHeader outboundHeader() {
        return this.outboundHeader;
    }

    public final AnalysisPacketHeader inboundHeader() {
        return this.inboundHeader;
    }

    public final AnalysisRouteTableRoute routeTableRoute() {
        return this.routeTableRoute;
    }

    public final AnalysisSecurityGroupRule securityGroupRule() {
        return this.securityGroupRule;
    }

    public final AnalysisComponent sourceVpc() {
        return this.sourceVpc;
    }

    public final AnalysisComponent subnet() {
        return this.subnet;
    }

    public final AnalysisComponent vpc() {
        return this.vpc;
    }

    public final boolean hasAdditionalDetails() {
        return this.additionalDetails != null && !(this.additionalDetails instanceof SdkAutoConstructList);
    }

    public final List<AdditionalDetail> additionalDetails() {
        return this.additionalDetails;
    }

    public final AnalysisComponent transitGateway() {
        return this.transitGateway;
    }

    public final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute() {
        return this.transitGatewayRouteTableRoute;
    }

    public final boolean hasExplanations() {
        return this.explanations != null && !(this.explanations instanceof SdkAutoConstructList);
    }

    public final List<Explanation> explanations() {
        return this.explanations;
    }

    public final AnalysisComponent elasticLoadBalancerListener() {
        return this.elasticLoadBalancerListener;
    }

    public final FirewallStatelessRule firewallStatelessRule() {
        return this.firewallStatelessRule;
    }

    public final FirewallStatefulRule firewallStatefulRule() {
        return this.firewallStatefulRule;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.component());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDetails() ? this.additionalDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExplanations() ? this.explanations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancerListener());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallStatelessRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallStatefulRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent)obj;
        return Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.aclRule(), other.aclRule()) && Objects.equals(this.attachedTo(), other.attachedTo()) && Objects.equals(this.component(), other.component()) && Objects.equals(this.destinationVpc(), other.destinationVpc()) && Objects.equals(this.outboundHeader(), other.outboundHeader()) && Objects.equals(this.inboundHeader(), other.inboundHeader()) && Objects.equals(this.routeTableRoute(), other.routeTableRoute()) && Objects.equals(this.securityGroupRule(), other.securityGroupRule()) && Objects.equals(this.sourceVpc(), other.sourceVpc()) && Objects.equals(this.subnet(), other.subnet()) && Objects.equals(this.vpc(), other.vpc()) && this.hasAdditionalDetails() == other.hasAdditionalDetails() && Objects.equals(this.additionalDetails(), other.additionalDetails()) && Objects.equals(this.transitGateway(), other.transitGateway()) && Objects.equals(this.transitGatewayRouteTableRoute(), other.transitGatewayRouteTableRoute()) && this.hasExplanations() == other.hasExplanations() && Objects.equals(this.explanations(), other.explanations()) && Objects.equals(this.elasticLoadBalancerListener(), other.elasticLoadBalancerListener()) && Objects.equals(this.firewallStatelessRule(), other.firewallStatelessRule()) && Objects.equals(this.firewallStatefulRule(), other.firewallStatefulRule()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"PathComponent").add("SequenceNumber", (Object)this.sequenceNumber()).add("AclRule", (Object)this.aclRule()).add("AttachedTo", (Object)this.attachedTo()).add("Component", (Object)this.component()).add("DestinationVpc", (Object)this.destinationVpc()).add("OutboundHeader", (Object)this.outboundHeader()).add("InboundHeader", (Object)this.inboundHeader()).add("RouteTableRoute", (Object)this.routeTableRoute()).add("SecurityGroupRule", (Object)this.securityGroupRule()).add("SourceVpc", (Object)this.sourceVpc()).add("Subnet", (Object)this.subnet()).add("Vpc", (Object)this.vpc()).add("AdditionalDetails", this.hasAdditionalDetails() ? this.additionalDetails() : null).add("TransitGateway", (Object)this.transitGateway()).add("TransitGatewayRouteTableRoute", (Object)this.transitGatewayRouteTableRoute()).add("Explanations", this.hasExplanations() ? this.explanations() : null).add("ElasticLoadBalancerListener", (Object)this.elasticLoadBalancerListener()).add("FirewallStatelessRule", (Object)this.firewallStatelessRule()).add("FirewallStatefulRule", (Object)this.firewallStatefulRule()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "AclRule": {
                return Optional.ofNullable(clazz.cast(this.aclRule()));
            }
            case "AttachedTo": {
                return Optional.ofNullable(clazz.cast(this.attachedTo()));
            }
            case "Component": {
                return Optional.ofNullable(clazz.cast(this.component()));
            }
            case "DestinationVpc": {
                return Optional.ofNullable(clazz.cast(this.destinationVpc()));
            }
            case "OutboundHeader": {
                return Optional.ofNullable(clazz.cast(this.outboundHeader()));
            }
            case "InboundHeader": {
                return Optional.ofNullable(clazz.cast(this.inboundHeader()));
            }
            case "RouteTableRoute": {
                return Optional.ofNullable(clazz.cast(this.routeTableRoute()));
            }
            case "SecurityGroupRule": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRule()));
            }
            case "SourceVpc": {
                return Optional.ofNullable(clazz.cast(this.sourceVpc()));
            }
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "AdditionalDetails": {
                return Optional.ofNullable(clazz.cast(this.additionalDetails()));
            }
            case "TransitGateway": {
                return Optional.ofNullable(clazz.cast(this.transitGateway()));
            }
            case "TransitGatewayRouteTableRoute": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableRoute()));
            }
            case "Explanations": {
                return Optional.ofNullable(clazz.cast(this.explanations()));
            }
            case "ElasticLoadBalancerListener": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancerListener()));
            }
            case "FirewallStatelessRule": {
                return Optional.ofNullable(clazz.cast(this.firewallStatelessRule()));
            }
            case "FirewallStatefulRule": {
                return Optional.ofNullable(clazz.cast(this.firewallStatefulRule()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer sequenceNumber;
        private AnalysisAclRule aclRule;
        private AnalysisComponent attachedTo;
        private AnalysisComponent component;
        private AnalysisComponent destinationVpc;
        private AnalysisPacketHeader outboundHeader;
        private AnalysisPacketHeader inboundHeader;
        private AnalysisRouteTableRoute routeTableRoute;
        private AnalysisSecurityGroupRule securityGroupRule;
        private AnalysisComponent sourceVpc;
        private AnalysisComponent subnet;
        private AnalysisComponent vpc;
        private List<AdditionalDetail> additionalDetails = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent transitGateway;
        private TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;
        private List<Explanation> explanations = DefaultSdkAutoConstructList.getInstance();
        private AnalysisComponent elasticLoadBalancerListener;
        private FirewallStatelessRule firewallStatelessRule;
        private FirewallStatefulRule firewallStatefulRule;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            this.sequenceNumber(model.sequenceNumber);
            this.aclRule(model.aclRule);
            this.attachedTo(model.attachedTo);
            this.component(model.component);
            this.destinationVpc(model.destinationVpc);
            this.outboundHeader(model.outboundHeader);
            this.inboundHeader(model.inboundHeader);
            this.routeTableRoute(model.routeTableRoute);
            this.securityGroupRule(model.securityGroupRule);
            this.sourceVpc(model.sourceVpc);
            this.subnet(model.subnet);
            this.vpc(model.vpc);
            this.additionalDetails(model.additionalDetails);
            this.transitGateway(model.transitGateway);
            this.transitGatewayRouteTableRoute(model.transitGatewayRouteTableRoute);
            this.explanations(model.explanations);
            this.elasticLoadBalancerListener(model.elasticLoadBalancerListener);
            this.firewallStatelessRule(model.firewallStatelessRule);
            this.firewallStatefulRule(model.firewallStatefulRule);
            this.serviceName(model.serviceName);
        }

        public final Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return this.aclRule != null ? this.aclRule.toBuilder() : null;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final AnalysisComponent.Builder getAttachedTo() {
            return this.attachedTo != null ? this.attachedTo.toBuilder() : null;
        }

        public final void setAttachedTo(AnalysisComponent.BuilderImpl attachedTo) {
            this.attachedTo = attachedTo != null ? attachedTo.build() : null;
        }

        @Override
        public final Builder attachedTo(AnalysisComponent attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return this.component != null ? this.component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return this.destinationVpc != null ? this.destinationVpc.toBuilder() : null;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final AnalysisPacketHeader.Builder getOutboundHeader() {
            return this.outboundHeader != null ? this.outboundHeader.toBuilder() : null;
        }

        public final void setOutboundHeader(AnalysisPacketHeader.BuilderImpl outboundHeader) {
            this.outboundHeader = outboundHeader != null ? outboundHeader.build() : null;
        }

        @Override
        public final Builder outboundHeader(AnalysisPacketHeader outboundHeader) {
            this.outboundHeader = outboundHeader;
            return this;
        }

        public final AnalysisPacketHeader.Builder getInboundHeader() {
            return this.inboundHeader != null ? this.inboundHeader.toBuilder() : null;
        }

        public final void setInboundHeader(AnalysisPacketHeader.BuilderImpl inboundHeader) {
            this.inboundHeader = inboundHeader != null ? inboundHeader.build() : null;
        }

        @Override
        public final Builder inboundHeader(AnalysisPacketHeader inboundHeader) {
            this.inboundHeader = inboundHeader;
            return this;
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return this.routeTableRoute != null ? this.routeTableRoute.toBuilder() : null;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return this.securityGroupRule != null ? this.securityGroupRule.toBuilder() : null;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return this.sourceVpc != null ? this.sourceVpc.toBuilder() : null;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final AnalysisComponent.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final List<AdditionalDetail.Builder> getAdditionalDetails() {
            List<AdditionalDetail.Builder> result = AdditionalDetailListCopier.copyToBuilder(this.additionalDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDetails(Collection<AdditionalDetail.BuilderImpl> additionalDetails) {
            this.additionalDetails = AdditionalDetailListCopier.copyFromBuilder(additionalDetails);
        }

        @Override
        public final Builder additionalDetails(Collection<AdditionalDetail> additionalDetails) {
            this.additionalDetails = AdditionalDetailListCopier.copy(additionalDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDetails(AdditionalDetail ... additionalDetails) {
            this.additionalDetails(Arrays.asList(additionalDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDetails(Consumer<AdditionalDetail.Builder> ... additionalDetails) {
            this.additionalDetails(Stream.of(additionalDetails).map(c -> (AdditionalDetail)((AdditionalDetail.Builder)AdditionalDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisComponent.Builder getTransitGateway() {
            return this.transitGateway != null ? this.transitGateway.toBuilder() : null;
        }

        public final void setTransitGateway(AnalysisComponent.BuilderImpl transitGateway) {
            this.transitGateway = transitGateway != null ? transitGateway.build() : null;
        }

        @Override
        public final Builder transitGateway(AnalysisComponent transitGateway) {
            this.transitGateway = transitGateway;
            return this;
        }

        public final TransitGatewayRouteTableRoute.Builder getTransitGatewayRouteTableRoute() {
            return this.transitGatewayRouteTableRoute != null ? this.transitGatewayRouteTableRoute.toBuilder() : null;
        }

        public final void setTransitGatewayRouteTableRoute(TransitGatewayRouteTableRoute.BuilderImpl transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute != null ? transitGatewayRouteTableRoute.build() : null;
        }

        @Override
        public final Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
            return this;
        }

        public final List<Explanation.Builder> getExplanations() {
            List<Explanation.Builder> result = ExplanationListCopier.copyToBuilder(this.explanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplanations(Collection<Explanation.BuilderImpl> explanations) {
            this.explanations = ExplanationListCopier.copyFromBuilder(explanations);
        }

        @Override
        public final Builder explanations(Collection<Explanation> explanations) {
            this.explanations = ExplanationListCopier.copy(explanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explanations(Explanation ... explanations) {
            this.explanations(Arrays.asList(explanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explanations(Consumer<Explanation.Builder> ... explanations) {
            this.explanations(Stream.of(explanations).map(c -> (Explanation)((Explanation.Builder)Explanation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisComponent.Builder getElasticLoadBalancerListener() {
            return this.elasticLoadBalancerListener != null ? this.elasticLoadBalancerListener.toBuilder() : null;
        }

        public final void setElasticLoadBalancerListener(AnalysisComponent.BuilderImpl elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener != null ? elasticLoadBalancerListener.build() : null;
        }

        @Override
        public final Builder elasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener) {
            this.elasticLoadBalancerListener = elasticLoadBalancerListener;
            return this;
        }

        public final FirewallStatelessRule.Builder getFirewallStatelessRule() {
            return this.firewallStatelessRule != null ? this.firewallStatelessRule.toBuilder() : null;
        }

        public final void setFirewallStatelessRule(FirewallStatelessRule.BuilderImpl firewallStatelessRule) {
            this.firewallStatelessRule = firewallStatelessRule != null ? firewallStatelessRule.build() : null;
        }

        @Override
        public final Builder firewallStatelessRule(FirewallStatelessRule firewallStatelessRule) {
            this.firewallStatelessRule = firewallStatelessRule;
            return this;
        }

        public final FirewallStatefulRule.Builder getFirewallStatefulRule() {
            return this.firewallStatefulRule != null ? this.firewallStatefulRule.toBuilder() : null;
        }

        public final void setFirewallStatefulRule(FirewallStatefulRule.BuilderImpl firewallStatefulRule) {
            this.firewallStatefulRule = firewallStatefulRule != null ? firewallStatefulRule.build() : null;
        }

        @Override
        public final Builder firewallStatefulRule(FirewallStatefulRule firewallStatefulRule) {
            this.firewallStatefulRule = firewallStatefulRule;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public PathComponent build() {
            return new PathComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathComponent> {
        public Builder sequenceNumber(Integer var1);

        public Builder aclRule(AnalysisAclRule var1);

        default public Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return this.aclRule((AnalysisAclRule)((AnalysisAclRule.Builder)AnalysisAclRule.builder().applyMutation(aclRule)).build());
        }

        public Builder attachedTo(AnalysisComponent var1);

        default public Builder attachedTo(Consumer<AnalysisComponent.Builder> attachedTo) {
            return this.attachedTo((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(attachedTo)).build());
        }

        public Builder component(AnalysisComponent var1);

        default public Builder component(Consumer<AnalysisComponent.Builder> component) {
            return this.component((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(component)).build());
        }

        public Builder destinationVpc(AnalysisComponent var1);

        default public Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return this.destinationVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(destinationVpc)).build());
        }

        public Builder outboundHeader(AnalysisPacketHeader var1);

        default public Builder outboundHeader(Consumer<AnalysisPacketHeader.Builder> outboundHeader) {
            return this.outboundHeader((AnalysisPacketHeader)((AnalysisPacketHeader.Builder)AnalysisPacketHeader.builder().applyMutation(outboundHeader)).build());
        }

        public Builder inboundHeader(AnalysisPacketHeader var1);

        default public Builder inboundHeader(Consumer<AnalysisPacketHeader.Builder> inboundHeader) {
            return this.inboundHeader((AnalysisPacketHeader)((AnalysisPacketHeader.Builder)AnalysisPacketHeader.builder().applyMutation(inboundHeader)).build());
        }

        public Builder routeTableRoute(AnalysisRouteTableRoute var1);

        default public Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return this.routeTableRoute((AnalysisRouteTableRoute)((AnalysisRouteTableRoute.Builder)AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute)).build());
        }

        public Builder securityGroupRule(AnalysisSecurityGroupRule var1);

        default public Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return this.securityGroupRule((AnalysisSecurityGroupRule)((AnalysisSecurityGroupRule.Builder)AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule)).build());
        }

        public Builder sourceVpc(AnalysisComponent var1);

        default public Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return this.sourceVpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(sourceVpc)).build());
        }

        public Builder subnet(AnalysisComponent var1);

        default public Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return this.subnet((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(subnet)).build());
        }

        public Builder vpc(AnalysisComponent var1);

        default public Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return this.vpc((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpc)).build());
        }

        public Builder additionalDetails(Collection<AdditionalDetail> var1);

        public Builder additionalDetails(AdditionalDetail ... var1);

        public Builder additionalDetails(Consumer<AdditionalDetail.Builder> ... var1);

        public Builder transitGateway(AnalysisComponent var1);

        default public Builder transitGateway(Consumer<AnalysisComponent.Builder> transitGateway) {
            return this.transitGateway((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(transitGateway)).build());
        }

        public Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute var1);

        default public Builder transitGatewayRouteTableRoute(Consumer<TransitGatewayRouteTableRoute.Builder> transitGatewayRouteTableRoute) {
            return this.transitGatewayRouteTableRoute((TransitGatewayRouteTableRoute)((TransitGatewayRouteTableRoute.Builder)TransitGatewayRouteTableRoute.builder().applyMutation(transitGatewayRouteTableRoute)).build());
        }

        public Builder explanations(Collection<Explanation> var1);

        public Builder explanations(Explanation ... var1);

        public Builder explanations(Consumer<Explanation.Builder> ... var1);

        public Builder elasticLoadBalancerListener(AnalysisComponent var1);

        default public Builder elasticLoadBalancerListener(Consumer<AnalysisComponent.Builder> elasticLoadBalancerListener) {
            return this.elasticLoadBalancerListener((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(elasticLoadBalancerListener)).build());
        }

        public Builder firewallStatelessRule(FirewallStatelessRule var1);

        default public Builder firewallStatelessRule(Consumer<FirewallStatelessRule.Builder> firewallStatelessRule) {
            return this.firewallStatelessRule((FirewallStatelessRule)((FirewallStatelessRule.Builder)FirewallStatelessRule.builder().applyMutation(firewallStatelessRule)).build());
        }

        public Builder firewallStatefulRule(FirewallStatefulRule var1);

        default public Builder firewallStatefulRule(Consumer<FirewallStatefulRule.Builder> firewallStatefulRule) {
            return this.firewallStatefulRule((FirewallStatefulRule)((FirewallStatefulRule.Builder)FirewallStatefulRule.builder().applyMutation(firewallStatefulRule)).build());
        }

        public Builder serviceName(String var1);
    }
}

