/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.HostnameType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyPrivateDnsNameOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyPrivateDnsNameOptionsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyPrivateDnsNameOptionsRequest.getter(ModifyPrivateDnsNameOptionsRequest::dryRun)).setter(ModifyPrivateDnsNameOptionsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyPrivateDnsNameOptionsRequest.getter(ModifyPrivateDnsNameOptionsRequest::instanceId)).setter(ModifyPrivateDnsNameOptionsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsHostnameType").getter(ModifyPrivateDnsNameOptionsRequest.getter(ModifyPrivateDnsNameOptionsRequest::privateDnsHostnameTypeAsString)).setter(ModifyPrivateDnsNameOptionsRequest.setter(Builder::privateDnsHostnameType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostnameType").unmarshallLocationName("PrivateDnsHostnameType").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableResourceNameDnsARecord").getter(ModifyPrivateDnsNameOptionsRequest.getter(ModifyPrivateDnsNameOptionsRequest::enableResourceNameDnsARecord)).setter(ModifyPrivateDnsNameOptionsRequest.setter(Builder::enableResourceNameDnsARecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord").unmarshallLocationName("EnableResourceNameDnsARecord").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableResourceNameDnsAAAARecord").getter(ModifyPrivateDnsNameOptionsRequest.getter(ModifyPrivateDnsNameOptionsRequest::enableResourceNameDnsAAAARecord)).setter(ModifyPrivateDnsNameOptionsRequest.setter(Builder::enableResourceNameDnsAAAARecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord").unmarshallLocationName("EnableResourceNameDnsAAAARecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, INSTANCE_ID_FIELD, PRIVATE_DNS_HOSTNAME_TYPE_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD, ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("PrivateDnsHostnameType", PRIVATE_DNS_HOSTNAME_TYPE_FIELD);
            this.put("EnableResourceNameDnsARecord", ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD);
            this.put("EnableResourceNameDnsAAAARecord", ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String instanceId;
    private final String privateDnsHostnameType;
    private final Boolean enableResourceNameDnsARecord;
    private final Boolean enableResourceNameDnsAAAARecord;

    private ModifyPrivateDnsNameOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceId = builder.instanceId;
        this.privateDnsHostnameType = builder.privateDnsHostnameType;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final HostnameType privateDnsHostnameType() {
        return HostnameType.fromValue(this.privateDnsHostnameType);
    }

    public final String privateDnsHostnameTypeAsString() {
        return this.privateDnsHostnameType;
    }

    public final Boolean enableResourceNameDnsARecord() {
        return this.enableResourceNameDnsARecord;
    }

    public final Boolean enableResourceNameDnsAAAARecord() {
        return this.enableResourceNameDnsAAAARecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsHostnameTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsAAAARecord());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyPrivateDnsNameOptionsRequest)) {
            return false;
        }
        ModifyPrivateDnsNameOptionsRequest other = (ModifyPrivateDnsNameOptionsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.privateDnsHostnameTypeAsString(), other.privateDnsHostnameTypeAsString()) && Objects.equals(this.enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord()) && Objects.equals(this.enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyPrivateDnsNameOptionsRequest").add("DryRun", (Object)this.dryRun()).add("InstanceId", (Object)this.instanceId()).add("PrivateDnsHostnameType", (Object)this.privateDnsHostnameTypeAsString()).add("EnableResourceNameDnsARecord", (Object)this.enableResourceNameDnsARecord()).add("EnableResourceNameDnsAAAARecord", (Object)this.enableResourceNameDnsAAAARecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PrivateDnsHostnameType": {
                return Optional.ofNullable(clazz.cast(this.privateDnsHostnameTypeAsString()));
            }
            case "EnableResourceNameDnsARecord": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsARecord()));
            }
            case "EnableResourceNameDnsAAAARecord": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsAAAARecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyPrivateDnsNameOptionsRequest, T> g) {
        return obj -> g.apply((ModifyPrivateDnsNameOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String instanceId;
        private String privateDnsHostnameType;
        private Boolean enableResourceNameDnsARecord;
        private Boolean enableResourceNameDnsAAAARecord;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyPrivateDnsNameOptionsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.instanceId(model.instanceId);
            this.privateDnsHostnameType(model.privateDnsHostnameType);
            this.enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            this.enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPrivateDnsHostnameType() {
            return this.privateDnsHostnameType;
        }

        public final void setPrivateDnsHostnameType(String privateDnsHostnameType) {
            this.privateDnsHostnameType = privateDnsHostnameType;
        }

        @Override
        public final Builder privateDnsHostnameType(String privateDnsHostnameType) {
            this.privateDnsHostnameType = privateDnsHostnameType;
            return this;
        }

        @Override
        public final Builder privateDnsHostnameType(HostnameType privateDnsHostnameType) {
            this.privateDnsHostnameType(privateDnsHostnameType == null ? null : privateDnsHostnameType.toString());
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return this.enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return this.enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyPrivateDnsNameOptionsRequest build() {
            return new ModifyPrivateDnsNameOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyPrivateDnsNameOptionsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder instanceId(String var1);

        public Builder privateDnsHostnameType(String var1);

        public Builder privateDnsHostnameType(HostnameType var1);

        public Builder enableResourceNameDnsARecord(Boolean var1);

        public Builder enableResourceNameDnsAAAARecord(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

