/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo;
import software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSnapshotsInRecycleBinResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ListSnapshotsInRecycleBinResponse> {
    private static final SdkField<List<SnapshotRecycleBinInfo>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Snapshots").getter(ListSnapshotsInRecycleBinResponse.getter(ListSnapshotsInRecycleBinResponse::snapshots)).setter(ListSnapshotsInRecycleBinResponse.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSet").unmarshallLocationName("snapshotSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotRecycleBinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSnapshotsInRecycleBinResponse.getter(ListSnapshotsInRecycleBinResponse::nextToken)).setter(ListSnapshotsInRecycleBinResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotSet", SNAPSHOTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<SnapshotRecycleBinInfo> snapshots;
    private final String nextToken;

    private ListSnapshotsInRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<SnapshotRecycleBinInfo> snapshots() {
        return this.snapshots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotsInRecycleBinResponse)) {
            return false;
        }
        ListSnapshotsInRecycleBinResponse other = (ListSnapshotsInRecycleBinResponse)((Object)obj);
        return this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSnapshotsInRecycleBinResponse").add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotsInRecycleBinResponse, T> g) {
        return obj -> g.apply((ListSnapshotsInRecycleBinResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SnapshotRecycleBinInfo> snapshots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotsInRecycleBinResponse model) {
            super(model);
            this.snapshots(model.snapshots);
            this.nextToken(model.nextToken);
        }

        public final List<SnapshotRecycleBinInfo.Builder> getSnapshots() {
            List<SnapshotRecycleBinInfo.Builder> result = SnapshotRecycleBinInfoListCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<SnapshotRecycleBinInfo.BuilderImpl> snapshots) {
            this.snapshots = SnapshotRecycleBinInfoListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<SnapshotRecycleBinInfo> snapshots) {
            this.snapshots = SnapshotRecycleBinInfoListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(SnapshotRecycleBinInfo ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<SnapshotRecycleBinInfo.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (SnapshotRecycleBinInfo)((SnapshotRecycleBinInfo.Builder)SnapshotRecycleBinInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSnapshotsInRecycleBinResponse build() {
            return new ListSnapshotsInRecycleBinResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSnapshotsInRecycleBinResponse> {
        public Builder snapshots(Collection<SnapshotRecycleBinInfo> var1);

        public Builder snapshots(SnapshotRecycleBinInfo ... var1);

        public Builder snapshots(Consumer<SnapshotRecycleBinInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

