/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamComplianceStatus;
import software.amazon.awssdk.services.ec2.model.IpamManagementState;
import software.amazon.awssdk.services.ec2.model.IpamOverlapStatus;
import software.amazon.awssdk.services.ec2.model.IpamResourceTag;
import software.amazon.awssdk.services.ec2.model.IpamResourceTagListCopier;
import software.amazon.awssdk.services.ec2.model.IpamResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamResourceCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamResourceCidr> {
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(IpamResourceCidr.getter(IpamResourceCidr::ipamId)).setter(IpamResourceCidr.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("ipamId").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(IpamResourceCidr.getter(IpamResourceCidr::ipamScopeId)).setter(IpamResourceCidr.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("ipamScopeId").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(IpamResourceCidr.getter(IpamResourceCidr::ipamPoolId)).setter(IpamResourceCidr.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("ipamPoolId").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceRegion)).setter(IpamResourceCidr.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceOwnerId)).setter(IpamResourceCidr.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceId)).setter(IpamResourceCidr.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceName)).setter(IpamResourceCidr.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").unmarshallLocationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCidr").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceCidr)).setter(IpamResourceCidr.setter(Builder::resourceCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr").unmarshallLocationName("resourceCidr").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceTypeAsString)).setter(IpamResourceCidr.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<IpamResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(IpamResourceCidr.getter(IpamResourceCidr::resourceTags)).setter(IpamResourceCidr.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSet").unmarshallLocationName("resourceTagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Double> IP_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("IpUsage").getter(IpamResourceCidr.getter(IpamResourceCidr::ipUsage)).setter(IpamResourceCidr.setter(Builder::ipUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpUsage").unmarshallLocationName("ipUsage").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceStatus").getter(IpamResourceCidr.getter(IpamResourceCidr::complianceStatusAsString)).setter(IpamResourceCidr.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceStatus").unmarshallLocationName("complianceStatus").build()}).build();
    private static final SdkField<String> MANAGEMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagementState").getter(IpamResourceCidr.getter(IpamResourceCidr::managementStateAsString)).setter(IpamResourceCidr.setter(Builder::managementState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagementState").unmarshallLocationName("managementState").build()}).build();
    private static final SdkField<String> OVERLAP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverlapStatus").getter(IpamResourceCidr.getter(IpamResourceCidr::overlapStatusAsString)).setter(IpamResourceCidr.setter(Builder::overlapStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverlapStatus").unmarshallLocationName("overlapStatus").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(IpamResourceCidr.getter(IpamResourceCidr::vpcId)).setter(IpamResourceCidr.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(IpamResourceCidr.getter(IpamResourceCidr::availabilityZoneId)).setter(IpamResourceCidr.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_ID_FIELD, IPAM_SCOPE_ID_FIELD, IPAM_POOL_ID_FIELD, RESOURCE_REGION_FIELD, RESOURCE_OWNER_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_CIDR_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, IP_USAGE_FIELD, COMPLIANCE_STATUS_FIELD, MANAGEMENT_STATE_FIELD, OVERLAP_STATUS_FIELD, VPC_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IpamId", IPAM_ID_FIELD);
            this.put("IpamScopeId", IPAM_SCOPE_ID_FIELD);
            this.put("IpamPoolId", IPAM_POOL_ID_FIELD);
            this.put("ResourceRegion", RESOURCE_REGION_FIELD);
            this.put("ResourceOwnerId", RESOURCE_OWNER_ID_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceName", RESOURCE_NAME_FIELD);
            this.put("ResourceCidr", RESOURCE_CIDR_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceTagSet", RESOURCE_TAGS_FIELD);
            this.put("IpUsage", IP_USAGE_FIELD);
            this.put("ComplianceStatus", COMPLIANCE_STATUS_FIELD);
            this.put("ManagementState", MANAGEMENT_STATE_FIELD);
            this.put("OverlapStatus", OVERLAP_STATUS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ipamId;
    private final String ipamScopeId;
    private final String ipamPoolId;
    private final String resourceRegion;
    private final String resourceOwnerId;
    private final String resourceId;
    private final String resourceName;
    private final String resourceCidr;
    private final String resourceType;
    private final List<IpamResourceTag> resourceTags;
    private final Double ipUsage;
    private final String complianceStatus;
    private final String managementState;
    private final String overlapStatus;
    private final String vpcId;
    private final String availabilityZoneId;

    private IpamResourceCidr(BuilderImpl builder) {
        this.ipamId = builder.ipamId;
        this.ipamScopeId = builder.ipamScopeId;
        this.ipamPoolId = builder.ipamPoolId;
        this.resourceRegion = builder.resourceRegion;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.resourceCidr = builder.resourceCidr;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.ipUsage = builder.ipUsage;
        this.complianceStatus = builder.complianceStatus;
        this.managementState = builder.managementState;
        this.overlapStatus = builder.overlapStatus;
        this.vpcId = builder.vpcId;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceCidr() {
        return this.resourceCidr;
    }

    public final IpamResourceType resourceType() {
        return IpamResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final Double ipUsage() {
        return this.ipUsage;
    }

    public final IpamComplianceStatus complianceStatus() {
        return IpamComplianceStatus.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final IpamManagementState managementState() {
        return IpamManagementState.fromValue(this.managementState);
    }

    public final String managementStateAsString() {
        return this.managementState;
    }

    public final IpamOverlapStatus overlapStatus() {
        return IpamOverlapStatus.fromValue(this.overlapStatus);
    }

    public final String overlapStatusAsString() {
        return this.overlapStatus;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overlapStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamResourceCidr)) {
            return false;
        }
        IpamResourceCidr other = (IpamResourceCidr)obj;
        return Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceCidr(), other.resourceCidr()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.ipUsage(), other.ipUsage()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.managementStateAsString(), other.managementStateAsString()) && Objects.equals(this.overlapStatusAsString(), other.overlapStatusAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"IpamResourceCidr").add("IpamId", (Object)this.ipamId()).add("IpamScopeId", (Object)this.ipamScopeId()).add("IpamPoolId", (Object)this.ipamPoolId()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceCidr", (Object)this.resourceCidr()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("IpUsage", (Object)this.ipUsage()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("ManagementState", (Object)this.managementStateAsString()).add("OverlapStatus", (Object)this.overlapStatusAsString()).add("VpcId", (Object)this.vpcId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ResourceCidr": {
                return Optional.ofNullable(clazz.cast(this.resourceCidr()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "IpUsage": {
                return Optional.ofNullable(clazz.cast(this.ipUsage()));
            }
            case "ComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "ManagementState": {
                return Optional.ofNullable(clazz.cast(this.managementStateAsString()));
            }
            case "OverlapStatus": {
                return Optional.ofNullable(clazz.cast(this.overlapStatusAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamResourceCidr, T> g) {
        return obj -> g.apply((IpamResourceCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamId;
        private String ipamScopeId;
        private String ipamPoolId;
        private String resourceRegion;
        private String resourceOwnerId;
        private String resourceId;
        private String resourceName;
        private String resourceCidr;
        private String resourceType;
        private List<IpamResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Double ipUsage;
        private String complianceStatus;
        private String managementState;
        private String overlapStatus;
        private String vpcId;
        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamResourceCidr model) {
            this.ipamId(model.ipamId);
            this.ipamScopeId(model.ipamScopeId);
            this.ipamPoolId(model.ipamPoolId);
            this.resourceRegion(model.resourceRegion);
            this.resourceOwnerId(model.resourceOwnerId);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.resourceCidr(model.resourceCidr);
            this.resourceType(model.resourceType);
            this.resourceTags(model.resourceTags);
            this.ipUsage(model.ipUsage);
            this.complianceStatus(model.complianceStatus);
            this.managementState(model.managementState);
            this.overlapStatus(model.overlapStatus);
            this.vpcId(model.vpcId);
            this.availabilityZoneId(model.availabilityZoneId);
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceCidr() {
            return this.resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamResourceTag.Builder> getResourceTags() {
            List<IpamResourceTag.Builder> result = IpamResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<IpamResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<IpamResourceTag> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(IpamResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<IpamResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (IpamResourceTag)((IpamResourceTag.Builder)IpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getIpUsage() {
            return this.ipUsage;
        }

        public final void setIpUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
        }

        @Override
        public final Builder ipUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(IpamComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final String getManagementState() {
            return this.managementState;
        }

        public final void setManagementState(String managementState) {
            this.managementState = managementState;
        }

        @Override
        public final Builder managementState(String managementState) {
            this.managementState = managementState;
            return this;
        }

        @Override
        public final Builder managementState(IpamManagementState managementState) {
            this.managementState(managementState == null ? null : managementState.toString());
            return this;
        }

        public final String getOverlapStatus() {
            return this.overlapStatus;
        }

        public final void setOverlapStatus(String overlapStatus) {
            this.overlapStatus = overlapStatus;
        }

        @Override
        public final Builder overlapStatus(String overlapStatus) {
            this.overlapStatus = overlapStatus;
            return this;
        }

        @Override
        public final Builder overlapStatus(IpamOverlapStatus overlapStatus) {
            this.overlapStatus(overlapStatus == null ? null : overlapStatus.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public IpamResourceCidr build() {
            return new IpamResourceCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamResourceCidr> {
        public Builder ipamId(String var1);

        public Builder ipamScopeId(String var1);

        public Builder ipamPoolId(String var1);

        public Builder resourceRegion(String var1);

        public Builder resourceOwnerId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder resourceCidr(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamResourceType var1);

        public Builder resourceTags(Collection<IpamResourceTag> var1);

        public Builder resourceTags(IpamResourceTag ... var1);

        public Builder resourceTags(Consumer<IpamResourceTag.Builder> ... var1);

        public Builder ipUsage(Double var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(IpamComplianceStatus var1);

        public Builder managementState(String var1);

        public Builder managementState(IpamManagementState var1);

        public Builder overlapStatus(String var1);

        public Builder overlapStatus(IpamOverlapStatus var1);

        public Builder vpcId(String var1);

        public Builder availabilityZoneId(String var1);
    }
}

