/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportInstanceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportInstanceRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ImportInstanceRequest.getter(ImportInstanceRequest::dryRun)).setter(ImportInstanceRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportInstanceRequest.getter(ImportInstanceRequest::description)).setter(ImportInstanceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<ImportInstanceLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchSpecification").getter(ImportInstanceRequest.getter(ImportInstanceRequest::launchSpecification)).setter(ImportInstanceRequest.setter(Builder::launchSpecification)).constructor(ImportInstanceLaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification").unmarshallLocationName("launchSpecification").build()}).build();
    private static final SdkField<List<DiskImage>> DISK_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskImages").getter(ImportInstanceRequest.getter(ImportInstanceRequest::diskImages)).setter(ImportInstanceRequest.setter(Builder::diskImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImage").unmarshallLocationName("diskImage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ImportInstanceRequest.getter(ImportInstanceRequest::platformAsString)).setter(ImportInstanceRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, DESCRIPTION_FIELD, LAUNCH_SPECIFICATION_FIELD, DISK_IMAGES_FIELD, PLATFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("LaunchSpecification", LAUNCH_SPECIFICATION_FIELD);
            this.put("DiskImage", DISK_IMAGES_FIELD);
            this.put("Platform", PLATFORM_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String description;
    private final ImportInstanceLaunchSpecification launchSpecification;
    private final List<DiskImage> diskImages;
    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.description = builder.description;
        this.launchSpecification = builder.launchSpecification;
        this.diskImages = builder.diskImages;
        this.platform = builder.platform;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String description() {
        return this.description;
    }

    public final ImportInstanceLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public final boolean hasDiskImages() {
        return this.diskImages != null && !(this.diskImages instanceof SdkAutoConstructList);
    }

    public final List<DiskImage> diskImages() {
        return this.diskImages;
    }

    public final PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskImages() ? this.diskImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && this.hasDiskImages() == other.hasDiskImages() && Objects.equals(this.diskImages(), other.diskImages()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportInstanceRequest").add("DryRun", (Object)this.dryRun()).add("Description", (Object)this.description()).add("LaunchSpecification", (Object)this.launchSpecification()).add("DiskImages", this.hasDiskImages() ? this.diskImages() : null).add("Platform", (Object)this.platformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LaunchSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchSpecification()));
            }
            case "DiskImages": {
                return Optional.ofNullable(clazz.cast(this.diskImages()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceRequest, T> g) {
        return obj -> g.apply((ImportInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String description;
        private ImportInstanceLaunchSpecification launchSpecification;
        private List<DiskImage> diskImages = DefaultSdkAutoConstructList.getInstance();
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.description(model.description);
            this.launchSpecification(model.launchSpecification);
            this.diskImages(model.diskImages);
            this.platform(model.platform);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ImportInstanceLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final List<DiskImage.Builder> getDiskImages() {
            List<DiskImage.Builder> result = DiskImageListCopier.copyToBuilder(this.diskImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiskImages(Collection<DiskImage.BuilderImpl> diskImages) {
            this.diskImages = DiskImageListCopier.copyFromBuilder(diskImages);
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage ... diskImages) {
            this.diskImages(Arrays.asList(diskImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(Consumer<DiskImage.Builder> ... diskImages) {
            this.diskImages(Stream.of(diskImages).map(c -> (DiskImage)((DiskImage.Builder)DiskImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportInstanceRequest> {
        public Builder dryRun(Boolean var1);

        public Builder description(String var1);

        public Builder launchSpecification(ImportInstanceLaunchSpecification var1);

        default public Builder launchSpecification(Consumer<ImportInstanceLaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((ImportInstanceLaunchSpecification)((ImportInstanceLaunchSpecification.Builder)ImportInstanceLaunchSpecification.builder().applyMutation(launchSpecification)).build());
        }

        public Builder diskImages(Collection<DiskImage> var1);

        public Builder diskImages(DiskImage ... var1);

        public Builder diskImages(Consumer<DiskImage.Builder> ... var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

