/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamAddressHistoryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetIpamAddressHistoryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::dryRun)).setter(GetIpamAddressHistoryRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::cidr)).setter(GetIpamAddressHistoryRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::ipamScopeId)).setter(GetIpamAddressHistoryRequest.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("IpamScopeId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::vpcId)).setter(GetIpamAddressHistoryRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::startTime)).setter(GetIpamAddressHistoryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::endTime)).setter(GetIpamAddressHistoryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("EndTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::maxResults)).setter(GetIpamAddressHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamAddressHistoryRequest.getter(GetIpamAddressHistoryRequest::nextToken)).setter(GetIpamAddressHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CIDR_FIELD, IPAM_SCOPE_ID_FIELD, VPC_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("Cidr", CIDR_FIELD);
            this.put("IpamScopeId", IPAM_SCOPE_ID_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String cidr;
    private final String ipamScopeId;
    private final String vpcId;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer maxResults;
    private final String nextToken;

    private GetIpamAddressHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.cidr = builder.cidr;
        this.ipamScopeId = builder.ipamScopeId;
        this.vpcId = builder.vpcId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamAddressHistoryRequest)) {
            return false;
        }
        GetIpamAddressHistoryRequest other = (GetIpamAddressHistoryRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamAddressHistoryRequest").add("DryRun", (Object)this.dryRun()).add("Cidr", (Object)this.cidr()).add("IpamScopeId", (Object)this.ipamScopeId()).add("VpcId", (Object)this.vpcId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamAddressHistoryRequest, T> g) {
        return obj -> g.apply((GetIpamAddressHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String cidr;
        private String ipamScopeId;
        private String vpcId;
        private Instant startTime;
        private Instant endTime;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamAddressHistoryRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.cidr(model.cidr);
            this.ipamScopeId(model.ipamScopeId);
            this.vpcId(model.vpcId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIpamAddressHistoryRequest build() {
            return new GetIpamAddressHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamAddressHistoryRequest> {
        public Builder dryRun(Boolean var1);

        public Builder cidr(String var1);

        public Builder ipamScopeId(String var1);

        public Builder vpcId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

