/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationGroup;
import software.amazon.awssdk.services.ec2.model.CapacityReservationGroupSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGroupsForCapacityReservationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetGroupsForCapacityReservationResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetGroupsForCapacityReservationResponse.getter(GetGroupsForCapacityReservationResponse::nextToken)).setter(GetGroupsForCapacityReservationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<CapacityReservationGroup>> CAPACITY_RESERVATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationGroups").getter(GetGroupsForCapacityReservationResponse.getter(GetGroupsForCapacityReservationResponse::capacityReservationGroups)).setter(GetGroupsForCapacityReservationResponse.setter(Builder::capacityReservationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationGroupSet").unmarshallLocationName("capacityReservationGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATION_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CapacityReservationGroupSet", CAPACITY_RESERVATION_GROUPS_FIELD);
        }
    });
    private final String nextToken;
    private final List<CapacityReservationGroup> capacityReservationGroups;

    private GetGroupsForCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationGroups = builder.capacityReservationGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCapacityReservationGroups() {
        return this.capacityReservationGroups != null && !(this.capacityReservationGroups instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationGroup> capacityReservationGroups() {
        return this.capacityReservationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationGroups() ? this.capacityReservationGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupsForCapacityReservationResponse)) {
            return false;
        }
        GetGroupsForCapacityReservationResponse other = (GetGroupsForCapacityReservationResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCapacityReservationGroups() == other.hasCapacityReservationGroups() && Objects.equals(this.capacityReservationGroups(), other.capacityReservationGroups());
    }

    public final String toString() {
        return ToString.builder((String)"GetGroupsForCapacityReservationResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservationGroups", this.hasCapacityReservationGroups() ? this.capacityReservationGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservationGroups": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupsForCapacityReservationResponse, T> g) {
        return obj -> g.apply((GetGroupsForCapacityReservationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CapacityReservationGroup> capacityReservationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupsForCapacityReservationResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservationGroups(model.capacityReservationGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservationGroup.Builder> getCapacityReservationGroups() {
            List<CapacityReservationGroup.Builder> result = CapacityReservationGroupSetCopier.copyToBuilder(this.capacityReservationGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationGroups(Collection<CapacityReservationGroup.BuilderImpl> capacityReservationGroups) {
            this.capacityReservationGroups = CapacityReservationGroupSetCopier.copyFromBuilder(capacityReservationGroups);
        }

        @Override
        public final Builder capacityReservationGroups(Collection<CapacityReservationGroup> capacityReservationGroups) {
            this.capacityReservationGroups = CapacityReservationGroupSetCopier.copy(capacityReservationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationGroups(CapacityReservationGroup ... capacityReservationGroups) {
            this.capacityReservationGroups(Arrays.asList(capacityReservationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationGroups(Consumer<CapacityReservationGroup.Builder> ... capacityReservationGroups) {
            this.capacityReservationGroups(Stream.of(capacityReservationGroups).map(c -> (CapacityReservationGroup)((CapacityReservationGroup.Builder)CapacityReservationGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetGroupsForCapacityReservationResponse build() {
            return new GetGroupsForCapacityReservationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGroupsForCapacityReservationResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservationGroups(Collection<CapacityReservationGroup> var1);

        public Builder capacityReservationGroups(CapacityReservationGroup ... var1);

        public Builder capacityReservationGroups(Consumer<CapacityReservationGroup.Builder> ... var1);
    }
}

