/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EipAssociationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateNatGatewayAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DisassociateNatGatewayAddressRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(DisassociateNatGatewayAddressRequest.getter(DisassociateNatGatewayAddressRequest::natGatewayId)).setter(DisassociateNatGatewayAddressRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("NatGatewayId").build()}).build();
    private static final SdkField<List<String>> ASSOCIATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationIds").getter(DisassociateNatGatewayAddressRequest.getter(DisassociateNatGatewayAddressRequest::associationIds)).setter(DisassociateNatGatewayAddressRequest.setter(Builder::associationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("AssociationId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_DRAIN_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDrainDurationSeconds").getter(DisassociateNatGatewayAddressRequest.getter(DisassociateNatGatewayAddressRequest::maxDrainDurationSeconds)).setter(DisassociateNatGatewayAddressRequest.setter(Builder::maxDrainDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDrainDurationSeconds").unmarshallLocationName("MaxDrainDurationSeconds").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DisassociateNatGatewayAddressRequest.getter(DisassociateNatGatewayAddressRequest::dryRun)).setter(DisassociateNatGatewayAddressRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD, ASSOCIATION_IDS_FIELD, MAX_DRAIN_DURATION_SECONDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
            this.put("AssociationId", ASSOCIATION_IDS_FIELD);
            this.put("MaxDrainDurationSeconds", MAX_DRAIN_DURATION_SECONDS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String natGatewayId;
    private final List<String> associationIds;
    private final Integer maxDrainDurationSeconds;
    private final Boolean dryRun;

    private DisassociateNatGatewayAddressRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.associationIds = builder.associationIds;
        this.maxDrainDurationSeconds = builder.maxDrainDurationSeconds;
        this.dryRun = builder.dryRun;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final boolean hasAssociationIds() {
        return this.associationIds != null && !(this.associationIds instanceof SdkAutoConstructList);
    }

    public final List<String> associationIds() {
        return this.associationIds;
    }

    public final Integer maxDrainDurationSeconds() {
        return this.maxDrainDurationSeconds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationIds() ? this.associationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDrainDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateNatGatewayAddressRequest)) {
            return false;
        }
        DisassociateNatGatewayAddressRequest other = (DisassociateNatGatewayAddressRequest)((Object)obj);
        return Objects.equals(this.natGatewayId(), other.natGatewayId()) && this.hasAssociationIds() == other.hasAssociationIds() && Objects.equals(this.associationIds(), other.associationIds()) && Objects.equals(this.maxDrainDurationSeconds(), other.maxDrainDurationSeconds()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateNatGatewayAddressRequest").add("NatGatewayId", (Object)this.natGatewayId()).add("AssociationIds", this.hasAssociationIds() ? this.associationIds() : null).add("MaxDrainDurationSeconds", (Object)this.maxDrainDurationSeconds()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "AssociationIds": {
                return Optional.ofNullable(clazz.cast(this.associationIds()));
            }
            case "MaxDrainDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxDrainDurationSeconds()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateNatGatewayAddressRequest, T> g) {
        return obj -> g.apply((DisassociateNatGatewayAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String natGatewayId;
        private List<String> associationIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxDrainDurationSeconds;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateNatGatewayAddressRequest model) {
            super(model);
            this.natGatewayId(model.natGatewayId);
            this.associationIds(model.associationIds);
            this.maxDrainDurationSeconds(model.maxDrainDurationSeconds);
            this.dryRun(model.dryRun);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final Collection<String> getAssociationIds() {
            if (this.associationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associationIds;
        }

        public final void setAssociationIds(Collection<String> associationIds) {
            this.associationIds = EipAssociationIdListCopier.copy(associationIds);
        }

        @Override
        public final Builder associationIds(Collection<String> associationIds) {
            this.associationIds = EipAssociationIdListCopier.copy(associationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationIds(String ... associationIds) {
            this.associationIds(Arrays.asList(associationIds));
            return this;
        }

        public final Integer getMaxDrainDurationSeconds() {
            return this.maxDrainDurationSeconds;
        }

        public final void setMaxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
        }

        @Override
        public final Builder maxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateNatGatewayAddressRequest build() {
            return new DisassociateNatGatewayAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateNatGatewayAddressRequest> {
        public Builder natGatewayId(String var1);

        public Builder associationIds(Collection<String> var1);

        public Builder associationIds(String ... var1);

        public Builder maxDrainDurationSeconds(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

