/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.MetricType;
import software.amazon.awssdk.services.ec2.model.StatisticType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableAwsNetworkPerformanceMetricSubscriptionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DisableAwsNetworkPerformanceMetricSubscriptionRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::source)).setter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("Source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::destination)).setter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("Destination").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::metricAsString)).setter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").unmarshallLocationName("Metric").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::statisticAsString)).setter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").unmarshallLocationName("Statistic").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.getter(DisableAwsNetworkPerformanceMetricSubscriptionRequest::dryRun)).setter(DisableAwsNetworkPerformanceMetricSubscriptionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Source", SOURCE_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("Metric", METRIC_FIELD);
            this.put("Statistic", STATISTIC_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String source;
    private final String destination;
    private final String metric;
    private final String statistic;
    private final Boolean dryRun;

    private DisableAwsNetworkPerformanceMetricSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.dryRun = builder.dryRun;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final MetricType metric() {
        return MetricType.fromValue(this.metric);
    }

    public final String metricAsString() {
        return this.metric;
    }

    public final StatisticType statistic() {
        return StatisticType.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAwsNetworkPerformanceMetricSubscriptionRequest)) {
            return false;
        }
        DisableAwsNetworkPerformanceMetricSubscriptionRequest other = (DisableAwsNetworkPerformanceMetricSubscriptionRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.metricAsString(), other.metricAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"DisableAwsNetworkPerformanceMetricSubscriptionRequest").add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("Metric", (Object)this.metricAsString()).add("Statistic", (Object)this.statisticAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisableAwsNetworkPerformanceMetricSubscriptionRequest, T> g) {
        return obj -> g.apply((DisableAwsNetworkPerformanceMetricSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String source;
        private String destination;
        private String metric;
        private String statistic;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAwsNetworkPerformanceMetricSubscriptionRequest model) {
            super(model);
            this.source(model.source);
            this.destination(model.destination);
            this.metric(model.metric);
            this.statistic(model.statistic);
            this.dryRun(model.dryRun);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableAwsNetworkPerformanceMetricSubscriptionRequest build() {
            return new DisableAwsNetworkPerformanceMetricSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableAwsNetworkPerformanceMetricSubscriptionRequest> {
        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder metric(String var1);

        public Builder metric(MetricType var1);

        public Builder statistic(String var1);

        public Builder statistic(StatisticType var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

