/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceConnectEndpointResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateInstanceConnectEndpointResponse> {
    private static final SdkField<Ec2InstanceConnectEndpoint> INSTANCE_CONNECT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConnectEndpoint").getter(CreateInstanceConnectEndpointResponse.getter(CreateInstanceConnectEndpointResponse::instanceConnectEndpoint)).setter(CreateInstanceConnectEndpointResponse.setter(Builder::instanceConnectEndpoint)).constructor(Ec2InstanceConnectEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpoint").unmarshallLocationName("instanceConnectEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateInstanceConnectEndpointResponse.getter(CreateInstanceConnectEndpointResponse::clientToken)).setter(CreateInstanceConnectEndpointResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_CONNECT_ENDPOINT_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceConnectEndpoint", INSTANCE_CONNECT_ENDPOINT_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final Ec2InstanceConnectEndpoint instanceConnectEndpoint;
    private final String clientToken;

    private CreateInstanceConnectEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.instanceConnectEndpoint = builder.instanceConnectEndpoint;
        this.clientToken = builder.clientToken;
    }

    public final Ec2InstanceConnectEndpoint instanceConnectEndpoint() {
        return this.instanceConnectEndpoint;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceConnectEndpointResponse)) {
            return false;
        }
        CreateInstanceConnectEndpointResponse other = (CreateInstanceConnectEndpointResponse)((Object)obj);
        return Objects.equals(this.instanceConnectEndpoint(), other.instanceConnectEndpoint()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceConnectEndpointResponse").add("InstanceConnectEndpoint", (Object)this.instanceConnectEndpoint()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceConnectEndpoint": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectEndpoint()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceConnectEndpointResponse, T> g) {
        return obj -> g.apply((CreateInstanceConnectEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Ec2InstanceConnectEndpoint instanceConnectEndpoint;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceConnectEndpointResponse model) {
            super(model);
            this.instanceConnectEndpoint(model.instanceConnectEndpoint);
            this.clientToken(model.clientToken);
        }

        public final Ec2InstanceConnectEndpoint.Builder getInstanceConnectEndpoint() {
            return this.instanceConnectEndpoint != null ? this.instanceConnectEndpoint.toBuilder() : null;
        }

        public final void setInstanceConnectEndpoint(Ec2InstanceConnectEndpoint.BuilderImpl instanceConnectEndpoint) {
            this.instanceConnectEndpoint = instanceConnectEndpoint != null ? instanceConnectEndpoint.build() : null;
        }

        @Override
        public final Builder instanceConnectEndpoint(Ec2InstanceConnectEndpoint instanceConnectEndpoint) {
            this.instanceConnectEndpoint = instanceConnectEndpoint;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateInstanceConnectEndpointResponse build() {
            return new CreateInstanceConnectEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceConnectEndpointResponse> {
        public Builder instanceConnectEndpoint(Ec2InstanceConnectEndpoint var1);

        default public Builder instanceConnectEndpoint(Consumer<Ec2InstanceConnectEndpoint.Builder> instanceConnectEndpoint) {
            return this.instanceConnectEndpoint((Ec2InstanceConnectEndpoint)((Ec2InstanceConnectEndpoint.Builder)Ec2InstanceConnectEndpoint.builder().applyMutation(instanceConnectEndpoint)).build());
        }

        public Builder clientToken(String var1);
    }
}

