/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateTransitGatewayPolicyTableResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateTransitGatewayPolicyTableResponse> {
    private static final SdkField<TransitGatewayPolicyTableAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(AssociateTransitGatewayPolicyTableResponse.getter(AssociateTransitGatewayPolicyTableResponse::association)).setter(AssociateTransitGatewayPolicyTableResponse.setter(Builder::association)).constructor(TransitGatewayPolicyTableAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Association", ASSOCIATION_FIELD);
        }
    });
    private final TransitGatewayPolicyTableAssociation association;

    private AssociateTransitGatewayPolicyTableResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    public final TransitGatewayPolicyTableAssociation association() {
        return this.association;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTransitGatewayPolicyTableResponse)) {
            return false;
        }
        AssociateTransitGatewayPolicyTableResponse other = (AssociateTransitGatewayPolicyTableResponse)((Object)obj);
        return Objects.equals(this.association(), other.association());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateTransitGatewayPolicyTableResponse").add("Association", (Object)this.association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTransitGatewayPolicyTableResponse, T> g) {
        return obj -> g.apply((AssociateTransitGatewayPolicyTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private TransitGatewayPolicyTableAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTransitGatewayPolicyTableResponse model) {
            super(model);
            this.association(model.association);
        }

        public final TransitGatewayPolicyTableAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        public final void setAssociation(TransitGatewayPolicyTableAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(TransitGatewayPolicyTableAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public AssociateTransitGatewayPolicyTableResponse build() {
            return new AssociateTransitGatewayPolicyTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateTransitGatewayPolicyTableResponse> {
        public Builder association(TransitGatewayPolicyTableAssociation var1);

        default public Builder association(Consumer<TransitGatewayPolicyTableAssociation.Builder> association) {
            return this.association((TransitGatewayPolicyTableAssociation)((TransitGatewayPolicyTableAssociation.Builder)TransitGatewayPolicyTableAssociation.builder().applyMutation(association)).build());
        }
    }
}

