/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockOffering;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse;

public class DescribeCapacityBlockOfferingsIterable
implements SdkIterable<DescribeCapacityBlockOfferingsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityBlockOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityBlockOfferingsIterable(Ec2Client client, DescribeCapacityBlockOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityBlockOfferingsResponseFetcher();
    }

    public Iterator<DescribeCapacityBlockOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityBlockOffering> capacityBlockOfferings() {
        Function<DescribeCapacityBlockOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockOfferings() != null) {
                return response.capacityBlockOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityBlockOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityBlockOfferingsResponse> {
        private DescribeCapacityBlockOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityBlockOfferingsResponse nextPage(DescribeCapacityBlockOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockOfferingsIterable.this.client.describeCapacityBlockOfferings(DescribeCapacityBlockOfferingsIterable.this.firstRequest);
            }
            return DescribeCapacityBlockOfferingsIterable.this.client.describeCapacityBlockOfferings((DescribeCapacityBlockOfferingsRequest)((Object)DescribeCapacityBlockOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

