/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SnapshotTierStatus;
import software.amazon.awssdk.services.ec2.model._snapshotTierStatusSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotTierStatusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSnapshotTierStatusResponse> {
    private static final SdkField<List<SnapshotTierStatus>> SNAPSHOT_TIER_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotTierStatuses").getter(DescribeSnapshotTierStatusResponse.getter(DescribeSnapshotTierStatusResponse::snapshotTierStatuses)).setter(DescribeSnapshotTierStatusResponse.setter(Builder::snapshotTierStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTierStatusSet").unmarshallLocationName("snapshotTierStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotTierStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSnapshotTierStatusResponse.getter(DescribeSnapshotTierStatusResponse::nextToken)).setter(DescribeSnapshotTierStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_TIER_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SnapshotTierStatusSet", SNAPSHOT_TIER_STATUSES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<SnapshotTierStatus> snapshotTierStatuses;
    private final String nextToken;

    private DescribeSnapshotTierStatusResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotTierStatuses = builder.snapshotTierStatuses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSnapshotTierStatuses() {
        return this.snapshotTierStatuses != null && !(this.snapshotTierStatuses instanceof SdkAutoConstructList);
    }

    public final List<SnapshotTierStatus> snapshotTierStatuses() {
        return this.snapshotTierStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotTierStatuses() ? this.snapshotTierStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotTierStatusResponse)) {
            return false;
        }
        DescribeSnapshotTierStatusResponse other = (DescribeSnapshotTierStatusResponse)((Object)obj);
        return this.hasSnapshotTierStatuses() == other.hasSnapshotTierStatuses() && Objects.equals(this.snapshotTierStatuses(), other.snapshotTierStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotTierStatusResponse").add("SnapshotTierStatuses", this.hasSnapshotTierStatuses() ? this.snapshotTierStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotTierStatuses": {
                return Optional.ofNullable(clazz.cast(this.snapshotTierStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotTierStatusResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotTierStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SnapshotTierStatus> snapshotTierStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotTierStatusResponse model) {
            super(model);
            this.snapshotTierStatuses(model.snapshotTierStatuses);
            this.nextToken(model.nextToken);
        }

        public final List<SnapshotTierStatus.Builder> getSnapshotTierStatuses() {
            List<SnapshotTierStatus.Builder> result = _snapshotTierStatusSetCopier.copyToBuilder(this.snapshotTierStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotTierStatuses(Collection<SnapshotTierStatus.BuilderImpl> snapshotTierStatuses) {
            this.snapshotTierStatuses = _snapshotTierStatusSetCopier.copyFromBuilder(snapshotTierStatuses);
        }

        @Override
        public final Builder snapshotTierStatuses(Collection<SnapshotTierStatus> snapshotTierStatuses) {
            this.snapshotTierStatuses = _snapshotTierStatusSetCopier.copy(snapshotTierStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotTierStatuses(SnapshotTierStatus ... snapshotTierStatuses) {
            this.snapshotTierStatuses(Arrays.asList(snapshotTierStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotTierStatuses(Consumer<SnapshotTierStatus.Builder> ... snapshotTierStatuses) {
            this.snapshotTierStatuses(Stream.of(snapshotTierStatuses).map(c -> (SnapshotTierStatus)((SnapshotTierStatus.Builder)SnapshotTierStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSnapshotTierStatusResponse build() {
            return new DescribeSnapshotTierStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotTierStatusResponse> {
        public Builder snapshotTierStatuses(Collection<SnapshotTierStatus> var1);

        public Builder snapshotTierStatuses(SnapshotTierStatus ... var1);

        public Builder snapshotTierStatuses(Consumer<SnapshotTierStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

