/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeModificationState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeModification> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(VolumeModification.getter(VolumeModification::volumeId)).setter(VolumeModification.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationState").getter(VolumeModification.getter(VolumeModification::modificationStateAsString)).setter(VolumeModification.setter(Builder::modificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState").unmarshallLocationName("modificationState").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(VolumeModification.getter(VolumeModification::statusMessage)).setter(VolumeModification.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<Integer> TARGET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetSize").getter(VolumeModification.getter(VolumeModification::targetSize)).setter(VolumeModification.setter(Builder::targetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSize").unmarshallLocationName("targetSize").build()}).build();
    private static final SdkField<Integer> TARGET_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetIops").getter(VolumeModification.getter(VolumeModification::targetIops)).setter(VolumeModification.setter(Builder::targetIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIops").unmarshallLocationName("targetIops").build()}).build();
    private static final SdkField<String> TARGET_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVolumeType").getter(VolumeModification.getter(VolumeModification::targetVolumeTypeAsString)).setter(VolumeModification.setter(Builder::targetVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVolumeType").unmarshallLocationName("targetVolumeType").build()}).build();
    private static final SdkField<Integer> TARGET_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetThroughput").getter(VolumeModification.getter(VolumeModification::targetThroughput)).setter(VolumeModification.setter(Builder::targetThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetThroughput").unmarshallLocationName("targetThroughput").build()}).build();
    private static final SdkField<Boolean> TARGET_MULTI_ATTACH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TargetMultiAttachEnabled").getter(VolumeModification.getter(VolumeModification::targetMultiAttachEnabled)).setter(VolumeModification.setter(Builder::targetMultiAttachEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMultiAttachEnabled").unmarshallLocationName("targetMultiAttachEnabled").build()}).build();
    private static final SdkField<Integer> ORIGINAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginalSize").getter(VolumeModification.getter(VolumeModification::originalSize)).setter(VolumeModification.setter(Builder::originalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSize").unmarshallLocationName("originalSize").build()}).build();
    private static final SdkField<Integer> ORIGINAL_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginalIops").getter(VolumeModification.getter(VolumeModification::originalIops)).setter(VolumeModification.setter(Builder::originalIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalIops").unmarshallLocationName("originalIops").build()}).build();
    private static final SdkField<String> ORIGINAL_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalVolumeType").getter(VolumeModification.getter(VolumeModification::originalVolumeTypeAsString)).setter(VolumeModification.setter(Builder::originalVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalVolumeType").unmarshallLocationName("originalVolumeType").build()}).build();
    private static final SdkField<Integer> ORIGINAL_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginalThroughput").getter(VolumeModification.getter(VolumeModification::originalThroughput)).setter(VolumeModification.setter(Builder::originalThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalThroughput").unmarshallLocationName("originalThroughput").build()}).build();
    private static final SdkField<Boolean> ORIGINAL_MULTI_ATTACH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OriginalMultiAttachEnabled").getter(VolumeModification.getter(VolumeModification::originalMultiAttachEnabled)).setter(VolumeModification.setter(Builder::originalMultiAttachEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalMultiAttachEnabled").unmarshallLocationName("originalMultiAttachEnabled").build()}).build();
    private static final SdkField<Long> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Progress").getter(VolumeModification.getter(VolumeModification::progress)).setter(VolumeModification.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(VolumeModification.getter(VolumeModification::startTime)).setter(VolumeModification.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(VolumeModification.getter(VolumeModification::endTime)).setter(VolumeModification.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, MODIFICATION_STATE_FIELD, STATUS_MESSAGE_FIELD, TARGET_SIZE_FIELD, TARGET_IOPS_FIELD, TARGET_VOLUME_TYPE_FIELD, TARGET_THROUGHPUT_FIELD, TARGET_MULTI_ATTACH_ENABLED_FIELD, ORIGINAL_SIZE_FIELD, ORIGINAL_IOPS_FIELD, ORIGINAL_VOLUME_TYPE_FIELD, ORIGINAL_THROUGHPUT_FIELD, ORIGINAL_MULTI_ATTACH_ENABLED_FIELD, PROGRESS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VolumeId", VOLUME_ID_FIELD);
            this.put("ModificationState", MODIFICATION_STATE_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("TargetSize", TARGET_SIZE_FIELD);
            this.put("TargetIops", TARGET_IOPS_FIELD);
            this.put("TargetVolumeType", TARGET_VOLUME_TYPE_FIELD);
            this.put("TargetThroughput", TARGET_THROUGHPUT_FIELD);
            this.put("TargetMultiAttachEnabled", TARGET_MULTI_ATTACH_ENABLED_FIELD);
            this.put("OriginalSize", ORIGINAL_SIZE_FIELD);
            this.put("OriginalIops", ORIGINAL_IOPS_FIELD);
            this.put("OriginalVolumeType", ORIGINAL_VOLUME_TYPE_FIELD);
            this.put("OriginalThroughput", ORIGINAL_THROUGHPUT_FIELD);
            this.put("OriginalMultiAttachEnabled", ORIGINAL_MULTI_ATTACH_ENABLED_FIELD);
            this.put("Progress", PROGRESS_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String volumeId;
    private final String modificationState;
    private final String statusMessage;
    private final Integer targetSize;
    private final Integer targetIops;
    private final String targetVolumeType;
    private final Integer targetThroughput;
    private final Boolean targetMultiAttachEnabled;
    private final Integer originalSize;
    private final Integer originalIops;
    private final String originalVolumeType;
    private final Integer originalThroughput;
    private final Boolean originalMultiAttachEnabled;
    private final Long progress;
    private final Instant startTime;
    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.targetThroughput = builder.targetThroughput;
        this.targetMultiAttachEnabled = builder.targetMultiAttachEnabled;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.originalThroughput = builder.originalThroughput;
        this.originalMultiAttachEnabled = builder.originalMultiAttachEnabled;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final VolumeModificationState modificationState() {
        return VolumeModificationState.fromValue(this.modificationState);
    }

    public final String modificationStateAsString() {
        return this.modificationState;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Integer targetSize() {
        return this.targetSize;
    }

    public final Integer targetIops() {
        return this.targetIops;
    }

    public final VolumeType targetVolumeType() {
        return VolumeType.fromValue(this.targetVolumeType);
    }

    public final String targetVolumeTypeAsString() {
        return this.targetVolumeType;
    }

    public final Integer targetThroughput() {
        return this.targetThroughput;
    }

    public final Boolean targetMultiAttachEnabled() {
        return this.targetMultiAttachEnabled;
    }

    public final Integer originalSize() {
        return this.originalSize;
    }

    public final Integer originalIops() {
        return this.originalIops;
    }

    public final VolumeType originalVolumeType() {
        return VolumeType.fromValue(this.originalVolumeType);
    }

    public final String originalVolumeTypeAsString() {
        return this.originalVolumeType;
    }

    public final Integer originalThroughput() {
        return this.originalThroughput;
    }

    public final Boolean originalMultiAttachEnabled() {
        return this.originalMultiAttachEnabled;
    }

    public final Long progress() {
        return this.progress;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMultiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalMultiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification)obj;
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.modificationStateAsString(), other.modificationStateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.targetSize(), other.targetSize()) && Objects.equals(this.targetIops(), other.targetIops()) && Objects.equals(this.targetVolumeTypeAsString(), other.targetVolumeTypeAsString()) && Objects.equals(this.targetThroughput(), other.targetThroughput()) && Objects.equals(this.targetMultiAttachEnabled(), other.targetMultiAttachEnabled()) && Objects.equals(this.originalSize(), other.originalSize()) && Objects.equals(this.originalIops(), other.originalIops()) && Objects.equals(this.originalVolumeTypeAsString(), other.originalVolumeTypeAsString()) && Objects.equals(this.originalThroughput(), other.originalThroughput()) && Objects.equals(this.originalMultiAttachEnabled(), other.originalMultiAttachEnabled()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeModification").add("VolumeId", (Object)this.volumeId()).add("ModificationState", (Object)this.modificationStateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("TargetSize", (Object)this.targetSize()).add("TargetIops", (Object)this.targetIops()).add("TargetVolumeType", (Object)this.targetVolumeTypeAsString()).add("TargetThroughput", (Object)this.targetThroughput()).add("TargetMultiAttachEnabled", (Object)this.targetMultiAttachEnabled()).add("OriginalSize", (Object)this.originalSize()).add("OriginalIops", (Object)this.originalIops()).add("OriginalVolumeType", (Object)this.originalVolumeTypeAsString()).add("OriginalThroughput", (Object)this.originalThroughput()).add("OriginalMultiAttachEnabled", (Object)this.originalMultiAttachEnabled()).add("Progress", (Object)this.progress()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "ModificationState": {
                return Optional.ofNullable(clazz.cast(this.modificationStateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "TargetSize": {
                return Optional.ofNullable(clazz.cast(this.targetSize()));
            }
            case "TargetIops": {
                return Optional.ofNullable(clazz.cast(this.targetIops()));
            }
            case "TargetVolumeType": {
                return Optional.ofNullable(clazz.cast(this.targetVolumeTypeAsString()));
            }
            case "TargetThroughput": {
                return Optional.ofNullable(clazz.cast(this.targetThroughput()));
            }
            case "TargetMultiAttachEnabled": {
                return Optional.ofNullable(clazz.cast(this.targetMultiAttachEnabled()));
            }
            case "OriginalSize": {
                return Optional.ofNullable(clazz.cast(this.originalSize()));
            }
            case "OriginalIops": {
                return Optional.ofNullable(clazz.cast(this.originalIops()));
            }
            case "OriginalVolumeType": {
                return Optional.ofNullable(clazz.cast(this.originalVolumeTypeAsString()));
            }
            case "OriginalThroughput": {
                return Optional.ofNullable(clazz.cast(this.originalThroughput()));
            }
            case "OriginalMultiAttachEnabled": {
                return Optional.ofNullable(clazz.cast(this.originalMultiAttachEnabled()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VolumeModification, T> g) {
        return obj -> g.apply((VolumeModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private String modificationState;
        private String statusMessage;
        private Integer targetSize;
        private Integer targetIops;
        private String targetVolumeType;
        private Integer targetThroughput;
        private Boolean targetMultiAttachEnabled;
        private Integer originalSize;
        private Integer originalIops;
        private String originalVolumeType;
        private Integer originalThroughput;
        private Boolean originalMultiAttachEnabled;
        private Long progress;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            this.volumeId(model.volumeId);
            this.modificationState(model.modificationState);
            this.statusMessage(model.statusMessage);
            this.targetSize(model.targetSize);
            this.targetIops(model.targetIops);
            this.targetVolumeType(model.targetVolumeType);
            this.targetThroughput(model.targetThroughput);
            this.targetMultiAttachEnabled(model.targetMultiAttachEnabled);
            this.originalSize(model.originalSize);
            this.originalIops(model.originalIops);
            this.originalVolumeType(model.originalVolumeType);
            this.originalThroughput(model.originalThroughput);
            this.originalMultiAttachEnabled(model.originalMultiAttachEnabled);
            this.progress(model.progress);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getModificationState() {
            return this.modificationState;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Integer getTargetSize() {
            return this.targetSize;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final Integer getTargetIops() {
            return this.targetIops;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final String getTargetVolumeType() {
            return this.targetVolumeType;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType == null ? null : targetVolumeType.toString());
            return this;
        }

        public final Integer getTargetThroughput() {
            return this.targetThroughput;
        }

        public final void setTargetThroughput(Integer targetThroughput) {
            this.targetThroughput = targetThroughput;
        }

        @Override
        public final Builder targetThroughput(Integer targetThroughput) {
            this.targetThroughput = targetThroughput;
            return this;
        }

        public final Boolean getTargetMultiAttachEnabled() {
            return this.targetMultiAttachEnabled;
        }

        public final void setTargetMultiAttachEnabled(Boolean targetMultiAttachEnabled) {
            this.targetMultiAttachEnabled = targetMultiAttachEnabled;
        }

        @Override
        public final Builder targetMultiAttachEnabled(Boolean targetMultiAttachEnabled) {
            this.targetMultiAttachEnabled = targetMultiAttachEnabled;
            return this;
        }

        public final Integer getOriginalSize() {
            return this.originalSize;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final Integer getOriginalIops() {
            return this.originalIops;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final String getOriginalVolumeType() {
            return this.originalVolumeType;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType == null ? null : originalVolumeType.toString());
            return this;
        }

        public final Integer getOriginalThroughput() {
            return this.originalThroughput;
        }

        public final void setOriginalThroughput(Integer originalThroughput) {
            this.originalThroughput = originalThroughput;
        }

        @Override
        public final Builder originalThroughput(Integer originalThroughput) {
            this.originalThroughput = originalThroughput;
            return this;
        }

        public final Boolean getOriginalMultiAttachEnabled() {
            return this.originalMultiAttachEnabled;
        }

        public final void setOriginalMultiAttachEnabled(Boolean originalMultiAttachEnabled) {
            this.originalMultiAttachEnabled = originalMultiAttachEnabled;
        }

        @Override
        public final Builder originalMultiAttachEnabled(Boolean originalMultiAttachEnabled) {
            this.originalMultiAttachEnabled = originalMultiAttachEnabled;
            return this;
        }

        public final Long getProgress() {
            return this.progress;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public VolumeModification build() {
            return new VolumeModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeModification> {
        public Builder volumeId(String var1);

        public Builder modificationState(String var1);

        public Builder modificationState(VolumeModificationState var1);

        public Builder statusMessage(String var1);

        public Builder targetSize(Integer var1);

        public Builder targetIops(Integer var1);

        public Builder targetVolumeType(String var1);

        public Builder targetVolumeType(VolumeType var1);

        public Builder targetThroughput(Integer var1);

        public Builder targetMultiAttachEnabled(Boolean var1);

        public Builder originalSize(Integer var1);

        public Builder originalIops(Integer var1);

        public Builder originalVolumeType(String var1);

        public Builder originalVolumeType(VolumeType var1);

        public Builder originalThroughput(Integer var1);

        public Builder originalMultiAttachEnabled(Boolean var1);

        public Builder progress(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

