/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReportState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeclarativePoliciesReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeclarativePoliciesReport> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportId").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::reportId)).setter(DeclarativePoliciesReport.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").unmarshallLocationName("reportId").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::s3Bucket)).setter(DeclarativePoliciesReport.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").unmarshallLocationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::s3Prefix)).setter(DeclarativePoliciesReport.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").unmarshallLocationName("s3Prefix").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::targetId)).setter(DeclarativePoliciesReport.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").unmarshallLocationName("targetId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::startTime)).setter(DeclarativePoliciesReport.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::endTime)).setter(DeclarativePoliciesReport.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::statusAsString)).setter(DeclarativePoliciesReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DeclarativePoliciesReport.getter(DeclarativePoliciesReport::tags)).setter(DeclarativePoliciesReport.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD, TARGET_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReportId", REPORT_ID_FIELD);
            this.put("S3Bucket", S3_BUCKET_FIELD);
            this.put("S3Prefix", S3_PREFIX_FIELD);
            this.put("TargetId", TARGET_ID_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String reportId;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String targetId;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final List<Tag> tags;

    private DeclarativePoliciesReport(BuilderImpl builder) {
        this.reportId = builder.reportId;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.targetId = builder.targetId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ReportState status() {
        return ReportState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeclarativePoliciesReport)) {
            return false;
        }
        DeclarativePoliciesReport other = (DeclarativePoliciesReport)obj;
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DeclarativePoliciesReport").add("ReportId", (Object)this.reportId()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).add("TargetId", (Object)this.targetId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeclarativePoliciesReport, T> g) {
        return obj -> g.apply((DeclarativePoliciesReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportId;
        private String s3Bucket;
        private String s3Prefix;
        private String targetId;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeclarativePoliciesReport model) {
            this.reportId(model.reportId);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.targetId(model.targetId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeclarativePoliciesReport build() {
            return new DeclarativePoliciesReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeclarativePoliciesReport> {
        public Builder reportId(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder targetId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ReportState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

