/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.IpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.IpamOrganizationalUnitExclusion;
import software.amazon.awssdk.services.ec2.model.IpamOrganizationalUnitExclusionSetCopier;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamResourceDiscovery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamResourceDiscovery> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::ownerId)).setter(IpamResourceDiscovery.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::ipamResourceDiscoveryId)).setter(IpamResourceDiscovery.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("ipamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryArn").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::ipamResourceDiscoveryArn)).setter(IpamResourceDiscovery.setter(Builder::ipamResourceDiscoveryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryArn").unmarshallLocationName("ipamResourceDiscoveryArn").build()}).build();
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryRegion").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::ipamResourceDiscoveryRegion)).setter(IpamResourceDiscovery.setter(Builder::ipamResourceDiscoveryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryRegion").unmarshallLocationName("ipamResourceDiscoveryRegion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::description)).setter(IpamResourceDiscovery.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<IpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingRegions").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::operatingRegions)).setter(IpamResourceDiscovery.setter(Builder::operatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegionSet").unmarshallLocationName("operatingRegionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::isDefault)).setter(IpamResourceDiscovery.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").unmarshallLocationName("isDefault").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::stateAsString)).setter(IpamResourceDiscovery.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::tags)).setter(IpamResourceDiscovery.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<IpamOrganizationalUnitExclusion>> ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitExclusions").getter(IpamResourceDiscovery.getter(IpamResourceDiscovery::organizationalUnitExclusions)).setter(IpamResourceDiscovery.setter(Builder::organizationalUnitExclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitExclusionSet").unmarshallLocationName("organizationalUnitExclusionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamOrganizationalUnitExclusion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_RESOURCE_DISCOVERY_ID_FIELD, IPAM_RESOURCE_DISCOVERY_ARN_FIELD, IPAM_RESOURCE_DISCOVERY_REGION_FIELD, DESCRIPTION_FIELD, OPERATING_REGIONS_FIELD, IS_DEFAULT_FIELD, STATE_FIELD, TAGS_FIELD, ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
            this.put("IpamResourceDiscoveryArn", IPAM_RESOURCE_DISCOVERY_ARN_FIELD);
            this.put("IpamResourceDiscoveryRegion", IPAM_RESOURCE_DISCOVERY_REGION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("OperatingRegionSet", OPERATING_REGIONS_FIELD);
            this.put("IsDefault", IS_DEFAULT_FIELD);
            this.put("State", STATE_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("OrganizationalUnitExclusionSet", ORGANIZATIONAL_UNIT_EXCLUSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamResourceDiscoveryId;
    private final String ipamResourceDiscoveryArn;
    private final String ipamResourceDiscoveryRegion;
    private final String description;
    private final List<IpamOperatingRegion> operatingRegions;
    private final Boolean isDefault;
    private final String state;
    private final List<Tag> tags;
    private final List<IpamOrganizationalUnitExclusion> organizationalUnitExclusions;

    private IpamResourceDiscovery(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.ipamResourceDiscoveryArn = builder.ipamResourceDiscoveryArn;
        this.ipamResourceDiscoveryRegion = builder.ipamResourceDiscoveryRegion;
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.isDefault = builder.isDefault;
        this.state = builder.state;
        this.tags = builder.tags;
        this.organizationalUnitExclusions = builder.organizationalUnitExclusions;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String ipamResourceDiscoveryArn() {
        return this.ipamResourceDiscoveryArn;
    }

    public final String ipamResourceDiscoveryRegion() {
        return this.ipamResourceDiscoveryRegion;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOperatingRegions() {
        return this.operatingRegions != null && !(this.operatingRegions instanceof SdkAutoConstructList);
    }

    public final List<IpamOperatingRegion> operatingRegions() {
        return this.operatingRegions;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final IpamResourceDiscoveryState state() {
        return IpamResourceDiscoveryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasOrganizationalUnitExclusions() {
        return this.organizationalUnitExclusions != null && !(this.organizationalUnitExclusions instanceof SdkAutoConstructList);
    }

    public final List<IpamOrganizationalUnitExclusion> organizationalUnitExclusions() {
        return this.organizationalUnitExclusions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingRegions() ? this.operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitExclusions() ? this.organizationalUnitExclusions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamResourceDiscovery)) {
            return false;
        }
        IpamResourceDiscovery other = (IpamResourceDiscovery)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.ipamResourceDiscoveryArn(), other.ipamResourceDiscoveryArn()) && Objects.equals(this.ipamResourceDiscoveryRegion(), other.ipamResourceDiscoveryRegion()) && Objects.equals(this.description(), other.description()) && this.hasOperatingRegions() == other.hasOperatingRegions() && Objects.equals(this.operatingRegions(), other.operatingRegions()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasOrganizationalUnitExclusions() == other.hasOrganizationalUnitExclusions() && Objects.equals(this.organizationalUnitExclusions(), other.organizationalUnitExclusions());
    }

    public final String toString() {
        return ToString.builder((String)"IpamResourceDiscovery").add("OwnerId", (Object)this.ownerId()).add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("IpamResourceDiscoveryArn", (Object)this.ipamResourceDiscoveryArn()).add("IpamResourceDiscoveryRegion", (Object)this.ipamResourceDiscoveryRegion()).add("Description", (Object)this.description()).add("OperatingRegions", this.hasOperatingRegions() ? this.operatingRegions() : null).add("IsDefault", (Object)this.isDefault()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("OrganizationalUnitExclusions", this.hasOrganizationalUnitExclusions() ? this.organizationalUnitExclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "IpamResourceDiscoveryArn": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryArn()));
            }
            case "IpamResourceDiscoveryRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryRegion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.operatingRegions()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "OrganizationalUnitExclusions": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitExclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpamResourceDiscovery, T> g) {
        return obj -> g.apply((IpamResourceDiscovery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamResourceDiscoveryId;
        private String ipamResourceDiscoveryArn;
        private String ipamResourceDiscoveryRegion;
        private String description;
        private List<IpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();
        private Boolean isDefault;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<IpamOrganizationalUnitExclusion> organizationalUnitExclusions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamResourceDiscovery model) {
            this.ownerId(model.ownerId);
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.ipamResourceDiscoveryArn(model.ipamResourceDiscoveryArn);
            this.ipamResourceDiscoveryRegion(model.ipamResourceDiscoveryRegion);
            this.description(model.description);
            this.operatingRegions(model.operatingRegions);
            this.isDefault(model.isDefault);
            this.state(model.state);
            this.tags(model.tags);
            this.organizationalUnitExclusions(model.organizationalUnitExclusions);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getIpamResourceDiscoveryArn() {
            return this.ipamResourceDiscoveryArn;
        }

        public final void setIpamResourceDiscoveryArn(String ipamResourceDiscoveryArn) {
            this.ipamResourceDiscoveryArn = ipamResourceDiscoveryArn;
        }

        @Override
        public final Builder ipamResourceDiscoveryArn(String ipamResourceDiscoveryArn) {
            this.ipamResourceDiscoveryArn = ipamResourceDiscoveryArn;
            return this;
        }

        public final String getIpamResourceDiscoveryRegion() {
            return this.ipamResourceDiscoveryRegion;
        }

        public final void setIpamResourceDiscoveryRegion(String ipamResourceDiscoveryRegion) {
            this.ipamResourceDiscoveryRegion = ipamResourceDiscoveryRegion;
        }

        @Override
        public final Builder ipamResourceDiscoveryRegion(String ipamResourceDiscoveryRegion) {
            this.ipamResourceDiscoveryRegion = ipamResourceDiscoveryRegion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IpamOperatingRegion.Builder> getOperatingRegions() {
            List<IpamOperatingRegion.Builder> result = IpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<IpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = IpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        public final Builder operatingRegions(Collection<IpamOperatingRegion> operatingRegions) {
            this.operatingRegions = IpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(IpamOperatingRegion ... operatingRegions) {
            this.operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(Consumer<IpamOperatingRegion.Builder> ... operatingRegions) {
            this.operatingRegions(Stream.of(operatingRegions).map(c -> (IpamOperatingRegion)((IpamOperatingRegion.Builder)IpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamResourceDiscoveryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IpamOrganizationalUnitExclusion.Builder> getOrganizationalUnitExclusions() {
            List<IpamOrganizationalUnitExclusion.Builder> result = IpamOrganizationalUnitExclusionSetCopier.copyToBuilder(this.organizationalUnitExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationalUnitExclusions(Collection<IpamOrganizationalUnitExclusion.BuilderImpl> organizationalUnitExclusions) {
            this.organizationalUnitExclusions = IpamOrganizationalUnitExclusionSetCopier.copyFromBuilder(organizationalUnitExclusions);
        }

        @Override
        public final Builder organizationalUnitExclusions(Collection<IpamOrganizationalUnitExclusion> organizationalUnitExclusions) {
            this.organizationalUnitExclusions = IpamOrganizationalUnitExclusionSetCopier.copy(organizationalUnitExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitExclusions(IpamOrganizationalUnitExclusion ... organizationalUnitExclusions) {
            this.organizationalUnitExclusions(Arrays.asList(organizationalUnitExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitExclusions(Consumer<IpamOrganizationalUnitExclusion.Builder> ... organizationalUnitExclusions) {
            this.organizationalUnitExclusions(Stream.of(organizationalUnitExclusions).map(c -> (IpamOrganizationalUnitExclusion)((IpamOrganizationalUnitExclusion.Builder)IpamOrganizationalUnitExclusion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamResourceDiscovery build() {
            return new IpamResourceDiscovery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamResourceDiscovery> {
        public Builder ownerId(String var1);

        public Builder ipamResourceDiscoveryId(String var1);

        public Builder ipamResourceDiscoveryArn(String var1);

        public Builder ipamResourceDiscoveryRegion(String var1);

        public Builder description(String var1);

        public Builder operatingRegions(Collection<IpamOperatingRegion> var1);

        public Builder operatingRegions(IpamOperatingRegion ... var1);

        public Builder operatingRegions(Consumer<IpamOperatingRegion.Builder> ... var1);

        public Builder isDefault(Boolean var1);

        public Builder state(String var1);

        public Builder state(IpamResourceDiscoveryState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder organizationalUnitExclusions(Collection<IpamOrganizationalUnitExclusion> var1);

        public Builder organizationalUnitExclusions(IpamOrganizationalUnitExclusion ... var1);

        public Builder organizationalUnitExclusions(Consumer<IpamOrganizationalUnitExclusion.Builder> ... var1);
    }
}

