/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamManagementState {
    MANAGED("managed"),
    UNMANAGED("unmanaged"),
    IGNORED("ignored"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamManagementState> VALUE_MAP;
    private final String value;

    private IpamManagementState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamManagementState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamManagementState> knownValues() {
        EnumSet<IpamManagementState> knownValues = EnumSet.allOf(IpamManagementState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamManagementState.class, IpamManagementState::toString);
    }
}

