/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InternetGatewayBlockMode;
import software.amazon.awssdk.services.ec2.model.VpcBlockPublicAccessState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcBlockPublicAccessOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcBlockPublicAccessOptions> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::awsAccountId)).setter(VpcBlockPublicAccessOptions.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").unmarshallLocationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::awsRegion)).setter(VpcBlockPublicAccessOptions.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").unmarshallLocationName("awsRegion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::stateAsString)).setter(VpcBlockPublicAccessOptions.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_BLOCK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayBlockMode").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::internetGatewayBlockModeAsString)).setter(VpcBlockPublicAccessOptions.setter(Builder::internetGatewayBlockMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayBlockMode").unmarshallLocationName("internetGatewayBlockMode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::reason)).setter(VpcBlockPublicAccessOptions.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").unmarshallLocationName("reason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(VpcBlockPublicAccessOptions.getter(VpcBlockPublicAccessOptions::lastUpdateTimestamp)).setter(VpcBlockPublicAccessOptions.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").unmarshallLocationName("lastUpdateTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_REGION_FIELD, STATE_FIELD, INTERNET_GATEWAY_BLOCK_MODE_FIELD, REASON_FIELD, LAST_UPDATE_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("AwsRegion", AWS_REGION_FIELD);
            this.put("State", STATE_FIELD);
            this.put("InternetGatewayBlockMode", INTERNET_GATEWAY_BLOCK_MODE_FIELD);
            this.put("Reason", REASON_FIELD);
            this.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String awsRegion;
    private final String state;
    private final String internetGatewayBlockMode;
    private final String reason;
    private final Instant lastUpdateTimestamp;

    private VpcBlockPublicAccessOptions(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.state = builder.state;
        this.internetGatewayBlockMode = builder.internetGatewayBlockMode;
        this.reason = builder.reason;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final VpcBlockPublicAccessState state() {
        return VpcBlockPublicAccessState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final InternetGatewayBlockMode internetGatewayBlockMode() {
        return InternetGatewayBlockMode.fromValue(this.internetGatewayBlockMode);
    }

    public final String internetGatewayBlockModeAsString() {
        return this.internetGatewayBlockMode;
    }

    public final String reason() {
        return this.reason;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayBlockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcBlockPublicAccessOptions)) {
            return false;
        }
        VpcBlockPublicAccessOptions other = (VpcBlockPublicAccessOptions)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.internetGatewayBlockModeAsString(), other.internetGatewayBlockModeAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"VpcBlockPublicAccessOptions").add("AwsAccountId", (Object)this.awsAccountId()).add("AwsRegion", (Object)this.awsRegion()).add("State", (Object)this.stateAsString()).add("InternetGatewayBlockMode", (Object)this.internetGatewayBlockModeAsString()).add("Reason", (Object)this.reason()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "InternetGatewayBlockMode": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayBlockModeAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcBlockPublicAccessOptions, T> g) {
        return obj -> g.apply((VpcBlockPublicAccessOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsRegion;
        private String state;
        private String internetGatewayBlockMode;
        private String reason;
        private Instant lastUpdateTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcBlockPublicAccessOptions model) {
            this.awsAccountId(model.awsAccountId);
            this.awsRegion(model.awsRegion);
            this.state(model.state);
            this.internetGatewayBlockMode(model.internetGatewayBlockMode);
            this.reason(model.reason);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcBlockPublicAccessState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getInternetGatewayBlockMode() {
            return this.internetGatewayBlockMode;
        }

        public final void setInternetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
        }

        @Override
        public final Builder internetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
            return this;
        }

        @Override
        public final Builder internetGatewayBlockMode(InternetGatewayBlockMode internetGatewayBlockMode) {
            this.internetGatewayBlockMode(internetGatewayBlockMode == null ? null : internetGatewayBlockMode.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public VpcBlockPublicAccessOptions build() {
            return new VpcBlockPublicAccessOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcBlockPublicAccessOptions> {
        public Builder awsAccountId(String var1);

        public Builder awsRegion(String var1);

        public Builder state(String var1);

        public Builder state(VpcBlockPublicAccessState var1);

        public Builder internetGatewayBlockMode(String var1);

        public Builder internetGatewayBlockMode(InternetGatewayBlockMode var1);

        public Builder reason(String var1);

        public Builder lastUpdateTimestamp(Instant var1);
    }
}

