/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MoveCapacityReservationInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, MoveCapacityReservationInstancesRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(MoveCapacityReservationInstancesRequest.getter(MoveCapacityReservationInstancesRequest::dryRun)).setter(MoveCapacityReservationInstancesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(MoveCapacityReservationInstancesRequest.getter(MoveCapacityReservationInstancesRequest::clientToken)).setter(MoveCapacityReservationInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCapacityReservationId").getter(MoveCapacityReservationInstancesRequest.getter(MoveCapacityReservationInstancesRequest::sourceCapacityReservationId)).setter(MoveCapacityReservationInstancesRequest.setter(Builder::sourceCapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId").unmarshallLocationName("SourceCapacityReservationId").build()}).build();
    private static final SdkField<String> DESTINATION_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCapacityReservationId").getter(MoveCapacityReservationInstancesRequest.getter(MoveCapacityReservationInstancesRequest::destinationCapacityReservationId)).setter(MoveCapacityReservationInstancesRequest.setter(Builder::destinationCapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCapacityReservationId").unmarshallLocationName("DestinationCapacityReservationId").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(MoveCapacityReservationInstancesRequest.getter(MoveCapacityReservationInstancesRequest::instanceCount)).setter(MoveCapacityReservationInstancesRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, SOURCE_CAPACITY_RESERVATION_ID_FIELD, DESTINATION_CAPACITY_RESERVATION_ID_FIELD, INSTANCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("SourceCapacityReservationId", SOURCE_CAPACITY_RESERVATION_ID_FIELD);
            this.put("DestinationCapacityReservationId", DESTINATION_CAPACITY_RESERVATION_ID_FIELD);
            this.put("InstanceCount", INSTANCE_COUNT_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String clientToken;
    private final String sourceCapacityReservationId;
    private final String destinationCapacityReservationId;
    private final Integer instanceCount;

    private MoveCapacityReservationInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.destinationCapacityReservationId = builder.destinationCapacityReservationId;
        this.instanceCount = builder.instanceCount;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String sourceCapacityReservationId() {
        return this.sourceCapacityReservationId;
    }

    public final String destinationCapacityReservationId() {
        return this.destinationCapacityReservationId;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveCapacityReservationInstancesRequest)) {
            return false;
        }
        MoveCapacityReservationInstancesRequest other = (MoveCapacityReservationInstancesRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourceCapacityReservationId(), other.sourceCapacityReservationId()) && Objects.equals(this.destinationCapacityReservationId(), other.destinationCapacityReservationId()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"MoveCapacityReservationInstancesRequest").add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).add("SourceCapacityReservationId", (Object)this.sourceCapacityReservationId()).add("DestinationCapacityReservationId", (Object)this.destinationCapacityReservationId()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SourceCapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.sourceCapacityReservationId()));
            }
            case "DestinationCapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.destinationCapacityReservationId()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MoveCapacityReservationInstancesRequest, T> g) {
        return obj -> g.apply((MoveCapacityReservationInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String clientToken;
        private String sourceCapacityReservationId;
        private String destinationCapacityReservationId;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveCapacityReservationInstancesRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
            this.sourceCapacityReservationId(model.sourceCapacityReservationId);
            this.destinationCapacityReservationId(model.destinationCapacityReservationId);
            this.instanceCount(model.instanceCount);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceCapacityReservationId() {
            return this.sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final String getDestinationCapacityReservationId() {
            return this.destinationCapacityReservationId;
        }

        public final void setDestinationCapacityReservationId(String destinationCapacityReservationId) {
            this.destinationCapacityReservationId = destinationCapacityReservationId;
        }

        @Override
        public final Builder destinationCapacityReservationId(String destinationCapacityReservationId) {
            this.destinationCapacityReservationId = destinationCapacityReservationId;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveCapacityReservationInstancesRequest build() {
            return new MoveCapacityReservationInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MoveCapacityReservationInstancesRequest> {
        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder sourceCapacityReservationId(String var1);

        public Builder destinationCapacityReservationId(String var1);

        public Builder instanceCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

