/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable;

public class DescribeTransitGatewayRouteTablesIterable
implements SdkIterable<DescribeTransitGatewayRouteTablesResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayRouteTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayRouteTablesIterable(Ec2Client client, DescribeTransitGatewayRouteTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewayRouteTablesResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayRouteTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayRouteTable> transitGatewayRouteTables() {
        Function<DescribeTransitGatewayRouteTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayRouteTables() != null) {
                return response.transitGatewayRouteTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayRouteTablesResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayRouteTablesResponse> {
        private DescribeTransitGatewayRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayRouteTablesResponse nextPage(DescribeTransitGatewayRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayRouteTablesIterable.this.client.describeTransitGatewayRouteTables(DescribeTransitGatewayRouteTablesIterable.this.firstRequest);
            }
            return DescribeTransitGatewayRouteTablesIterable.this.client.describeTransitGatewayRouteTables((DescribeTransitGatewayRouteTablesRequest)((Object)DescribeTransitGatewayRouteTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

