/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesListCopier;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetLaunchTemplateConfig> {
    private static final SdkField<FleetLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateSpecification").getter(FleetLaunchTemplateConfig.getter(FleetLaunchTemplateConfig::launchTemplateSpecification)).setter(FleetLaunchTemplateConfig.setter(Builder::launchTemplateSpecification)).constructor(FleetLaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification").unmarshallLocationName("launchTemplateSpecification").build()}).build();
    private static final SdkField<List<FleetLaunchTemplateOverrides>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(FleetLaunchTemplateConfig.getter(FleetLaunchTemplateConfig::overrides)).setter(FleetLaunchTemplateConfig.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").unmarshallLocationName("overrides").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetLaunchTemplateOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LaunchTemplateSpecification", LAUNCH_TEMPLATE_SPECIFICATION_FIELD);
            this.put("Overrides", OVERRIDES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FleetLaunchTemplateSpecification launchTemplateSpecification;
    private final List<FleetLaunchTemplateOverrides> overrides;

    private FleetLaunchTemplateConfig(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public final FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<FleetLaunchTemplateOverrides> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateConfig)) {
            return false;
        }
        FleetLaunchTemplateConfig other = (FleetLaunchTemplateConfig)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"FleetLaunchTemplateConfig").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateConfig, T> g) {
        return obj -> g.apply((FleetLaunchTemplateConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;
        private List<FleetLaunchTemplateOverrides> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateConfig model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final List<FleetLaunchTemplateOverrides.Builder> getOverrides() {
            List<FleetLaunchTemplateOverrides.Builder> result = FleetLaunchTemplateOverridesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<FleetLaunchTemplateOverrides.BuilderImpl> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<FleetLaunchTemplateOverrides> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(FleetLaunchTemplateOverrides ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (FleetLaunchTemplateOverrides)((FleetLaunchTemplateOverrides.Builder)FleetLaunchTemplateOverrides.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FleetLaunchTemplateConfig build() {
            return new FleetLaunchTemplateConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetLaunchTemplateConfig> {
        public Builder launchTemplateSpecification(FleetLaunchTemplateSpecification var1);

        default public Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((FleetLaunchTemplateSpecification)((FleetLaunchTemplateSpecification.Builder)FleetLaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(Collection<FleetLaunchTemplateOverrides> var1);

        public Builder overrides(FleetLaunchTemplateOverrides ... var1);

        public Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder> ... var1);
    }
}

