/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest;
import software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandOptionsRequest> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::allocationStrategyAsString)).setter(OnDemandOptionsRequest.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("AllocationStrategy").build()}).build();
    private static final SdkField<CapacityReservationOptionsRequest> CAPACITY_RESERVATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationOptions").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::capacityReservationOptions)).setter(OnDemandOptionsRequest.setter(Builder::capacityReservationOptions)).constructor(CapacityReservationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationOptions").unmarshallLocationName("CapacityReservationOptions").build()}).build();
    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SingleInstanceType").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::singleInstanceType)).setter(OnDemandOptionsRequest.setter(Builder::singleInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType").unmarshallLocationName("SingleInstanceType").build()}).build();
    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SingleAvailabilityZone").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::singleAvailabilityZone)).setter(OnDemandOptionsRequest.setter(Builder::singleAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone").unmarshallLocationName("SingleAvailabilityZone").build()}).build();
    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinTargetCapacity").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::minTargetCapacity)).setter(OnDemandOptionsRequest.setter(Builder::minTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity").unmarshallLocationName("MinTargetCapacity").build()}).build();
    private static final SdkField<String> MAX_TOTAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxTotalPrice").getter(OnDemandOptionsRequest.getter(OnDemandOptionsRequest::maxTotalPrice)).setter(OnDemandOptionsRequest.setter(Builder::maxTotalPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTotalPrice").unmarshallLocationName("MaxTotalPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, CAPACITY_RESERVATION_OPTIONS_FIELD, SINGLE_INSTANCE_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, MIN_TARGET_CAPACITY_FIELD, MAX_TOTAL_PRICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllocationStrategy", ALLOCATION_STRATEGY_FIELD);
            this.put("CapacityReservationOptions", CAPACITY_RESERVATION_OPTIONS_FIELD);
            this.put("SingleInstanceType", SINGLE_INSTANCE_TYPE_FIELD);
            this.put("SingleAvailabilityZone", SINGLE_AVAILABILITY_ZONE_FIELD);
            this.put("MinTargetCapacity", MIN_TARGET_CAPACITY_FIELD);
            this.put("MaxTotalPrice", MAX_TOTAL_PRICE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final CapacityReservationOptionsRequest capacityReservationOptions;
    private final Boolean singleInstanceType;
    private final Boolean singleAvailabilityZone;
    private final Integer minTargetCapacity;
    private final String maxTotalPrice;

    private OnDemandOptionsRequest(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.capacityReservationOptions = builder.capacityReservationOptions;
        this.singleInstanceType = builder.singleInstanceType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.minTargetCapacity = builder.minTargetCapacity;
        this.maxTotalPrice = builder.maxTotalPrice;
    }

    public final FleetOnDemandAllocationStrategy allocationStrategy() {
        return FleetOnDemandAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final CapacityReservationOptionsRequest capacityReservationOptions() {
        return this.capacityReservationOptions;
    }

    public final Boolean singleInstanceType() {
        return this.singleInstanceType;
    }

    public final Boolean singleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public final Integer minTargetCapacity() {
        return this.minTargetCapacity;
    }

    public final String maxTotalPrice() {
        return this.maxTotalPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTotalPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandOptionsRequest)) {
            return false;
        }
        OnDemandOptionsRequest other = (OnDemandOptionsRequest)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.capacityReservationOptions(), other.capacityReservationOptions()) && Objects.equals(this.singleInstanceType(), other.singleInstanceType()) && Objects.equals(this.singleAvailabilityZone(), other.singleAvailabilityZone()) && Objects.equals(this.minTargetCapacity(), other.minTargetCapacity()) && Objects.equals(this.maxTotalPrice(), other.maxTotalPrice());
    }

    public final String toString() {
        return ToString.builder((String)"OnDemandOptionsRequest").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("CapacityReservationOptions", (Object)this.capacityReservationOptions()).add("SingleInstanceType", (Object)this.singleInstanceType()).add("SingleAvailabilityZone", (Object)this.singleAvailabilityZone()).add("MinTargetCapacity", (Object)this.minTargetCapacity()).add("MaxTotalPrice", (Object)this.maxTotalPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "CapacityReservationOptions": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationOptions()));
            }
            case "SingleInstanceType": {
                return Optional.ofNullable(clazz.cast(this.singleInstanceType()));
            }
            case "SingleAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.singleAvailabilityZone()));
            }
            case "MinTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.minTargetCapacity()));
            }
            case "MaxTotalPrice": {
                return Optional.ofNullable(clazz.cast(this.maxTotalPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandOptionsRequest, T> g) {
        return obj -> g.apply((OnDemandOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private CapacityReservationOptionsRequest capacityReservationOptions;
        private Boolean singleInstanceType;
        private Boolean singleAvailabilityZone;
        private Integer minTargetCapacity;
        private String maxTotalPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandOptionsRequest model) {
            this.allocationStrategy(model.allocationStrategy);
            this.capacityReservationOptions(model.capacityReservationOptions);
            this.singleInstanceType(model.singleInstanceType);
            this.singleAvailabilityZone(model.singleAvailabilityZone);
            this.minTargetCapacity(model.minTargetCapacity);
            this.maxTotalPrice(model.maxTotalPrice);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final CapacityReservationOptionsRequest.Builder getCapacityReservationOptions() {
            return this.capacityReservationOptions != null ? this.capacityReservationOptions.toBuilder() : null;
        }

        public final void setCapacityReservationOptions(CapacityReservationOptionsRequest.BuilderImpl capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions != null ? capacityReservationOptions.build() : null;
        }

        @Override
        public final Builder capacityReservationOptions(CapacityReservationOptionsRequest capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions;
            return this;
        }

        public final Boolean getSingleInstanceType() {
            return this.singleInstanceType;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final Boolean getSingleAvailabilityZone() {
            return this.singleAvailabilityZone;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        @Override
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final Integer getMinTargetCapacity() {
            return this.minTargetCapacity;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final String getMaxTotalPrice() {
            return this.maxTotalPrice;
        }

        public final void setMaxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
        }

        @Override
        public final Builder maxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
            return this;
        }

        public OnDemandOptionsRequest build() {
            return new OnDemandOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandOptionsRequest> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(FleetOnDemandAllocationStrategy var1);

        public Builder capacityReservationOptions(CapacityReservationOptionsRequest var1);

        default public Builder capacityReservationOptions(Consumer<CapacityReservationOptionsRequest.Builder> capacityReservationOptions) {
            return this.capacityReservationOptions((CapacityReservationOptionsRequest)((CapacityReservationOptionsRequest.Builder)CapacityReservationOptionsRequest.builder().applyMutation(capacityReservationOptions)).build());
        }

        public Builder singleInstanceType(Boolean var1);

        public Builder singleAvailabilityZone(Boolean var1);

        public Builder minTargetCapacity(Integer var1);

        public Builder maxTotalPrice(String var1);
    }
}

