/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InternetGatewayExclusionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcBlockPublicAccessExclusionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcBlockPublicAccessExclusionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVpcBlockPublicAccessExclusionRequest.getter(ModifyVpcBlockPublicAccessExclusionRequest::dryRun)).setter(ModifyVpcBlockPublicAccessExclusionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> EXCLUSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusionId").getter(ModifyVpcBlockPublicAccessExclusionRequest.getter(ModifyVpcBlockPublicAccessExclusionRequest::exclusionId)).setter(ModifyVpcBlockPublicAccessExclusionRequest.setter(Builder::exclusionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionId").unmarshallLocationName("ExclusionId").build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_EXCLUSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayExclusionMode").getter(ModifyVpcBlockPublicAccessExclusionRequest.getter(ModifyVpcBlockPublicAccessExclusionRequest::internetGatewayExclusionModeAsString)).setter(ModifyVpcBlockPublicAccessExclusionRequest.setter(Builder::internetGatewayExclusionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayExclusionMode").unmarshallLocationName("InternetGatewayExclusionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, EXCLUSION_ID_FIELD, INTERNET_GATEWAY_EXCLUSION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("ExclusionId", EXCLUSION_ID_FIELD);
            this.put("InternetGatewayExclusionMode", INTERNET_GATEWAY_EXCLUSION_MODE_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String exclusionId;
    private final String internetGatewayExclusionMode;

    private ModifyVpcBlockPublicAccessExclusionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.exclusionId = builder.exclusionId;
        this.internetGatewayExclusionMode = builder.internetGatewayExclusionMode;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String exclusionId() {
        return this.exclusionId;
    }

    public final InternetGatewayExclusionMode internetGatewayExclusionMode() {
        return InternetGatewayExclusionMode.fromValue(this.internetGatewayExclusionMode);
    }

    public final String internetGatewayExclusionModeAsString() {
        return this.internetGatewayExclusionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayExclusionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcBlockPublicAccessExclusionRequest)) {
            return false;
        }
        ModifyVpcBlockPublicAccessExclusionRequest other = (ModifyVpcBlockPublicAccessExclusionRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.exclusionId(), other.exclusionId()) && Objects.equals(this.internetGatewayExclusionModeAsString(), other.internetGatewayExclusionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcBlockPublicAccessExclusionRequest").add("DryRun", (Object)this.dryRun()).add("ExclusionId", (Object)this.exclusionId()).add("InternetGatewayExclusionMode", (Object)this.internetGatewayExclusionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ExclusionId": {
                return Optional.ofNullable(clazz.cast(this.exclusionId()));
            }
            case "InternetGatewayExclusionMode": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayExclusionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcBlockPublicAccessExclusionRequest, T> g) {
        return obj -> g.apply((ModifyVpcBlockPublicAccessExclusionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String exclusionId;
        private String internetGatewayExclusionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcBlockPublicAccessExclusionRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.exclusionId(model.exclusionId);
            this.internetGatewayExclusionMode(model.internetGatewayExclusionMode);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getExclusionId() {
            return this.exclusionId;
        }

        public final void setExclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
        }

        @Override
        public final Builder exclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
            return this;
        }

        public final String getInternetGatewayExclusionMode() {
            return this.internetGatewayExclusionMode;
        }

        public final void setInternetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
        }

        @Override
        public final Builder internetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
            return this;
        }

        @Override
        public final Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode(internetGatewayExclusionMode == null ? null : internetGatewayExclusionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcBlockPublicAccessExclusionRequest build() {
            return new ModifyVpcBlockPublicAccessExclusionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcBlockPublicAccessExclusionRequest> {
        public Builder dryRun(Boolean var1);

        public Builder exclusionId(String var1);

        public Builder internetGatewayExclusionMode(String var1);

        public Builder internetGatewayExclusionMode(InternetGatewayExclusionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

