/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficMirrorSessionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTrafficMirrorSessionRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::networkInterfaceId)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorTargetId").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::trafficMirrorTargetId)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::trafficMirrorTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId").unmarshallLocationName("TrafficMirrorTargetId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::trafficMirrorFilterId)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build()}).build();
    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PacketLength").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::packetLength)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::packetLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength").unmarshallLocationName("PacketLength").build()}).build();
    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionNumber").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::sessionNumber)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::sessionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber").unmarshallLocationName("SessionNumber").build()}).build();
    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VirtualNetworkId").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::virtualNetworkId)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::virtualNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId").unmarshallLocationName("VirtualNetworkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::description)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::tagSpecifications)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::dryRun)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrafficMirrorSessionRequest.getter(CreateTrafficMirrorSessionRequest::clientToken)).setter(CreateTrafficMirrorSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
            this.put("TrafficMirrorTargetId", TRAFFIC_MIRROR_TARGET_ID_FIELD);
            this.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
            this.put("PacketLength", PACKET_LENGTH_FIELD);
            this.put("SessionNumber", SESSION_NUMBER_FIELD);
            this.put("VirtualNetworkId", VIRTUAL_NETWORK_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String networkInterfaceId;
    private final String trafficMirrorTargetId;
    private final String trafficMirrorFilterId;
    private final Integer packetLength;
    private final Integer sessionNumber;
    private final Integer virtualNetworkId;
    private final String description;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;
    private final String clientToken;

    private CreateTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String trafficMirrorTargetId() {
        return this.trafficMirrorTargetId;
    }

    public final String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public final Integer packetLength() {
        return this.packetLength;
    }

    public final Integer sessionNumber() {
        return this.sessionNumber;
    }

    public final Integer virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorSessionRequest)) {
            return false;
        }
        CreateTrafficMirrorSessionRequest other = (CreateTrafficMirrorSessionRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.trafficMirrorTargetId(), other.trafficMirrorTargetId()) && Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.packetLength(), other.packetLength()) && Objects.equals(this.sessionNumber(), other.sessionNumber()) && Objects.equals(this.virtualNetworkId(), other.virtualNetworkId()) && Objects.equals(this.description(), other.description()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficMirrorSessionRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("TrafficMirrorTargetId", (Object)this.trafficMirrorTargetId()).add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("PacketLength", (Object)this.packetLength()).add("SessionNumber", (Object)this.sessionNumber()).add("VirtualNetworkId", (Object)this.virtualNetworkId()).add("Description", (Object)this.description()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "TrafficMirrorTargetId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargetId()));
            }
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "PacketLength": {
                return Optional.ofNullable(clazz.cast(this.packetLength()));
            }
            case "SessionNumber": {
                return Optional.ofNullable(clazz.cast(this.sessionNumber()));
            }
            case "VirtualNetworkId": {
                return Optional.ofNullable(clazz.cast(this.virtualNetworkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String trafficMirrorTargetId;
        private String trafficMirrorFilterId;
        private Integer packetLength;
        private Integer sessionNumber;
        private Integer virtualNetworkId;
        private String description;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorSessionRequest model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.trafficMirrorTargetId(model.trafficMirrorTargetId);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.packetLength(model.packetLength);
            this.sessionNumber(model.sessionNumber);
            this.virtualNetworkId(model.virtualNetworkId);
            this.description(model.description);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final Integer getPacketLength() {
            return this.packetLength;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final Integer getSessionNumber() {
            return this.sessionNumber;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final Integer getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorSessionRequest build() {
            return new CreateTrafficMirrorSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficMirrorSessionRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder trafficMirrorTargetId(String var1);

        public Builder trafficMirrorFilterId(String var1);

        public Builder packetLength(Integer var1);

        public Builder sessionNumber(Integer var1);

        public Builder virtualNetworkId(Integer var1);

        public Builder description(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

