/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VPC Block public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from
 * reaching or being reached from the internet through internet gateways and egress-only internet gateways. To learn
 * more about VPC BPA, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public
 * access to VPCs and subnets</a> in the <i>Amazon VPC User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcBlockPublicAccessOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcBlockPublicAccessOptions.Builder, VpcBlockPublicAccessOptions> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId")
            .getter(getter(VpcBlockPublicAccessOptions::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId")
                    .unmarshallLocationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion")
            .getter(getter(VpcBlockPublicAccessOptions::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion")
                    .unmarshallLocationName("awsRegion").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(VpcBlockPublicAccessOptions::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> INTERNET_GATEWAY_BLOCK_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayBlockMode")
            .getter(getter(VpcBlockPublicAccessOptions::internetGatewayBlockModeAsString))
            .setter(setter(Builder::internetGatewayBlockMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayBlockMode")
                    .unmarshallLocationName("internetGatewayBlockMode").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Reason")
            .getter(getter(VpcBlockPublicAccessOptions::reason))
            .setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason")
                    .unmarshallLocationName("reason").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTimestamp")
            .getter(getter(VpcBlockPublicAccessOptions::lastUpdateTimestamp))
            .setter(setter(Builder::lastUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp")
                    .unmarshallLocationName("lastUpdateTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_REGION_FIELD, STATE_FIELD, INTERNET_GATEWAY_BLOCK_MODE_FIELD, REASON_FIELD, LAST_UPDATE_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
                    put("AwsRegion", AWS_REGION_FIELD);
                    put("State", STATE_FIELD);
                    put("InternetGatewayBlockMode", INTERNET_GATEWAY_BLOCK_MODE_FIELD);
                    put("Reason", REASON_FIELD);
                    put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsRegion;

    private final String state;

    private final String internetGatewayBlockMode;

    private final String reason;

    private final Instant lastUpdateTimestamp;

    private VpcBlockPublicAccessOptions(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.state = builder.state;
        this.internetGatewayBlockMode = builder.internetGatewayBlockMode;
        this.reason = builder.reason;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
    }

    /**
     * <p>
     * An Amazon Web Services account ID.
     * </p>
     * 
     * @return An Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An Amazon Web Services Region.
     * </p>
     * 
     * @return An Amazon Web Services Region.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The current state of VPC BPA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of VPC BPA.
     * @see VpcBlockPublicAccessState
     */
    public final VpcBlockPublicAccessState state() {
        return VpcBlockPublicAccessState.fromValue(state);
    }

    /**
     * <p>
     * The current state of VPC BPA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of VPC BPA.
     * @see VpcBlockPublicAccessState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The current mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from internet
     * gateways and egress-only internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and egress-only
     * internet gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     * subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
     * because these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link InternetGatewayBlockMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The current mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from
     *         internet gateways and egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and
     *         egress-only internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for
     *         VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet
     *         gateways is allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see InternetGatewayBlockMode
     */
    public final InternetGatewayBlockMode internetGatewayBlockMode() {
        return InternetGatewayBlockMode.fromValue(internetGatewayBlockMode);
    }

    /**
     * <p>
     * The current mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from internet
     * gateways and egress-only internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and egress-only
     * internet gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     * subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
     * because these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link InternetGatewayBlockMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The current mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from
     *         internet gateways and egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and
     *         egress-only internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for
     *         VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet
     *         gateways is allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see InternetGatewayBlockMode
     */
    public final String internetGatewayBlockModeAsString() {
        return internetGatewayBlockMode;
    }

    /**
     * <p>
     * The reason for the current state.
     * </p>
     * 
     * @return The reason for the current state.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The last time the VPC BPA mode was updated.
     * </p>
     * 
     * @return The last time the VPC BPA mode was updated.
     */
    public final Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayBlockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcBlockPublicAccessOptions)) {
            return false;
        }
        VpcBlockPublicAccessOptions other = (VpcBlockPublicAccessOptions) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(internetGatewayBlockModeAsString(), other.internetGatewayBlockModeAsString())
                && Objects.equals(reason(), other.reason()) && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcBlockPublicAccessOptions").add("AwsAccountId", awsAccountId()).add("AwsRegion", awsRegion())
                .add("State", stateAsString()).add("InternetGatewayBlockMode", internetGatewayBlockModeAsString())
                .add("Reason", reason()).add("LastUpdateTimestamp", lastUpdateTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "InternetGatewayBlockMode":
            return Optional.ofNullable(clazz.cast(internetGatewayBlockModeAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcBlockPublicAccessOptions, T> g) {
        return obj -> g.apply((VpcBlockPublicAccessOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcBlockPublicAccessOptions> {
        /**
         * <p>
         * An Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        An Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An Amazon Web Services Region.
         * </p>
         * 
         * @param awsRegion
         *        An Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The current state of VPC BPA.
         * </p>
         * 
         * @param state
         *        The current state of VPC BPA.
         * @see VpcBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcBlockPublicAccessState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of VPC BPA.
         * </p>
         * 
         * @param state
         *        The current state of VPC BPA.
         * @see VpcBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcBlockPublicAccessState
         */
        Builder state(VpcBlockPublicAccessState state);

        /**
         * <p>
         * The current mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from internet
         * gateways and egress-only internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and egress-only
         * internet gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for VPCs
         * or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
         * allowed because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The current mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from
         *        internet gateways and egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and
         *        egress-only internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for
         *        VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet
         *        gateways is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see InternetGatewayBlockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayBlockMode
         */
        Builder internetGatewayBlockMode(String internetGatewayBlockMode);

        /**
         * <p>
         * The current mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from internet
         * gateways and egress-only internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and egress-only
         * internet gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for VPCs
         * or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
         * allowed because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The current mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-allowed</code>: VPC BPA is not enabled and traffic is allowed to and from
         *        internet gateways and egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bidirectional-access-blocked</code>: Block all traffic to and from internet gateways and
         *        egress-only internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ingress-access-blocked</code>: Block all internet traffic to the VPCs in this Region (except for
         *        VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet
         *        gateways is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see InternetGatewayBlockMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternetGatewayBlockMode
         */
        Builder internetGatewayBlockMode(InternetGatewayBlockMode internetGatewayBlockMode);

        /**
         * <p>
         * The reason for the current state.
         * </p>
         * 
         * @param reason
         *        The reason for the current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The last time the VPC BPA mode was updated.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The last time the VPC BPA mode was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsRegion;

        private String state;

        private String internetGatewayBlockMode;

        private String reason;

        private Instant lastUpdateTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcBlockPublicAccessOptions model) {
            awsAccountId(model.awsAccountId);
            awsRegion(model.awsRegion);
            state(model.state);
            internetGatewayBlockMode(model.internetGatewayBlockMode);
            reason(model.reason);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcBlockPublicAccessState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getInternetGatewayBlockMode() {
            return internetGatewayBlockMode;
        }

        public final void setInternetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
        }

        @Override
        public final Builder internetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
            return this;
        }

        @Override
        public final Builder internetGatewayBlockMode(InternetGatewayBlockMode internetGatewayBlockMode) {
            this.internetGatewayBlockMode(internetGatewayBlockMode == null ? null : internetGatewayBlockMode.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        @Override
        public VpcBlockPublicAccessOptions build() {
            return new VpcBlockPublicAccessOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
