/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(Volume::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(Volume::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("iops").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Volume::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(Volume::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("volumeType").build()).build();

    private static final SdkField<Boolean> FAST_RESTORED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FastRestored")
            .getter(getter(Volume::fastRestored))
            .setter(setter(Builder::fastRestored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastRestored")
                    .unmarshallLocationName("fastRestored").build()).build();

    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAttachEnabled")
            .getter(getter(Volume::multiAttachEnabled))
            .setter(setter(Builder::multiAttachEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled")
                    .unmarshallLocationName("multiAttachEnabled").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(Volume::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("throughput").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SseType")
            .getter(getter(Volume::sseTypeAsString))
            .setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType")
                    .unmarshallLocationName("sseType").build()).build();

    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField
            .<OperatorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(Volume::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("operator").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(Volume::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Size")
            .getter(getter(Volume::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size")
                    .unmarshallLocationName("size").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(Volume::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(Volume::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Volume::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(Volume::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<List<VolumeAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<VolumeAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(Volume::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSet")
                    .unmarshallLocationName("attachmentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(Volume::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(Volume::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD, IOPS_FIELD,
            TAGS_FIELD, VOLUME_TYPE_FIELD, FAST_RESTORED_FIELD, MULTI_ATTACH_ENABLED_FIELD, THROUGHPUT_FIELD, SSE_TYPE_FIELD,
            OPERATOR_FIELD, VOLUME_ID_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATE_FIELD,
            CREATE_TIME_FIELD, ATTACHMENTS_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OutpostArn", OUTPOST_ARN_FIELD);
                    put("Iops", IOPS_FIELD);
                    put("TagSet", TAGS_FIELD);
                    put("VolumeType", VOLUME_TYPE_FIELD);
                    put("FastRestored", FAST_RESTORED_FIELD);
                    put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
                    put("Throughput", THROUGHPUT_FIELD);
                    put("SseType", SSE_TYPE_FIELD);
                    put("Operator", OPERATOR_FIELD);
                    put("VolumeId", VOLUME_ID_FIELD);
                    put("Size", SIZE_FIELD);
                    put("SnapshotId", SNAPSHOT_ID_FIELD);
                    put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
                    put("Status", STATE_FIELD);
                    put("CreateTime", CREATE_TIME_FIELD);
                    put("AttachmentSet", ATTACHMENTS_FIELD);
                    put("Encrypted", ENCRYPTED_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String outpostArn;

    private final Integer iops;

    private final List<Tag> tags;

    private final String volumeType;

    private final Boolean fastRestored;

    private final Boolean multiAttachEnabled;

    private final Integer throughput;

    private final String sseType;

    private final OperatorResponse operator;

    private final String volumeId;

    private final Integer size;

    private final String snapshotId;

    private final String availabilityZone;

    private final String state;

    private final Instant createTime;

    private final List<VolumeAttachment> attachments;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private Volume(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.iops = builder.iops;
        this.tags = builder.tags;
        this.volumeType = builder.volumeType;
        this.fastRestored = builder.fastRestored;
        this.multiAttachEnabled = builder.multiAttachEnabled;
        this.throughput = builder.throughput;
        this.sseType = builder.sseType;
        this.operator = builder.operator;
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.attachments = builder.attachments;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
     * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes,
     * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
     * for bursting.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
     *         <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
     *         <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
     *         the volume accumulates I/O credits for bursting.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the volume.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <note>
     * <p>
     * This parameter is not returned by CreateVolume.
     * </p>
     * </note>
     * <p>
     * Indicates whether the volume was created using fast snapshot restore.
     * </p>
     * 
     * @return <p>
     *         This parameter is not returned by CreateVolume.
     *         </p>
     *         </note>
     *         <p>
     *         Indicates whether the volume was created using fast snapshot restore.
     */
    public final Boolean fastRestored() {
        return fastRestored;
    }

    /**
     * <p>
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     * </p>
     * 
     * @return Indicates whether Amazon EBS Multi-Attach is enabled.
     */
    public final Boolean multiAttachEnabled() {
        return multiAttachEnabled;
    }

    /**
     * <p>
     * The throughput that the volume supports, in MiB/s.
     * </p>
     * 
     * @return The throughput that the volume supports, in MiB/s.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <note>
     * <p>
     * This parameter is not returned by CreateVolume.
     * </p>
     * </note>
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         This parameter is not returned by CreateVolume.
     *         </p>
     *         </note>
     *         <p>
     *         Reserved for future use.
     * @see SSEType
     */
    public final SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <note>
     * <p>
     * This parameter is not returned by CreateVolume.
     * </p>
     * </note>
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         This parameter is not returned by CreateVolume.
     *         </p>
     *         </note>
     *         <p>
     *         Reserved for future use.
     * @see SSEType
     */
    public final String sseTypeAsString() {
        return sseType;
    }

    /**
     * <p>
     * The entity that manages the volume.
     * </p>
     * 
     * @return The entity that manages the volume.
     */
    public final OperatorResponse operator() {
        return operator;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The size of the volume, in GiBs.
     * </p>
     * 
     * @return The size of the volume, in GiBs.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which the volume was created, if applicable.
     * </p>
     * 
     * @return The snapshot from which the volume was created, if applicable.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The Availability Zone for the volume.
     * </p>
     * 
     * @return The Availability Zone for the volume.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The volume state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The volume state.
     * @see VolumeState
     */
    public final VolumeState state() {
        return VolumeState.fromValue(state);
    }

    /**
     * <p>
     * The volume state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The volume state.
     * @see VolumeState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time stamp when volume creation was initiated.
     * </p>
     * 
     * @return The time stamp when volume creation was initiated.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * This parameter is not returned by CreateVolume.
     * </p>
     * </note>
     * <p>
     * Information about the volume attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return <p>
     *         This parameter is not returned by CreateVolume.
     *         </p>
     *         </note>
     *         <p>
     *         Information about the volume attachments.
     */
    public final List<VolumeAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * Indicates whether the volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the volume is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the volume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the
     *         volume.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fastRestored());
        hashCode = 31 * hashCode + Objects.hashCode(multiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(iops(), other.iops())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(fastRestored(), other.fastRestored())
                && Objects.equals(multiAttachEnabled(), other.multiAttachEnabled())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(sseTypeAsString(), other.sseTypeAsString())
                && Objects.equals(operator(), other.operator()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(size(), other.size()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(createTime(), other.createTime())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("OutpostArn", outpostArn()).add("Iops", iops())
                .add("Tags", hasTags() ? tags() : null).add("VolumeType", volumeTypeAsString())
                .add("FastRestored", fastRestored()).add("MultiAttachEnabled", multiAttachEnabled())
                .add("Throughput", throughput()).add("SseType", sseTypeAsString()).add("Operator", operator())
                .add("VolumeId", volumeId()).add("Size", size()).add("SnapshotId", snapshotId())
                .add("AvailabilityZone", availabilityZone()).add("State", stateAsString()).add("CreateTime", createTime())
                .add("Attachments", hasAttachments() ? attachments() : null).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "FastRestored":
            return Optional.ofNullable(clazz.cast(fastRestored()));
        case "MultiAttachEnabled":
            return Optional.ofNullable(clazz.cast(multiAttachEnabled()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "SseType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
         * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code>
         * volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates
         * I/O credits for bursting.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
         *        <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
         *        <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
         *        the volume accumulates I/O credits for bursting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Any tags assigned to the volume.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the volume.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the volume.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Indicates whether the volume was created using fast snapshot restore.
         * </p>
         * 
         * @param fastRestored
         *        <p>
         *        This parameter is not returned by CreateVolume.
         *        </p>
         *        </note>
         *        <p>
         *        Indicates whether the volume was created using fast snapshot restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastRestored(Boolean fastRestored);

        /**
         * <p>
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         * </p>
         * 
         * @param multiAttachEnabled
         *        Indicates whether Amazon EBS Multi-Attach is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAttachEnabled(Boolean multiAttachEnabled);

        /**
         * <p>
         * The throughput that the volume supports, in MiB/s.
         * </p>
         * 
         * @param throughput
         *        The throughput that the volume supports, in MiB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        <p>
         *        This parameter is not returned by CreateVolume.
         *        </p>
         *        </note>
         *        <p>
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        <p>
         *        This parameter is not returned by CreateVolume.
         *        </p>
         *        </note>
         *        <p>
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);

        /**
         * <p>
         * The entity that manages the volume.
         * </p>
         * 
         * @param operator
         *        The entity that manages the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorResponse operator);

        /**
         * <p>
         * The entity that manages the volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorResponse.Builder} avoiding the
         * need to create one manually via {@link OperatorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorResponse)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorResponse)
         */
        default Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return operator(OperatorResponse.builder().applyMutation(operator).build());
        }

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The size of the volume, in GiBs.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which the volume was created, if applicable.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which the volume was created, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The Availability Zone for the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The volume state.
         * </p>
         * 
         * @param state
         *        The volume state.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(String state);

        /**
         * <p>
         * The volume state.
         * </p>
         * 
         * @param state
         *        The volume state.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(VolumeState state);

        /**
         * <p>
         * The time stamp when volume creation was initiated.
         * </p>
         * 
         * @param createTime
         *        The time stamp when volume creation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Information about the volume attachments.
         * </p>
         * 
         * @param attachments
         *        <p>
         *        This parameter is not returned by CreateVolume.
         *        </p>
         *        </note>
         *        <p>
         *        Information about the volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<VolumeAttachment> attachments);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Information about the volume attachments.
         * </p>
         * 
         * @param attachments
         *        <p>
         *        This parameter is not returned by CreateVolume.
         *        </p>
         *        </note>
         *        <p>
         *        Information about the volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(VolumeAttachment... attachments);

        /**
         * <note>
         * <p>
         * This parameter is not returned by CreateVolume.
         * </p>
         * </note>
         * <p>
         * Information about the volume attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VolumeAttachment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.VolumeAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VolumeAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #attachments(List<VolumeAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VolumeAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<VolumeAttachment>)
         */
        Builder attachments(Consumer<VolumeAttachment.Builder>... attachments);

        /**
         * <p>
         * Indicates whether the volume is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the
         * volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for
         *        the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String outpostArn;

        private Integer iops;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String volumeType;

        private Boolean fastRestored;

        private Boolean multiAttachEnabled;

        private Integer throughput;

        private String sseType;

        private OperatorResponse operator;

        private String volumeId;

        private Integer size;

        private String snapshotId;

        private String availabilityZone;

        private String state;

        private Instant createTime;

        private List<VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private Boolean encrypted;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            outpostArn(model.outpostArn);
            iops(model.iops);
            tags(model.tags);
            volumeType(model.volumeType);
            fastRestored(model.fastRestored);
            multiAttachEnabled(model.multiAttachEnabled);
            throughput(model.throughput);
            sseType(model.sseType);
            operator(model.operator);
            volumeId(model.volumeId);
            size(model.size);
            snapshotId(model.snapshotId);
            availabilityZone(model.availabilityZone);
            state(model.state);
            createTime(model.createTime);
            attachments(model.attachments);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Boolean getFastRestored() {
            return fastRestored;
        }

        public final void setFastRestored(Boolean fastRestored) {
            this.fastRestored = fastRestored;
        }

        @Override
        public final Builder fastRestored(Boolean fastRestored) {
            this.fastRestored = fastRestored;
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<VolumeAttachment.Builder> getAttachments() {
            List<VolumeAttachment.Builder> result = VolumeAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<VolumeAttachment> attachments) {
            this.attachments = VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(VolumeAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<VolumeAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> VolumeAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
