/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the vCPU configurations for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VCpuInfo implements SdkPojo, Serializable, ToCopyableBuilder<VCpuInfo.Builder, VCpuInfo> {
    private static final SdkField<Integer> DEFAULT_V_CPUS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultVCpus")
            .getter(getter(VCpuInfo::defaultVCpus))
            .setter(setter(Builder::defaultVCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVCpus")
                    .unmarshallLocationName("defaultVCpus").build()).build();

    private static final SdkField<Integer> DEFAULT_CORES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultCores")
            .getter(getter(VCpuInfo::defaultCores))
            .setter(setter(Builder::defaultCores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCores")
                    .unmarshallLocationName("defaultCores").build()).build();

    private static final SdkField<Integer> DEFAULT_THREADS_PER_CORE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultThreadsPerCore")
            .getter(getter(VCpuInfo::defaultThreadsPerCore))
            .setter(setter(Builder::defaultThreadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultThreadsPerCore")
                    .unmarshallLocationName("defaultThreadsPerCore").build()).build();

    private static final SdkField<List<Integer>> VALID_CORES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ValidCores")
            .getter(getter(VCpuInfo::validCores))
            .setter(setter(Builder::validCores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidCores")
                    .unmarshallLocationName("validCores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Integer>> VALID_THREADS_PER_CORE_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ValidThreadsPerCore")
            .getter(getter(VCpuInfo::validThreadsPerCore))
            .setter(setter(Builder::validThreadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidThreadsPerCore")
                    .unmarshallLocationName("validThreadsPerCore").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_V_CPUS_FIELD,
            DEFAULT_CORES_FIELD, DEFAULT_THREADS_PER_CORE_FIELD, VALID_CORES_FIELD, VALID_THREADS_PER_CORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DefaultVCpus", DEFAULT_V_CPUS_FIELD);
                    put("DefaultCores", DEFAULT_CORES_FIELD);
                    put("DefaultThreadsPerCore", DEFAULT_THREADS_PER_CORE_FIELD);
                    put("ValidCores", VALID_CORES_FIELD);
                    put("ValidThreadsPerCore", VALID_THREADS_PER_CORE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer defaultVCpus;

    private final Integer defaultCores;

    private final Integer defaultThreadsPerCore;

    private final List<Integer> validCores;

    private final List<Integer> validThreadsPerCore;

    private VCpuInfo(BuilderImpl builder) {
        this.defaultVCpus = builder.defaultVCpus;
        this.defaultCores = builder.defaultCores;
        this.defaultThreadsPerCore = builder.defaultThreadsPerCore;
        this.validCores = builder.validCores;
        this.validThreadsPerCore = builder.validThreadsPerCore;
    }

    /**
     * <p>
     * The default number of vCPUs for the instance type.
     * </p>
     * 
     * @return The default number of vCPUs for the instance type.
     */
    public final Integer defaultVCpus() {
        return defaultVCpus;
    }

    /**
     * <p>
     * The default number of cores for the instance type.
     * </p>
     * 
     * @return The default number of cores for the instance type.
     */
    public final Integer defaultCores() {
        return defaultCores;
    }

    /**
     * <p>
     * The default number of threads per core for the instance type.
     * </p>
     * 
     * @return The default number of threads per core for the instance type.
     */
    public final Integer defaultThreadsPerCore() {
        return defaultThreadsPerCore;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidCores property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValidCores() {
        return validCores != null && !(validCores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid number of cores that can be configured for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidCores} method.
     * </p>
     * 
     * @return The valid number of cores that can be configured for the instance type.
     */
    public final List<Integer> validCores() {
        return validCores;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidThreadsPerCore property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidThreadsPerCore() {
        return validThreadsPerCore != null && !(validThreadsPerCore instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid number of threads per core that can be configured for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidThreadsPerCore} method.
     * </p>
     * 
     * @return The valid number of threads per core that can be configured for the instance type.
     */
    public final List<Integer> validThreadsPerCore() {
        return validThreadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultVCpus());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCores());
        hashCode = 31 * hashCode + Objects.hashCode(defaultThreadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidCores() ? validCores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValidThreadsPerCore() ? validThreadsPerCore() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VCpuInfo)) {
            return false;
        }
        VCpuInfo other = (VCpuInfo) obj;
        return Objects.equals(defaultVCpus(), other.defaultVCpus()) && Objects.equals(defaultCores(), other.defaultCores())
                && Objects.equals(defaultThreadsPerCore(), other.defaultThreadsPerCore())
                && hasValidCores() == other.hasValidCores() && Objects.equals(validCores(), other.validCores())
                && hasValidThreadsPerCore() == other.hasValidThreadsPerCore()
                && Objects.equals(validThreadsPerCore(), other.validThreadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VCpuInfo").add("DefaultVCpus", defaultVCpus()).add("DefaultCores", defaultCores())
                .add("DefaultThreadsPerCore", defaultThreadsPerCore()).add("ValidCores", hasValidCores() ? validCores() : null)
                .add("ValidThreadsPerCore", hasValidThreadsPerCore() ? validThreadsPerCore() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultVCpus":
            return Optional.ofNullable(clazz.cast(defaultVCpus()));
        case "DefaultCores":
            return Optional.ofNullable(clazz.cast(defaultCores()));
        case "DefaultThreadsPerCore":
            return Optional.ofNullable(clazz.cast(defaultThreadsPerCore()));
        case "ValidCores":
            return Optional.ofNullable(clazz.cast(validCores()));
        case "ValidThreadsPerCore":
            return Optional.ofNullable(clazz.cast(validThreadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VCpuInfo, T> g) {
        return obj -> g.apply((VCpuInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VCpuInfo> {
        /**
         * <p>
         * The default number of vCPUs for the instance type.
         * </p>
         * 
         * @param defaultVCpus
         *        The default number of vCPUs for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVCpus(Integer defaultVCpus);

        /**
         * <p>
         * The default number of cores for the instance type.
         * </p>
         * 
         * @param defaultCores
         *        The default number of cores for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCores(Integer defaultCores);

        /**
         * <p>
         * The default number of threads per core for the instance type.
         * </p>
         * 
         * @param defaultThreadsPerCore
         *        The default number of threads per core for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultThreadsPerCore(Integer defaultThreadsPerCore);

        /**
         * <p>
         * The valid number of cores that can be configured for the instance type.
         * </p>
         * 
         * @param validCores
         *        The valid number of cores that can be configured for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validCores(Collection<Integer> validCores);

        /**
         * <p>
         * The valid number of cores that can be configured for the instance type.
         * </p>
         * 
         * @param validCores
         *        The valid number of cores that can be configured for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validCores(Integer... validCores);

        /**
         * <p>
         * The valid number of threads per core that can be configured for the instance type.
         * </p>
         * 
         * @param validThreadsPerCore
         *        The valid number of threads per core that can be configured for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validThreadsPerCore(Collection<Integer> validThreadsPerCore);

        /**
         * <p>
         * The valid number of threads per core that can be configured for the instance type.
         * </p>
         * 
         * @param validThreadsPerCore
         *        The valid number of threads per core that can be configured for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validThreadsPerCore(Integer... validThreadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private Integer defaultVCpus;

        private Integer defaultCores;

        private Integer defaultThreadsPerCore;

        private List<Integer> validCores = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> validThreadsPerCore = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VCpuInfo model) {
            defaultVCpus(model.defaultVCpus);
            defaultCores(model.defaultCores);
            defaultThreadsPerCore(model.defaultThreadsPerCore);
            validCores(model.validCores);
            validThreadsPerCore(model.validThreadsPerCore);
        }

        public final Integer getDefaultVCpus() {
            return defaultVCpus;
        }

        public final void setDefaultVCpus(Integer defaultVCpus) {
            this.defaultVCpus = defaultVCpus;
        }

        @Override
        public final Builder defaultVCpus(Integer defaultVCpus) {
            this.defaultVCpus = defaultVCpus;
            return this;
        }

        public final Integer getDefaultCores() {
            return defaultCores;
        }

        public final void setDefaultCores(Integer defaultCores) {
            this.defaultCores = defaultCores;
        }

        @Override
        public final Builder defaultCores(Integer defaultCores) {
            this.defaultCores = defaultCores;
            return this;
        }

        public final Integer getDefaultThreadsPerCore() {
            return defaultThreadsPerCore;
        }

        public final void setDefaultThreadsPerCore(Integer defaultThreadsPerCore) {
            this.defaultThreadsPerCore = defaultThreadsPerCore;
        }

        @Override
        public final Builder defaultThreadsPerCore(Integer defaultThreadsPerCore) {
            this.defaultThreadsPerCore = defaultThreadsPerCore;
            return this;
        }

        public final Collection<Integer> getValidCores() {
            if (validCores instanceof SdkAutoConstructList) {
                return null;
            }
            return validCores;
        }

        public final void setValidCores(Collection<Integer> validCores) {
            this.validCores = CoreCountListCopier.copy(validCores);
        }

        @Override
        public final Builder validCores(Collection<Integer> validCores) {
            this.validCores = CoreCountListCopier.copy(validCores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validCores(Integer... validCores) {
            validCores(Arrays.asList(validCores));
            return this;
        }

        public final Collection<Integer> getValidThreadsPerCore() {
            if (validThreadsPerCore instanceof SdkAutoConstructList) {
                return null;
            }
            return validThreadsPerCore;
        }

        public final void setValidThreadsPerCore(Collection<Integer> validThreadsPerCore) {
            this.validThreadsPerCore = ThreadsPerCoreListCopier.copy(validThreadsPerCore);
        }

        @Override
        public final Builder validThreadsPerCore(Collection<Integer> validThreadsPerCore) {
            this.validThreadsPerCore = ThreadsPerCoreListCopier.copy(validThreadsPerCore);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validThreadsPerCore(Integer... validThreadsPerCore) {
            validThreadsPerCore(Arrays.asList(validThreadsPerCore));
            return this;
        }

        @Override
        public VCpuInfo build() {
            return new VCpuInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
