/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information to include in the launch template.
 * </p>
 * <note>
 * <p>
 * You must specify at least one parameter for the launch template data.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestLaunchTemplateData implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestLaunchTemplateData.Builder, RequestLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(RequestLaunchTemplateData::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("KernelId").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(RequestLaunchTemplateData::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("EbsOptimized").build()).build();

    private static final SdkField<LaunchTemplateIamInstanceProfileSpecificationRequest> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<LaunchTemplateIamInstanceProfileSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(RequestLaunchTemplateData::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(LaunchTemplateIamInstanceProfileSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("IamInstanceProfile").build()).build();

    private static final SdkField<List<LaunchTemplateBlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<LaunchTemplateBlockDeviceMappingRequest>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(RequestLaunchTemplateData::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("BlockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateBlockDeviceMappingRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateBlockDeviceMappingRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(RequestLaunchTemplateData::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("NetworkInterface").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceNetworkInterfaceSpecification")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceNetworkInterfaceSpecification")
                                                    .unmarshallLocationName("InstanceNetworkInterfaceSpecification").build())
                                            .build()).build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(RequestLaunchTemplateData::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(RequestLaunchTemplateData::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(RequestLaunchTemplateData::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build()).build();

    private static final SdkField<LaunchTemplatesMonitoringRequest> MONITORING_FIELD = SdkField
            .<LaunchTemplatesMonitoringRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(RequestLaunchTemplateData::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(LaunchTemplatesMonitoringRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("Monitoring").build()).build();

    private static final SdkField<LaunchTemplatePlacementRequest> PLACEMENT_FIELD = SdkField
            .<LaunchTemplatePlacementRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(RequestLaunchTemplateData::placement))
            .setter(setter(Builder::placement))
            .constructor(LaunchTemplatePlacementRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("Placement").build()).build();

    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamDiskId")
            .getter(getter(RequestLaunchTemplateData::ramDiskId))
            .setter(setter(Builder::ramDiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId")
                    .unmarshallLocationName("RamDiskId").build()).build();

    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiTermination")
            .getter(getter(RequestLaunchTemplateData::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("DisableApiTermination").build()).build();

    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(RequestLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("InstanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(RequestLaunchTemplateData::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("UserData").build()).build();

    private static final SdkField<List<LaunchTemplateTagSpecificationRequest>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateTagSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(RequestLaunchTemplateData::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LaunchTemplateTagSpecificationRequest")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateTagSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateTagSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LaunchTemplateTagSpecificationRequest")
                                                    .unmarshallLocationName("LaunchTemplateTagSpecificationRequest").build())
                                            .build()).build()).build();

    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField
            .<List<ElasticGpuSpecification>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuSpecifications")
            .getter(getter(RequestLaunchTemplateData::elasticGpuSpecifications))
            .setter(setter(Builder::elasticGpuSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification")
                    .unmarshallLocationName("ElasticGpuSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ElasticGpuSpecification")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ElasticGpuSpecification")
                                                    .unmarshallLocationName("ElasticGpuSpecification").build()).build()).build())
            .build();

    private static final SdkField<List<LaunchTemplateElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<LaunchTemplateElasticInferenceAccelerator>> builder(MarshallingType.LIST)
            .memberName("ElasticInferenceAccelerators")
            .getter(getter(RequestLaunchTemplateData::elasticInferenceAccelerators))
            .setter(setter(Builder::elasticInferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator")
                    .unmarshallLocationName("ElasticInferenceAccelerator").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateElasticInferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateElasticInferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(RequestLaunchTemplateData::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(RequestLaunchTemplateData::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup")
                    .unmarshallLocationName("SecurityGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroup").unmarshallLocationName("SecurityGroup")
                                                    .build()).build()).build()).build();

    private static final SdkField<LaunchTemplateInstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMarketOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMarketOptions")
            .getter(getter(RequestLaunchTemplateData::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions))
            .constructor(LaunchTemplateInstanceMarketOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions")
                    .unmarshallLocationName("InstanceMarketOptions").build()).build();

    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField
            .<CreditSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CreditSpecification")
            .getter(getter(RequestLaunchTemplateData::creditSpecification))
            .setter(setter(Builder::creditSpecification))
            .constructor(CreditSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification")
                    .unmarshallLocationName("CreditSpecification").build()).build();

    private static final SdkField<LaunchTemplateCpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField
            .<LaunchTemplateCpuOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CpuOptions")
            .getter(getter(RequestLaunchTemplateData::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(LaunchTemplateCpuOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("CpuOptions").build()).build();

    private static final SdkField<LaunchTemplateCapacityReservationSpecificationRequest> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<LaunchTemplateCapacityReservationSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(RequestLaunchTemplateData::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(LaunchTemplateCapacityReservationSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("CapacityReservationSpecification").build()).build();

    private static final SdkField<List<LaunchTemplateLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateLicenseConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(RequestLaunchTemplateData::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification")
                    .unmarshallLocationName("LicenseSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateLicenseConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateLicenseConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<LaunchTemplateHibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField
            .<LaunchTemplateHibernationOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("HibernationOptions")
            .getter(getter(RequestLaunchTemplateData::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(LaunchTemplateHibernationOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("HibernationOptions").build()).build();

    private static final SdkField<LaunchTemplateInstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMetadataOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("MetadataOptions")
            .getter(getter(RequestLaunchTemplateData::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(LaunchTemplateInstanceMetadataOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("MetadataOptions").build()).build();

    private static final SdkField<LaunchTemplateEnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField
            .<LaunchTemplateEnclaveOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("EnclaveOptions")
            .getter(getter(RequestLaunchTemplateData::enclaveOptions))
            .setter(setter(Builder::enclaveOptions))
            .constructor(LaunchTemplateEnclaveOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions")
                    .unmarshallLocationName("EnclaveOptions").build()).build();

    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirementsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements")
            .getter(getter(RequestLaunchTemplateData::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirementsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements")
                    .unmarshallLocationName("InstanceRequirements").build()).build();

    private static final SdkField<LaunchTemplatePrivateDnsNameOptionsRequest> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField
            .<LaunchTemplatePrivateDnsNameOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateDnsNameOptions")
            .getter(getter(RequestLaunchTemplateData::privateDnsNameOptions))
            .setter(setter(Builder::privateDnsNameOptions))
            .constructor(LaunchTemplatePrivateDnsNameOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions")
                    .unmarshallLocationName("PrivateDnsNameOptions").build()).build();

    private static final SdkField<LaunchTemplateInstanceMaintenanceOptionsRequest> MAINTENANCE_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMaintenanceOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceOptions")
            .getter(getter(RequestLaunchTemplateData::maintenanceOptions))
            .setter(setter(Builder::maintenanceOptions))
            .constructor(LaunchTemplateInstanceMaintenanceOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions")
                    .unmarshallLocationName("MaintenanceOptions").build()).build();

    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiStop")
            .getter(getter(RequestLaunchTemplateData::disableApiStop))
            .setter(setter(Builder::disableApiStop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop")
                    .unmarshallLocationName("DisableApiStop").build()).build();

    private static final SdkField<OperatorRequest> OPERATOR_FIELD = SdkField
            .<OperatorRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(RequestLaunchTemplateData::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD,
            EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD,
            IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD,
            DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD,
            ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD,
            SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD,
            METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD, INSTANCE_REQUIREMENTS_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD,
            MAINTENANCE_OPTIONS_FIELD, DISABLE_API_STOP_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("KernelId", KERNEL_ID_FIELD);
                    put("EbsOptimized", EBS_OPTIMIZED_FIELD);
                    put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
                    put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
                    put("NetworkInterface", NETWORK_INTERFACES_FIELD);
                    put("ImageId", IMAGE_ID_FIELD);
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("KeyName", KEY_NAME_FIELD);
                    put("Monitoring", MONITORING_FIELD);
                    put("Placement", PLACEMENT_FIELD);
                    put("RamDiskId", RAM_DISK_ID_FIELD);
                    put("DisableApiTermination", DISABLE_API_TERMINATION_FIELD);
                    put("InstanceInitiatedShutdownBehavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD);
                    put("UserData", USER_DATA_FIELD);
                    put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
                    put("ElasticGpuSpecification", ELASTIC_GPU_SPECIFICATIONS_FIELD);
                    put("ElasticInferenceAccelerator", ELASTIC_INFERENCE_ACCELERATORS_FIELD);
                    put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
                    put("SecurityGroup", SECURITY_GROUPS_FIELD);
                    put("InstanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
                    put("CreditSpecification", CREDIT_SPECIFICATION_FIELD);
                    put("CpuOptions", CPU_OPTIONS_FIELD);
                    put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
                    put("LicenseSpecification", LICENSE_SPECIFICATIONS_FIELD);
                    put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
                    put("MetadataOptions", METADATA_OPTIONS_FIELD);
                    put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
                    put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
                    put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
                    put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
                    put("DisableApiStop", DISABLE_API_STOP_FIELD);
                    put("Operator", OPERATOR_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kernelId;

    private final Boolean ebsOptimized;

    private final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;

    private final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings;

    private final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces;

    private final String imageId;

    private final String instanceType;

    private final String keyName;

    private final LaunchTemplatesMonitoringRequest monitoring;

    private final LaunchTemplatePlacementRequest placement;

    private final String ramDiskId;

    private final Boolean disableApiTermination;

    private final String instanceInitiatedShutdownBehavior;

    private final String userData;

    private final List<LaunchTemplateTagSpecificationRequest> tagSpecifications;

    private final List<ElasticGpuSpecification> elasticGpuSpecifications;

    private final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;

    private final CreditSpecificationRequest creditSpecification;

    private final LaunchTemplateCpuOptionsRequest cpuOptions;

    private final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;

    private final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications;

    private final LaunchTemplateHibernationOptionsRequest hibernationOptions;

    private final LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;

    private final LaunchTemplateEnclaveOptionsRequest enclaveOptions;

    private final InstanceRequirementsRequest instanceRequirements;

    private final LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions;

    private final LaunchTemplateInstanceMaintenanceOptionsRequest maintenanceOptions;

    private final Boolean disableApiStop;

    private final OperatorRequest operator;

    private RequestLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
        this.instanceRequirements = builder.instanceRequirements;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.disableApiStop = builder.disableApiStop;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the kernel.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided
     *         kernels</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized
     * instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS-optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    public final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping.
     */
    public final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return The network interfaces for the instance.
     */
    public final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The ID of the AMI in the format <code>ami-0ac394d6a3example</code>.
     * </p>
     * <p>
     * Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The Systems
     * Manager parameter will resolve to an AMI ID on launch.
     * </p>
     * <p>
     * To reference a public parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>public-parameter</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To reference a parameter stored in the same account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name:label</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To reference a parameter shared from another Amazon Web Services account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
     * >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the launch template will be used for an EC2 Fleet or Spot Fleet, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Only EC2 Fleets of type <code>instant</code> support specifying a Systems Manager parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EC2 Fleets of type <code>maintain</code> or <code>request</code>, or for Spot Fleets, you must specify the
     * AMI ID.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The ID of the AMI in the format <code>ami-0ac394d6a3example</code>.</p>
     *         <p>
     *         Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The
     *         Systems Manager parameter will resolve to an AMI ID on launch.
     *         </p>
     *         <p>
     *         To reference a public parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>public-parameter</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To reference a parameter stored in the same account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name:label</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To reference a parameter shared from another Amazon Web Services account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
     *         >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         If the launch template will be used for an EC2 Fleet or Spot Fleet, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Only EC2 Fleets of type <code>instant</code> support specifying a Systems Manager parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For EC2 Fleets of type <code>maintain</code> or <code>request</code>, or for Spot Fleets, you must
     *         specify the AMI ID.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance types</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance
     *         types</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance types</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance
     *         types</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the key pair. You can create a key pair using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     * </p>
     * <important>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured
     * to allow users another way to log in.
     * </p>
     * </important>
     * 
     * @return The name of the key pair. You can create a key pair using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or
     *         <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     *         </p> <important>
     *         <p>
     *         If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
     *         configured to allow users another way to log in.
     *         </p>
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public final LaunchTemplatesMonitoringRequest monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement for the instance.
     * </p>
     * 
     * @return The placement for the instance.
     */
    public final LaunchTemplatePlacementRequest placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the RAM disk.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided
     *         kernels</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     */
    public final String ramDiskId() {
        return ramDiskId;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2 console,
     * CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
     *         console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     *         >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     *         <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     */
    public final Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public final String instanceInitiatedShutdownBehaviorAsString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The user data to make available to the instance. You must provide base64-encoded text. User data is limited to 16
     * KB. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run
     * commands on your Amazon EC2 instance at launch</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you are creating the launch template for use with Batch, the user data must be provided in the <a
     * href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME multi-part
     * archive format</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in launch
     * templates</a> in the <i>Batch User Guide</i>.
     * </p>
     * 
     * @return The user data to make available to the instance. You must provide base64-encoded text. User data is
     *         limited to 16 KB. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Amazon EC2
     *         instance at launch</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         If you are creating the launch template for use with Batch, the user data must be provided in the <a
     *         href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME
     *         multi-part archive format</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in
     *         launch templates</a> in the <i>Batch User Guide</i>.
     */
    public final String userData() {
        return userData;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the resources that are created during instance launch. These tags are not applied to the
     * launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the resources that are created during instance launch. These tags are not applied to
     *         the launch template.
     */
    public final List<LaunchTemplateTagSpecificationRequest> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticGpuSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticGpuSpecifications() {
        return elasticGpuSpecifications != null && !(elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration,
     * we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticGpuSpecifications} method.
     * </p>
     * 
     * @return Deprecated.</p> <note>
     *         <p>
     *         Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
     *         acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
     *         </p>
     */
    public final List<ElasticGpuSpecification> elasticGpuSpecifications() {
        return elasticGpuSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticInferenceAccelerators property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticInferenceAccelerators() {
        return elasticInferenceAccelerators != null && !(elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * Amazon Elastic Inference is no longer available.
     * </p>
     * </note>
     * <p>
     * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a resource
     * you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * </p>
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     * </p>
     * <note>
     * <p>
     * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and
     * will help current customers migrate their workloads to options that offer better price and performance. After
     * April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon
     * SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past
     * 30-day period are considered current customers and will be able to continue using the service.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticInferenceAccelerators} method.
     * </p>
     * 
     * @return <p>
     *         Amazon Elastic Inference is no longer available.
     *         </p>
     *         </note>
     *         <p>
     *         An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
     *         resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
     *         workloads.
     *         </p>
     *         <p>
     *         You cannot specify accelerators from different generations in the same request.
     *         </p>
     *         <note>
     *         <p>
     *         Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference
     *         (EI), and will help current customers migrate their workloads to options that offer better price and
     *         performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI
     *         accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI
     *         at least once during the past 30-day period are considered current customers and will be able to continue
     *         using the service.
     *         </p>
     */
    public final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return elasticInferenceAccelerators;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups.
     * </p>
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface instead
     * of using this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups.</p>
     *         <p>
     *         If you specify a network interface, you must specify any security groups as part of the network interface
     *         instead of using this parameter.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the security groups. For a nondefault VPC, you must use security group IDs instead.
     * </p>
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface instead
     * of using this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The names of the security groups. For a nondefault VPC, you must use security group IDs instead.</p>
     *         <p>
     *         If you specify a network interface, you must specify any security groups as part of the network interface
     *         instead of using this parameter.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The market (purchasing) option for the instances.
     * </p>
     * 
     * @return The market (purchasing) option for the instances.
     */
    public final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The credit option for CPU usage of the instance. Valid only for T instances.
     * </p>
     * 
     * @return The credit option for CPU usage of the instance. Valid only for T instances.
     */
    public final CreditSpecificationRequest creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * The CPU options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The CPU options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
     *         options</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final LaunchTemplateCpuOptionsRequest cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
     * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity Reservation
     * that has matching attributes (instance type, platform, Availability Zone).
     * </p>
     * 
     * @return The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
     *         Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
     *         Reservation that has matching attributes (instance type, platform, Availability Zone).
     */
    public final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return The license configurations.
     */
    public final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets the
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
     * prerequisites</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2 instance</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance
     *         meets the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
     *         prerequisites</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2
     *         instance</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final LaunchTemplateHibernationOptionsRequest hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * <p>
     * The metadata options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user
     * data</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The metadata options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata
     *         and user data</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final LaunchTemplateInstanceMetadataOptionsRequest metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web Services Nitro
     * Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
     *         see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web
     *         Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
     *         <p>
     *         You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     */
    public final LaunchTemplateEnclaveOptionsRequest enclaveOptions() {
        return enclaveOptions;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with these attributes.
     * </p>
     * <p>
     * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>. All other attributes are optional. Any
     * unspecified optional attribute is set to its default.
     * </p>
     * <p>
     * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you
     * specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
     * </p>
     * <p>
     * To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can use one
     * of the following parameters, but not both in the same request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types are
     * ignored, even if they match your specified attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your
     * specified attributes.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
     * </p>
     * <p>
     * Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet, and Spot
     * Fleet to launch instances. If you plan to use the launch template in the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch instance
     * wizard</a>, or with the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> API or <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::
     * Instance</a> Amazon Web Services CloudFormation resource, you can't specify <code>InstanceRequirements</code>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html"
     * >Specify attributes for instance type selection for EC2 Fleet or Spot Fleet</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with these attributes.</p>
     *         <p>
     *         You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>. All other attributes are optional.
     *         Any unspecified optional attribute is set to its default.
     *         </p>
     *         <p>
     *         When you specify multiple attributes, you get instance types that satisfy all of the specified
     *         attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of
     *         the specified values.
     *         </p>
     *         <p>
     *         To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can
     *         use one of the following parameters, but not both in the same request:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types
     *         are ignored, even if they match your specified attributes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your
     *         specified attributes.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
     *         </p>
     *         <p>
     *         Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet, and
     *         Spot Fleet to launch instances. If you plan to use the launch template in the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch
     *         instance wizard</a>, or with the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> API
     *         or <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html"
     *         >AWS::EC2::Instance</a> Amazon Web Services CloudFormation resource, you can't specify
     *         <code>InstanceRequirements</code>.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html"
     *         >Specify attributes for instance type selection for EC2 Fleet or Spot Fleet</a> and <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement
     *         score</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final InstanceRequirementsRequest instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The options for the instance hostname. The default values are inherited from the subnet.
     * </p>
     * 
     * @return The options for the instance hostname. The default values are inherited from the subnet.
     */
    public final LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions() {
        return privateDnsNameOptions;
    }

    /**
     * <p>
     * The maintenance options for the instance.
     * </p>
     * 
     * @return The maintenance options for the instance.
     */
    public final LaunchTemplateInstanceMaintenanceOptionsRequest maintenanceOptions() {
        return maintenanceOptions;
    }

    /**
     * <p>
     * Indicates whether to enable the instance for stop protection. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop protection for
     * your instance</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to enable the instance for stop protection. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop
     *         protection for your instance</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean disableApiStop() {
        return disableApiStop;
    }

    /**
     * <p>
     * The entity that manages the launch template.
     * </p>
     * 
     * @return The entity that manages the launch template.
     */
    public final OperatorRequest operator() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuSpecifications() ? elasticGpuSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestLaunchTemplateData)) {
            return false;
        }
        RequestLaunchTemplateData other = (RequestLaunchTemplateData) obj;
        return Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramDiskId(), other.ramDiskId())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString())
                && Objects.equals(userData(), other.userData()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && hasElasticGpuSpecifications() == other.hasElasticGpuSpecifications()
                && Objects.equals(elasticGpuSpecifications(), other.elasticGpuSpecifications())
                && hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators()
                && Objects.equals(elasticInferenceAccelerators(), other.elasticInferenceAccelerators())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(metadataOptions(), other.metadataOptions())
                && Objects.equals(enclaveOptions(), other.enclaveOptions())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(privateDnsNameOptions(), other.privateDnsNameOptions())
                && Objects.equals(maintenanceOptions(), other.maintenanceOptions())
                && Objects.equals(disableApiStop(), other.disableApiStop()) && Objects.equals(operator(), other.operator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestLaunchTemplateData").add("KernelId", kernelId()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("KeyName", keyName()).add("Monitoring", monitoring())
                .add("Placement", placement()).add("RamDiskId", ramDiskId())
                .add("DisableApiTermination", disableApiTermination())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehaviorAsString())
                .add("UserData", userData() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("ElasticGpuSpecifications", hasElasticGpuSpecifications() ? elasticGpuSpecifications() : null)
                .add("ElasticInferenceAccelerators", hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("InstanceMarketOptions", instanceMarketOptions()).add("CreditSpecification", creditSpecification())
                .add("CpuOptions", cpuOptions()).add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("HibernationOptions", hibernationOptions()).add("MetadataOptions", metadataOptions())
                .add("EnclaveOptions", enclaveOptions()).add("InstanceRequirements", instanceRequirements())
                .add("PrivateDnsNameOptions", privateDnsNameOptions()).add("MaintenanceOptions", maintenanceOptions())
                .add("DisableApiStop", disableApiStop()).add("Operator", operator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamDiskId":
            return Optional.ofNullable(clazz.cast(ramDiskId()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehaviorAsString()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ElasticGpuSpecifications":
            return Optional.ofNullable(clazz.cast(elasticGpuSpecifications()));
        case "ElasticInferenceAccelerators":
            return Optional.ofNullable(clazz.cast(elasticInferenceAccelerators()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "PrivateDnsNameOptions":
            return Optional.ofNullable(clazz.cast(privateDnsNameOptions()));
        case "MaintenanceOptions":
            return Optional.ofNullable(clazz.cast(maintenanceOptions()));
        case "DisableApiStop":
            return Optional.ofNullable(clazz.cast(disableApiStop()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestLaunchTemplateData, T> g) {
        return obj -> g.apply((RequestLaunchTemplateData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestLaunchTemplateData> {
        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kernelId
         *        The ID of the kernel.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided
         *        kernels</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an
         * EBS-optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
         *        performance. This optimization isn't available with all instance types. Additional usage charges apply
         *        when using an EBS-optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder} avoiding the need to create one manually
         * via {@link LaunchTemplateIamInstanceProfileSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on
         *        {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest)
         */
        default Builder iamInstanceProfile(
                Consumer<LaunchTemplateIamInstanceProfileSpecificationRequest.Builder> iamInstanceProfile) {
            return iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest.builder()
                    .applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The block device mapping.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<LaunchTemplateBlockDeviceMappingRequest>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<LaunchTemplateBlockDeviceMappingRequest>)
         */
        Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest... networkInterfaces);

        /**
         * <p>
         * The network interfaces for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #networkInterfaces(List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>)
         */
        Builder networkInterfaces(
                Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder>... networkInterfaces);

        /**
         * <p>
         * The ID of the AMI in the format <code>ami-0ac394d6a3example</code>.
         * </p>
         * <p>
         * Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The Systems
         * Manager parameter will resolve to an AMI ID on launch.
         * </p>
         * <p>
         * To reference a public parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>public-parameter</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To reference a parameter stored in the same account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name:label</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To reference a parameter shared from another Amazon Web Services account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
         * >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <note>
         * <p>
         * If the launch template will be used for an EC2 Fleet or Spot Fleet, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Only EC2 Fleets of type <code>instant</code> support specifying a Systems Manager parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * For EC2 Fleets of type <code>maintain</code> or <code>request</code>, or for Spot Fleets, you must specify
         * the AMI ID.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param imageId
         *        The ID of the AMI in the format <code>ami-0ac394d6a3example</code>.</p>
         *        <p>
         *        Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The
         *        Systems Manager parameter will resolve to an AMI ID on launch.
         *        </p>
         *        <p>
         *        To reference a public parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>public-parameter</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To reference a parameter stored in the same account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name:label</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To reference a parameter shared from another Amazon Web Services account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
         *        >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        If the launch template will be used for an EC2 Fleet or Spot Fleet, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Only EC2 Fleets of type <code>instant</code> support specifying a Systems Manager parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For EC2 Fleets of type <code>maintain</code> or <code>request</code>, or for Spot Fleets, you must
         *        specify the AMI ID.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance types</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance
         *        types</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance types</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Amazon EC2 instance
         *        types</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The name of the key pair. You can create a key pair using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
         * </p>
         * <important>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         * configured to allow users another way to log in.
         * </p>
         * </important>
         * 
         * @param keyName
         *        The name of the key pair. You can create a key pair using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a>
         *        or <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair
         *        </a>.</p> <important>
         *        <p>
         *        If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         *        configured to allow users another way to log in.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(LaunchTemplatesMonitoringRequest monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplatesMonitoringRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplatesMonitoringRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplatesMonitoringRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(LaunchTemplatesMonitoringRequest)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link LaunchTemplatesMonitoringRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(LaunchTemplatesMonitoringRequest)
         */
        default Builder monitoring(Consumer<LaunchTemplatesMonitoringRequest.Builder> monitoring) {
            return monitoring(LaunchTemplatesMonitoringRequest.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * 
         * @param placement
         *        The placement for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(LaunchTemplatePlacementRequest placement);

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplatePlacementRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplatePlacementRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplatePlacementRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #placement(LaunchTemplatePlacementRequest)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link LaunchTemplatePlacementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(LaunchTemplatePlacementRequest)
         */
        default Builder placement(Consumer<LaunchTemplatePlacementRequest.Builder> placement) {
            return placement(LaunchTemplatePlacementRequest.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided kernels</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param ramDiskId
         *        The ID of the RAM disk.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User provided
         *        kernels</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramDiskId(String ramDiskId);

        /**
         * <p>
         * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         * console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
         * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
         * </p>
         * 
         * @param disableApiTermination
         *        If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         *        console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         *        >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code>
         *        to <code>terminate</code>, you can terminate the instance by running the shutdown command from the
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The user data to make available to the instance. You must provide base64-encoded text. User data is limited
         * to 16 KB. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Amazon EC2
         * instance at launch</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * If you are creating the launch template for use with Batch, the user data must be provided in the <a
         * href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME multi-part
         * archive format</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data in
         * launch templates</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance. You must provide base64-encoded text. User data is
         *        limited to 16 KB. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run commands on your Amazon
         *        EC2 instance at launch</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        If you are creating the launch template for use with Batch, the user data must be provided in the <a
         *        href="https://cloudinit.readthedocs.io/en/latest/topics/format.html#mime-multi-part-archive">MIME
         *        multi-part archive format</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Amazon EC2 user data
         *        in launch templates</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The tags to apply to the resources that are created during instance launch. These tags are not applied to the
         * launch template.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources that are created during instance launch. These tags are not applied
         *        to the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources that are created during instance launch. These tags are not applied to the
         * launch template.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources that are created during instance launch. These tags are not applied
         *        to the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(LaunchTemplateTagSpecificationRequest... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources that are created during instance launch. These tags are not applied to the
         * launch template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #tagSpecifications(List<LaunchTemplateTagSpecificationRequest>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<LaunchTemplateTagSpecificationRequest>)
         */
        Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder>... tagSpecifications);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
         * acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
         * </p>
         * </note>
         * 
         * @param elasticGpuSpecifications
         *        Deprecated.</p> <note>
         *        <p>
         *        Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
         *        acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
         * acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
         * </p>
         * </note>
         * 
         * @param elasticGpuSpecifications
         *        Deprecated.</p> <note>
         *        <p>
         *        Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
         *        acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(ElasticGpuSpecification... elasticGpuSpecifications);

        /**
         * <p>
         * Deprecated.
         * </p>
         * <note>
         * <p>
         * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics
         * acceleration, we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticGpuSpecifications(List<ElasticGpuSpecification>)}.
         * 
         * @param elasticGpuSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuSpecifications(java.util.Collection<ElasticGpuSpecification>)
         */
        Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecifications);

        /**
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note>
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * <note>
         * <p>
         * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI),
         * and will help current customers migrate their workloads to options that offer better price and performance.
         * After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in
         * Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during
         * the past 30-day period are considered current customers and will be able to continue using the service.
         * </p>
         * </note>
         * 
         * @param elasticInferenceAccelerators
         *        <p>
         *        Amazon Elastic Inference is no longer available.
         *        </p>
         *        </note>
         *        <p>
         *        An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         *        resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         *        workloads.
         *        </p>
         *        <p>
         *        You cannot specify accelerators from different generations in the same request.
         *        </p>
         *        <note>
         *        <p>
         *        Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic
         *        Inference (EI), and will help current customers migrate their workloads to options that offer better
         *        price and performance. After April 15, 2023, new customers will not be able to launch instances with
         *        Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have
         *        used Amazon EI at least once during the past 30-day period are considered current customers and will
         *        be able to continue using the service.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators);

        /**
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note>
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * <note>
         * <p>
         * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI),
         * and will help current customers migrate their workloads to options that offer better price and performance.
         * After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in
         * Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during
         * the past 30-day period are considered current customers and will be able to continue using the service.
         * </p>
         * </note>
         * 
         * @param elasticInferenceAccelerators
         *        <p>
         *        Amazon Elastic Inference is no longer available.
         *        </p>
         *        </note>
         *        <p>
         *        An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         *        resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         *        workloads.
         *        </p>
         *        <p>
         *        You cannot specify accelerators from different generations in the same request.
         *        </p>
         *        <note>
         *        <p>
         *        Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic
         *        Inference (EI), and will help current customers migrate their workloads to options that offer better
         *        price and performance. After April 15, 2023, new customers will not be able to launch instances with
         *        Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have
         *        used Amazon EI at least once during the past 30-day period are considered current customers and will
         *        be able to continue using the service.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator... elasticInferenceAccelerators);

        /**
         * <note>
         * <p>
         * Amazon Elastic Inference is no longer available.
         * </p>
         * </note>
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * <note>
         * <p>
         * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI),
         * and will help current customers migrate their workloads to options that offer better price and performance.
         * After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in
         * Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during
         * the past 30-day period are considered current customers and will be able to continue using the service.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elasticInferenceAccelerators(List<LaunchTemplateElasticInferenceAccelerator>)}.
         * 
         * @param elasticInferenceAccelerators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAccelerators(java.util.Collection<LaunchTemplateElasticInferenceAccelerator>)
         */
        Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface
         * instead of using this parameter.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface instead of using this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface
         * instead of using this parameter.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface instead of using this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The names of the security groups. For a nondefault VPC, you must use security group IDs instead.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface
         * instead of using this parameter.
         * </p>
         * 
         * @param securityGroups
         *        The names of the security groups. For a nondefault VPC, you must use security group IDs instead.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface instead of using this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The names of the security groups. For a nondefault VPC, you must use security group IDs instead.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface
         * instead of using this parameter.
         * </p>
         * 
         * @param securityGroups
         *        The names of the security groups. For a nondefault VPC, you must use security group IDs instead.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface instead of using this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * 
         * @param instanceMarketOptions
         *        The market (purchasing) option for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateInstanceMarketOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateInstanceMarketOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMarketOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMarketOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest)
         */
        default Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.builder()
                    .applyMutation(instanceMarketOptions).build());
        }

        /**
         * <p>
         * The credit option for CPU usage of the instance. Valid only for T instances.
         * </p>
         * 
         * @param creditSpecification
         *        The credit option for CPU usage of the instance. Valid only for T instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(CreditSpecificationRequest creditSpecification);

        /**
         * <p>
         * The credit option for CPU usage of the instance. Valid only for T instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreditSpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link CreditSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreditSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #creditSpecification(CreditSpecificationRequest)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on {@link CreditSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(CreditSpecificationRequest)
         */
        default Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return creditSpecification(CreditSpecificationRequest.builder().applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         * options</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         *        options</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions);

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         * options</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateCpuOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateCpuOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateCpuOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #cpuOptions(LaunchTemplateCpuOptionsRequest)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link LaunchTemplateCpuOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(LaunchTemplateCpuOptionsRequest)
         */
        default Builder cpuOptions(Consumer<LaunchTemplateCpuOptionsRequest.Builder> cpuOptions) {
            return cpuOptions(LaunchTemplateCpuOptionsRequest.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
         * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
         * Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * 
         * @param capacityReservationSpecification
         *        The Capacity Reservation targeting option. If you do not specify this parameter, the instance's
         *        Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open
         *        Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification);

        /**
         * <p>
         * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
         * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
         * Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder} avoiding the need to create one
         * manually via {@link LaunchTemplateCapacityReservationSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on
         *        {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest)
         */
        default Builder capacityReservationSpecification(
                Consumer<LaunchTemplateCapacityReservationSpecificationRequest.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest... licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #licenseSpecifications(List<LaunchTemplateLicenseConfigurationRequest>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(java.util.Collection<LaunchTemplateLicenseConfigurationRequest>)
         */
        Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder>... licenseSpecifications);

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
         * prerequisites</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2
         * instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance
         *        meets the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
         *        prerequisites</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2
         *        instance</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions);

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
         * prerequisites</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2
         * instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateHibernationOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateHibernationOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateHibernationOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #hibernationOptions(LaunchTemplateHibernationOptionsRequest)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link LaunchTemplateHibernationOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(LaunchTemplateHibernationOptionsRequest)
         */
        default Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptionsRequest.Builder> hibernationOptions) {
            return hibernationOptions(LaunchTemplateHibernationOptionsRequest.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        metadata and user data</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest metadataOptions);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateInstanceMetadataOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest)
         */
        default Builder metadataOptions(Consumer<LaunchTemplateInstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see
         * <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web Services
         * Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
         * </p>
         * <p>
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * </p>
         * 
         * @param enclaveOptions
         *        Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more
         *        information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is
         *        Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User
         *        Guide</i>.</p>
         *        <p>
         *        You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(LaunchTemplateEnclaveOptionsRequest enclaveOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see
         * <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web Services
         * Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
         * </p>
         * <p>
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateEnclaveOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateEnclaveOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateEnclaveOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #enclaveOptions(LaunchTemplateEnclaveOptionsRequest)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link LaunchTemplateEnclaveOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(LaunchTemplateEnclaveOptionsRequest)
         */
        default Builder enclaveOptions(Consumer<LaunchTemplateEnclaveOptionsRequest.Builder> enclaveOptions) {
            return enclaveOptions(LaunchTemplateEnclaveOptionsRequest.builder().applyMutation(enclaveOptions).build());
        }

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with these attributes.
         * </p>
         * <p>
         * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>. All other attributes are optional. Any
         * unspecified optional attribute is set to its default.
         * </p>
         * <p>
         * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If
         * you specify multiple values for an attribute, you get instance types that satisfy any of the specified
         * values.
         * </p>
         * <p>
         * To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can use
         * one of the following parameters, but not both in the same request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types are
         * ignored, even if they match your specified attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your
         * specified attributes.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         * </p>
         * <p>
         * Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet, and Spot
         * Fleet to launch instances. If you plan to use the launch template in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch instance
         * wizard</a>, or with the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> API or
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS
         * ::EC2::Instance</a> Amazon Web Services CloudFormation resource, you can't specify
         * <code>InstanceRequirements</code>.
         * </p>
         * </note>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html"
         * >Specify attributes for instance type selection for EC2 Fleet or Spot Fleet</a> and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceRequirements
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with these attributes.</p>
         *        <p>
         *        You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>. All other attributes are optional.
         *        Any unspecified optional attribute is set to its default.
         *        </p>
         *        <p>
         *        When you specify multiple attributes, you get instance types that satisfy all of the specified
         *        attributes. If you specify multiple values for an attribute, you get instance types that satisfy any
         *        of the specified values.
         *        </p>
         *        <p>
         *        To limit the list of instance types from which Amazon EC2 can identify matching instance types, you
         *        can use one of the following parameters, but not both in the same request:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance
         *        types are ignored, even if they match your specified attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match
         *        your specified attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         *        </p>
         *        <p>
         *        Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet,
         *        and Spot Fleet to launch instances. If you plan to use the launch template in the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch
         *        instance wizard</a>, or with the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>
         *        API or <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html"
         *        >AWS::EC2::Instance</a> Amazon Web Services CloudFormation resource, you can't specify
         *        <code>InstanceRequirements</code>.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html"
         *        >Specify attributes for instance type selection for EC2 Fleet or Spot Fleet</a> and <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement
         *        score</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with these attributes.
         * </p>
         * <p>
         * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code>. All other attributes are optional. Any
         * unspecified optional attribute is set to its default.
         * </p>
         * <p>
         * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If
         * you specify multiple values for an attribute, you get instance types that satisfy any of the specified
         * values.
         * </p>
         * <p>
         * To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can use
         * one of the following parameters, but not both in the same request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types are
         * ignored, even if they match your specified attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your
         * specified attributes.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         * </p>
         * <p>
         * Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet, and Spot
         * Fleet to launch instances. If you plan to use the launch template in the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch instance
         * wizard</a>, or with the <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> API or
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS
         * ::EC2::Instance</a> Amazon Web Services CloudFormation resource, you can't specify
         * <code>InstanceRequirements</code>.
         * </p>
         * </note>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html"
         * >Specify attributes for instance type selection for EC2 Fleet or Spot Fleet</a> and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRequirementsRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceRequirementsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirementsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceRequirements(InstanceRequirementsRequest)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirementsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirementsRequest)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirementsRequest.builder().applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The options for the instance hostname. The default values are inherited from the subnet.
         * </p>
         * 
         * @param privateDnsNameOptions
         *        The options for the instance hostname. The default values are inherited from the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions);

        /**
         * <p>
         * The options for the instance hostname. The default values are inherited from the subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplatePrivateDnsNameOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplatePrivateDnsNameOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplatePrivateDnsNameOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest)}.
         * 
         * @param privateDnsNameOptions
         *        a consumer that will call methods on {@link LaunchTemplatePrivateDnsNameOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest)
         */
        default Builder privateDnsNameOptions(Consumer<LaunchTemplatePrivateDnsNameOptionsRequest.Builder> privateDnsNameOptions) {
            return privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest.builder()
                    .applyMutation(privateDnsNameOptions).build());
        }

        /**
         * <p>
         * The maintenance options for the instance.
         * </p>
         * 
         * @param maintenanceOptions
         *        The maintenance options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest maintenanceOptions);

        /**
         * <p>
         * The maintenance options for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LaunchTemplateInstanceMaintenanceOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateInstanceMaintenanceOptionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMaintenanceOptionsRequest.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #maintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest)}.
         * 
         * @param maintenanceOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMaintenanceOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest)
         */
        default Builder maintenanceOptions(Consumer<LaunchTemplateInstanceMaintenanceOptionsRequest.Builder> maintenanceOptions) {
            return maintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest.builder().applyMutation(maintenanceOptions)
                    .build());
        }

        /**
         * <p>
         * Indicates whether to enable the instance for stop protection. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop protection
         * for your instance</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param disableApiStop
         *        Indicates whether to enable the instance for stop protection. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html">Enable stop
         *        protection for your instance</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiStop(Boolean disableApiStop);

        /**
         * <p>
         * The entity that manages the launch template.
         * </p>
         * 
         * @param operator
         *        The entity that manages the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorRequest operator);

        /**
         * <p>
         * The entity that manages the launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorRequest.Builder} avoiding the
         * need to create one manually via {@link OperatorRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorRequest)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorRequest)
         */
        default Builder operator(Consumer<OperatorRequest.Builder> operator) {
            return operator(OperatorRequest.builder().applyMutation(operator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kernelId;

        private Boolean ebsOptimized;

        private LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;

        private List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces = DefaultSdkAutoConstructList
                .getInstance();

        private String imageId;

        private String instanceType;

        private String keyName;

        private LaunchTemplatesMonitoringRequest monitoring;

        private LaunchTemplatePlacementRequest placement;

        private String ramDiskId;

        private Boolean disableApiTermination;

        private String instanceInitiatedShutdownBehavior;

        private String userData;

        private List<LaunchTemplateTagSpecificationRequest> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticGpuSpecification> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList
                .getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;

        private CreditSpecificationRequest creditSpecification;

        private LaunchTemplateCpuOptionsRequest cpuOptions;

        private LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;

        private List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateHibernationOptionsRequest hibernationOptions;

        private LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;

        private LaunchTemplateEnclaveOptionsRequest enclaveOptions;

        private InstanceRequirementsRequest instanceRequirements;

        private LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions;

        private LaunchTemplateInstanceMaintenanceOptionsRequest maintenanceOptions;

        private Boolean disableApiStop;

        private OperatorRequest operator;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestLaunchTemplateData model) {
            kernelId(model.kernelId);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            blockDeviceMappings(model.blockDeviceMappings);
            networkInterfaces(model.networkInterfaces);
            imageId(model.imageId);
            instanceType(model.instanceType);
            keyName(model.keyName);
            monitoring(model.monitoring);
            placement(model.placement);
            ramDiskId(model.ramDiskId);
            disableApiTermination(model.disableApiTermination);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            userData(model.userData);
            tagSpecifications(model.tagSpecifications);
            elasticGpuSpecifications(model.elasticGpuSpecifications);
            elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            instanceMarketOptions(model.instanceMarketOptions);
            creditSpecification(model.creditSpecification);
            cpuOptions(model.cpuOptions);
            capacityReservationSpecification(model.capacityReservationSpecification);
            licenseSpecifications(model.licenseSpecifications);
            hibernationOptions(model.hibernationOptions);
            metadataOptions(model.metadataOptions);
            enclaveOptions(model.enclaveOptions);
            instanceRequirements(model.instanceRequirements);
            privateDnsNameOptions(model.privateDnsNameOptions);
            maintenanceOptions(model.maintenanceOptions);
            disableApiStop(model.disableApiStop);
            operator(model.operator);
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final LaunchTemplateIamInstanceProfileSpecificationRequest.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(
                LaunchTemplateIamInstanceProfileSpecificationRequest.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final List<LaunchTemplateBlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            List<LaunchTemplateBlockDeviceMappingRequest.Builder> result = LaunchTemplateBlockDeviceMappingRequestListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(
                Collection<LaunchTemplateBlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> LaunchTemplateBlockDeviceMappingRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> getNetworkInterfaces() {
            List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> result = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(
                Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier
                    .copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(
                Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(
                Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final LaunchTemplatesMonitoringRequest.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(LaunchTemplatesMonitoringRequest.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoringRequest monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final LaunchTemplatePlacementRequest.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(LaunchTemplatePlacementRequest.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacementRequest placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamDiskId() {
            return ramDiskId;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null
                    : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final List<LaunchTemplateTagSpecificationRequest.Builder> getTagSpecifications() {
            List<LaunchTemplateTagSpecificationRequest.Builder> result = LaunchTemplateTagSpecificationRequestListCopier
                    .copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecificationRequest... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications)
                    .map(c -> LaunchTemplateTagSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticGpuSpecification.Builder> getElasticGpuSpecifications() {
            List<ElasticGpuSpecification.Builder> result = ElasticGpuSpecificationListCopier
                    .copyToBuilder(this.elasticGpuSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecification... elasticGpuSpecifications) {
            elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecifications) {
            elasticGpuSpecifications(Stream.of(elasticGpuSpecifications)
                    .map(c -> ElasticGpuSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchTemplateElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            List<LaunchTemplateElasticInferenceAccelerator.Builder> result = LaunchTemplateElasticInferenceAcceleratorListCopier
                    .copyToBuilder(this.elasticInferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier
                    .copyFromBuilder(elasticInferenceAccelerators);
        }

        @Override
        public final Builder elasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier
                    .copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                LaunchTemplateElasticInferenceAccelerator... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators)
                    .map(c -> LaunchTemplateElasticInferenceAccelerator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final LaunchTemplateInstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final LaunchTemplateCpuOptionsRequest.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final LaunchTemplateCapacityReservationSpecificationRequest.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final List<LaunchTemplateLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LaunchTemplateLicenseConfigurationRequest.Builder> result = LaunchTemplateLicenseSpecificationListRequestCopier
                    .copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(
                Collection<LaunchTemplateLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier
                    .copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(
                Consumer<LaunchTemplateLicenseConfigurationRequest.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LaunchTemplateLicenseConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LaunchTemplateHibernationOptionsRequest.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final LaunchTemplateInstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(LaunchTemplateInstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final LaunchTemplateEnclaveOptionsRequest.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(LaunchTemplateEnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(LaunchTemplateEnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final LaunchTemplatePrivateDnsNameOptionsRequest.Builder getPrivateDnsNameOptions() {
            return privateDnsNameOptions != null ? privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final LaunchTemplateInstanceMaintenanceOptionsRequest.Builder getMaintenanceOptions() {
            return maintenanceOptions != null ? maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(LaunchTemplateInstanceMaintenanceOptionsRequest maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final OperatorRequest.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorRequest.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorRequest operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public RequestLaunchTemplateData build() {
            return new RequestLaunchTemplateData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
