/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes prefixes for Amazon Web Services services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefixList implements SdkPojo, Serializable, ToCopyableBuilder<PrefixList.Builder, PrefixList> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cidrs")
            .getter(getter(PrefixList::cidrs))
            .setter(setter(Builder::cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrSet")
                    .unmarshallLocationName("cidrSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(PrefixList::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListName")
            .getter(getter(PrefixList::prefixListName))
            .setter(setter(Builder::prefixListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName")
                    .unmarshallLocationName("prefixListName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD,
            PREFIX_LIST_ID_FIELD, PREFIX_LIST_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CidrSet", CIDRS_FIELD);
                    put("PrefixListId", PREFIX_LIST_ID_FIELD);
                    put("PrefixListName", PREFIX_LIST_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> cidrs;

    private final String prefixListId;

    private final String prefixListName;

    private PrefixList(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
        this.prefixListId = builder.prefixListId;
        this.prefixListName = builder.prefixListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cidrs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCidrs() {
        return cidrs != null && !(cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address range of the Amazon Web Services service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrs} method.
     * </p>
     * 
     * @return The IP address range of the Amazon Web Services service.
     */
    public final List<String> cidrs() {
        return cidrs;
    }

    /**
     * <p>
     * The ID of the prefix.
     * </p>
     * 
     * @return The ID of the prefix.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The name of the prefix.
     * </p>
     * 
     * @return The name of the prefix.
     */
    public final String prefixListName() {
        return prefixListName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrs() ? cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixList)) {
            return false;
        }
        PrefixList other = (PrefixList) obj;
        return hasCidrs() == other.hasCidrs() && Objects.equals(cidrs(), other.cidrs())
                && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(prefixListName(), other.prefixListName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefixList").add("Cidrs", hasCidrs() ? cidrs() : null).add("PrefixListId", prefixListId())
                .add("PrefixListName", prefixListName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidrs":
            return Optional.ofNullable(clazz.cast(cidrs()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "PrefixListName":
            return Optional.ofNullable(clazz.cast(prefixListName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrefixList, T> g) {
        return obj -> g.apply((PrefixList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefixList> {
        /**
         * <p>
         * The IP address range of the Amazon Web Services service.
         * </p>
         * 
         * @param cidrs
         *        The IP address range of the Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * The IP address range of the Amazon Web Services service.
         * </p>
         * 
         * @param cidrs
         *        The IP address range of the Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);

        /**
         * <p>
         * The ID of the prefix.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The name of the prefix.
         * </p>
         * 
         * @param prefixListName
         *        The name of the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private String prefixListId;

        private String prefixListName;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixList model) {
            cidrs(model.cidrs);
            prefixListId(model.prefixListId);
            prefixListName(model.prefixListName);
        }

        public final Collection<String> getCidrs() {
            if (cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        @Override
        public PrefixList build() {
            return new PrefixList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
