/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySnapshotTierResponse extends Ec2Response implements
        ToCopyableBuilder<ModifySnapshotTierResponse.Builder, ModifySnapshotTierResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(ModifySnapshotTierResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Instant> TIERING_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TieringStartTime")
            .getter(getter(ModifySnapshotTierResponse::tieringStartTime))
            .setter(setter(Builder::tieringStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringStartTime")
                    .unmarshallLocationName("tieringStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            TIERING_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SnapshotId", SNAPSHOT_ID_FIELD);
                    put("TieringStartTime", TIERING_START_TIME_FIELD);
                }
            });

    private final String snapshotId;

    private final Instant tieringStartTime;

    private ModifySnapshotTierResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.tieringStartTime = builder.tieringStartTime;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The date and time when the archive process was started.
     * </p>
     * 
     * @return The date and time when the archive process was started.
     */
    public final Instant tieringStartTime() {
        return tieringStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(tieringStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotTierResponse)) {
            return false;
        }
        ModifySnapshotTierResponse other = (ModifySnapshotTierResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(tieringStartTime(), other.tieringStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySnapshotTierResponse").add("SnapshotId", snapshotId())
                .add("TieringStartTime", tieringStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "TieringStartTime":
            return Optional.ofNullable(clazz.cast(tieringStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotTierResponse, T> g) {
        return obj -> g.apply((ModifySnapshotTierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifySnapshotTierResponse> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The date and time when the archive process was started.
         * </p>
         * 
         * @param tieringStartTime
         *        The date and time when the archive process was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringStartTime(Instant tieringStartTime);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String snapshotId;

        private Instant tieringStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotTierResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            tieringStartTime(model.tieringStartTime);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getTieringStartTime() {
            return tieringStartTime;
        }

        public final void setTieringStartTime(Instant tieringStartTime) {
            this.tieringStartTime = tieringStartTime;
        }

        @Override
        public final Builder tieringStartTime(Instant tieringStartTime) {
            this.tieringStartTime = tieringStartTime;
            return this;
        }

        @Override
        public ModifySnapshotTierResponse build() {
            return new ModifySnapshotTierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
