/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportInstanceRequest extends Ec2Request implements
        ToCopyableBuilder<ImportInstanceRequest.Builder, ImportInstanceRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ImportInstanceRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportInstanceRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<ImportInstanceLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField
            .<ImportInstanceLaunchSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchSpecification")
            .getter(getter(ImportInstanceRequest::launchSpecification))
            .setter(setter(Builder::launchSpecification))
            .constructor(ImportInstanceLaunchSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification")
                    .unmarshallLocationName("launchSpecification").build()).build();

    private static final SdkField<List<DiskImage>> DISK_IMAGES_FIELD = SdkField
            .<List<DiskImage>> builder(MarshallingType.LIST)
            .memberName("DiskImages")
            .getter(getter(ImportInstanceRequest::diskImages))
            .setter(setter(Builder::diskImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImage")
                    .unmarshallLocationName("diskImage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DiskImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiskImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ImportInstanceRequest::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            DESCRIPTION_FIELD, LAUNCH_SPECIFICATION_FIELD, DISK_IMAGES_FIELD, PLATFORM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("LaunchSpecification", LAUNCH_SPECIFICATION_FIELD);
                    put("DiskImage", DISK_IMAGES_FIELD);
                    put("Platform", PLATFORM_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String description;

    private final ImportInstanceLaunchSpecification launchSpecification;

    private final List<DiskImage> diskImages;

    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.description = builder.description;
        this.launchSpecification = builder.launchSpecification;
        this.diskImages = builder.diskImages;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A description for the instance being imported.
     * </p>
     * 
     * @return A description for the instance being imported.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The launch specification.
     * </p>
     * 
     * @return The launch specification.
     */
    public final ImportInstanceLaunchSpecification launchSpecification() {
        return launchSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the DiskImages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDiskImages() {
        return diskImages != null && !(diskImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The disk image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDiskImages} method.
     * </p>
     * 
     * @return The disk image.
     */
    public final List<DiskImage> diskImages() {
        return diskImages;
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public final PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public final String platformAsString() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskImages() ? diskImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(description(), other.description())
                && Objects.equals(launchSpecification(), other.launchSpecification()) && hasDiskImages() == other.hasDiskImages()
                && Objects.equals(diskImages(), other.diskImages())
                && Objects.equals(platformAsString(), other.platformAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportInstanceRequest").add("DryRun", dryRun()).add("Description", description())
                .add("LaunchSpecification", launchSpecification()).add("DiskImages", hasDiskImages() ? diskImages() : null)
                .add("Platform", platformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LaunchSpecification":
            return Optional.ofNullable(clazz.cast(launchSpecification()));
        case "DiskImages":
            return Optional.ofNullable(clazz.cast(diskImages()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceRequest, T> g) {
        return obj -> g.apply((ImportInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportInstanceRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A description for the instance being imported.
         * </p>
         * 
         * @param description
         *        A description for the instance being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The launch specification.
         * </p>
         * 
         * @param launchSpecification
         *        The launch specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification);

        /**
         * <p>
         * The launch specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportInstanceLaunchSpecification.Builder} avoiding the need to create one manually via
         * {@link ImportInstanceLaunchSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportInstanceLaunchSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchSpecification(ImportInstanceLaunchSpecification)}.
         * 
         * @param launchSpecification
         *        a consumer that will call methods on {@link ImportInstanceLaunchSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecification(ImportInstanceLaunchSpecification)
         */
        default Builder launchSpecification(Consumer<ImportInstanceLaunchSpecification.Builder> launchSpecification) {
            return launchSpecification(ImportInstanceLaunchSpecification.builder().applyMutation(launchSpecification).build());
        }

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param diskImages
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImages(Collection<DiskImage> diskImages);

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param diskImages
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImages(DiskImage... diskImages);

        /**
         * <p>
         * The disk image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DiskImage.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.DiskImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DiskImage.Builder#build()} is called immediately and its
         * result is passed to {@link #diskImages(List<DiskImage>)}.
         * 
         * @param diskImages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DiskImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskImages(java.util.Collection<DiskImage>)
         */
        Builder diskImages(Consumer<DiskImage.Builder>... diskImages);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String description;

        private ImportInstanceLaunchSpecification launchSpecification;

        private List<DiskImage> diskImages = DefaultSdkAutoConstructList.getInstance();

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            super(model);
            dryRun(model.dryRun);
            description(model.description);
            launchSpecification(model.launchSpecification);
            diskImages(model.diskImages);
            platform(model.platform);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ImportInstanceLaunchSpecification.Builder getLaunchSpecification() {
            return launchSpecification != null ? launchSpecification.toBuilder() : null;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final List<DiskImage.Builder> getDiskImages() {
            List<DiskImage.Builder> result = DiskImageListCopier.copyToBuilder(this.diskImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiskImages(Collection<DiskImage.BuilderImpl> diskImages) {
            this.diskImages = DiskImageListCopier.copyFromBuilder(diskImages);
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage... diskImages) {
            diskImages(Arrays.asList(diskImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(Consumer<DiskImage.Builder>... diskImages) {
            diskImages(Stream.of(diskImages).map(c -> DiskImage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
