/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSubnetCidrReservationsResponse extends Ec2Response implements
        ToCopyableBuilder<GetSubnetCidrReservationsResponse.Builder, GetSubnetCidrReservationsResponse> {
    private static final SdkField<List<SubnetCidrReservation>> SUBNET_IPV4_CIDR_RESERVATIONS_FIELD = SdkField
            .<List<SubnetCidrReservation>> builder(MarshallingType.LIST)
            .memberName("SubnetIpv4CidrReservations")
            .getter(getter(GetSubnetCidrReservationsResponse::subnetIpv4CidrReservations))
            .setter(setter(Builder::subnetIpv4CidrReservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIpv4CidrReservationSet")
                    .unmarshallLocationName("subnetIpv4CidrReservationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetCidrReservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetCidrReservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<SubnetCidrReservation>> SUBNET_IPV6_CIDR_RESERVATIONS_FIELD = SdkField
            .<List<SubnetCidrReservation>> builder(MarshallingType.LIST)
            .memberName("SubnetIpv6CidrReservations")
            .getter(getter(GetSubnetCidrReservationsResponse::subnetIpv6CidrReservations))
            .setter(setter(Builder::subnetIpv6CidrReservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIpv6CidrReservationSet")
                    .unmarshallLocationName("subnetIpv6CidrReservationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetCidrReservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetCidrReservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetSubnetCidrReservationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUBNET_IPV4_CIDR_RESERVATIONS_FIELD, SUBNET_IPV6_CIDR_RESERVATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SubnetIpv4CidrReservationSet", SUBNET_IPV4_CIDR_RESERVATIONS_FIELD);
                    put("SubnetIpv6CidrReservationSet", SUBNET_IPV6_CIDR_RESERVATIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<SubnetCidrReservation> subnetIpv4CidrReservations;

    private final List<SubnetCidrReservation> subnetIpv6CidrReservations;

    private final String nextToken;

    private GetSubnetCidrReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.subnetIpv4CidrReservations = builder.subnetIpv4CidrReservations;
        this.subnetIpv6CidrReservations = builder.subnetIpv6CidrReservations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIpv4CidrReservations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubnetIpv4CidrReservations() {
        return subnetIpv4CidrReservations != null && !(subnetIpv4CidrReservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 subnet CIDR reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIpv4CidrReservations} method.
     * </p>
     * 
     * @return Information about the IPv4 subnet CIDR reservations.
     */
    public final List<SubnetCidrReservation> subnetIpv4CidrReservations() {
        return subnetIpv4CidrReservations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIpv6CidrReservations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubnetIpv6CidrReservations() {
        return subnetIpv6CidrReservations != null && !(subnetIpv6CidrReservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 subnet CIDR reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIpv6CidrReservations} method.
     * </p>
     * 
     * @return Information about the IPv6 subnet CIDR reservations.
     */
    public final List<SubnetCidrReservation> subnetIpv6CidrReservations() {
        return subnetIpv6CidrReservations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIpv4CidrReservations() ? subnetIpv4CidrReservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIpv6CidrReservations() ? subnetIpv6CidrReservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubnetCidrReservationsResponse)) {
            return false;
        }
        GetSubnetCidrReservationsResponse other = (GetSubnetCidrReservationsResponse) obj;
        return hasSubnetIpv4CidrReservations() == other.hasSubnetIpv4CidrReservations()
                && Objects.equals(subnetIpv4CidrReservations(), other.subnetIpv4CidrReservations())
                && hasSubnetIpv6CidrReservations() == other.hasSubnetIpv6CidrReservations()
                && Objects.equals(subnetIpv6CidrReservations(), other.subnetIpv6CidrReservations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSubnetCidrReservationsResponse")
                .add("SubnetIpv4CidrReservations", hasSubnetIpv4CidrReservations() ? subnetIpv4CidrReservations() : null)
                .add("SubnetIpv6CidrReservations", hasSubnetIpv6CidrReservations() ? subnetIpv6CidrReservations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIpv4CidrReservations":
            return Optional.ofNullable(clazz.cast(subnetIpv4CidrReservations()));
        case "SubnetIpv6CidrReservations":
            return Optional.ofNullable(clazz.cast(subnetIpv6CidrReservations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSubnetCidrReservationsResponse, T> g) {
        return obj -> g.apply((GetSubnetCidrReservationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetSubnetCidrReservationsResponse> {
        /**
         * <p>
         * Information about the IPv4 subnet CIDR reservations.
         * </p>
         * 
         * @param subnetIpv4CidrReservations
         *        Information about the IPv4 subnet CIDR reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIpv4CidrReservations(Collection<SubnetCidrReservation> subnetIpv4CidrReservations);

        /**
         * <p>
         * Information about the IPv4 subnet CIDR reservations.
         * </p>
         * 
         * @param subnetIpv4CidrReservations
         *        Information about the IPv4 subnet CIDR reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIpv4CidrReservations(SubnetCidrReservation... subnetIpv4CidrReservations);

        /**
         * <p>
         * Information about the IPv4 subnet CIDR reservations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder#build()} is called immediately
         * and its result is passed to {@link #subnetIpv4CidrReservations(List<SubnetCidrReservation>)}.
         * 
         * @param subnetIpv4CidrReservations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetIpv4CidrReservations(java.util.Collection<SubnetCidrReservation>)
         */
        Builder subnetIpv4CidrReservations(Consumer<SubnetCidrReservation.Builder>... subnetIpv4CidrReservations);

        /**
         * <p>
         * Information about the IPv6 subnet CIDR reservations.
         * </p>
         * 
         * @param subnetIpv6CidrReservations
         *        Information about the IPv6 subnet CIDR reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIpv6CidrReservations(Collection<SubnetCidrReservation> subnetIpv6CidrReservations);

        /**
         * <p>
         * Information about the IPv6 subnet CIDR reservations.
         * </p>
         * 
         * @param subnetIpv6CidrReservations
         *        Information about the IPv6 subnet CIDR reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIpv6CidrReservations(SubnetCidrReservation... subnetIpv6CidrReservations);

        /**
         * <p>
         * Information about the IPv6 subnet CIDR reservations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder#build()} is called immediately
         * and its result is passed to {@link #subnetIpv6CidrReservations(List<SubnetCidrReservation>)}.
         * 
         * @param subnetIpv6CidrReservations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SubnetCidrReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetIpv6CidrReservations(java.util.Collection<SubnetCidrReservation>)
         */
        Builder subnetIpv6CidrReservations(Consumer<SubnetCidrReservation.Builder>... subnetIpv6CidrReservations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SubnetCidrReservation> subnetIpv4CidrReservations = DefaultSdkAutoConstructList.getInstance();

        private List<SubnetCidrReservation> subnetIpv6CidrReservations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubnetCidrReservationsResponse model) {
            super(model);
            subnetIpv4CidrReservations(model.subnetIpv4CidrReservations);
            subnetIpv6CidrReservations(model.subnetIpv6CidrReservations);
            nextToken(model.nextToken);
        }

        public final List<SubnetCidrReservation.Builder> getSubnetIpv4CidrReservations() {
            List<SubnetCidrReservation.Builder> result = SubnetCidrReservationListCopier
                    .copyToBuilder(this.subnetIpv4CidrReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetIpv4CidrReservations(Collection<SubnetCidrReservation.BuilderImpl> subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations = SubnetCidrReservationListCopier.copyFromBuilder(subnetIpv4CidrReservations);
        }

        @Override
        public final Builder subnetIpv4CidrReservations(Collection<SubnetCidrReservation> subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations = SubnetCidrReservationListCopier.copy(subnetIpv4CidrReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv4CidrReservations(SubnetCidrReservation... subnetIpv4CidrReservations) {
            subnetIpv4CidrReservations(Arrays.asList(subnetIpv4CidrReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv4CidrReservations(Consumer<SubnetCidrReservation.Builder>... subnetIpv4CidrReservations) {
            subnetIpv4CidrReservations(Stream.of(subnetIpv4CidrReservations)
                    .map(c -> SubnetCidrReservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubnetCidrReservation.Builder> getSubnetIpv6CidrReservations() {
            List<SubnetCidrReservation.Builder> result = SubnetCidrReservationListCopier
                    .copyToBuilder(this.subnetIpv6CidrReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetIpv6CidrReservations(Collection<SubnetCidrReservation.BuilderImpl> subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations = SubnetCidrReservationListCopier.copyFromBuilder(subnetIpv6CidrReservations);
        }

        @Override
        public final Builder subnetIpv6CidrReservations(Collection<SubnetCidrReservation> subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations = SubnetCidrReservationListCopier.copy(subnetIpv6CidrReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv6CidrReservations(SubnetCidrReservation... subnetIpv6CidrReservations) {
            subnetIpv6CidrReservations(Arrays.asList(subnetIpv6CidrReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv6CidrReservations(Consumer<SubnetCidrReservation.Builder>... subnetIpv6CidrReservations) {
            subnetIpv6CidrReservations(Stream.of(subnetIpv6CidrReservations)
                    .map(c -> SubnetCidrReservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSubnetCidrReservationsResponse build() {
            return new GetSubnetCidrReservationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
