/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociatedEnclaveCertificateIamRolesResponse extends Ec2Response
        implements
        ToCopyableBuilder<GetAssociatedEnclaveCertificateIamRolesResponse.Builder, GetAssociatedEnclaveCertificateIamRolesResponse> {
    private static final SdkField<List<AssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<AssociatedRole>> builder(MarshallingType.LIST)
            .memberName("AssociatedRoles")
            .getter(getter(GetAssociatedEnclaveCertificateIamRolesResponse::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoleSet")
                    .unmarshallLocationName("associatedRoleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AssociatedRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AssociatedRoleSet", ASSOCIATED_ROLES_FIELD);
                }
            });

    private final List<AssociatedRole> associatedRoles;

    private GetAssociatedEnclaveCertificateIamRolesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedRoles = builder.associatedRoles;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associated IAM roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedRoles} method.
     * </p>
     * 
     * @return Information about the associated IAM roles.
     */
    public final List<AssociatedRole> associatedRoles() {
        return associatedRoles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRoles() ? associatedRoles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedEnclaveCertificateIamRolesResponse)) {
            return false;
        }
        GetAssociatedEnclaveCertificateIamRolesResponse other = (GetAssociatedEnclaveCertificateIamRolesResponse) obj;
        return hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(associatedRoles(), other.associatedRoles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssociatedEnclaveCertificateIamRolesResponse")
                .add("AssociatedRoles", hasAssociatedRoles() ? associatedRoles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedEnclaveCertificateIamRolesResponse, T> g) {
        return obj -> g.apply((GetAssociatedEnclaveCertificateIamRolesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssociatedEnclaveCertificateIamRolesResponse> {
        /**
         * <p>
         * Information about the associated IAM roles.
         * </p>
         * 
         * @param associatedRoles
         *        Information about the associated IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<AssociatedRole> associatedRoles);

        /**
         * <p>
         * Information about the associated IAM roles.
         * </p>
         * 
         * @param associatedRoles
         *        Information about the associated IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(AssociatedRole... associatedRoles);

        /**
         * <p>
         * Information about the associated IAM roles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AssociatedRole.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AssociatedRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AssociatedRole.Builder#build()} is called immediately and
         * its result is passed to {@link #associatedRoles(List<AssociatedRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AssociatedRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(java.util.Collection<AssociatedRole>)
         */
        Builder associatedRoles(Consumer<AssociatedRole.Builder>... associatedRoles);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<AssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedEnclaveCertificateIamRolesResponse model) {
            super(model);
            associatedRoles(model.associatedRoles);
        }

        public final List<AssociatedRole.Builder> getAssociatedRoles() {
            List<AssociatedRole.Builder> result = AssociatedRolesListCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<AssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AssociatedRolesListCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<AssociatedRole> associatedRoles) {
            this.associatedRoles = AssociatedRolesListCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AssociatedRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AssociatedRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles).map(c -> AssociatedRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAssociatedEnclaveCertificateIamRolesResponse build() {
            return new GetAssociatedEnclaveCertificateIamRolesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
