/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointServicesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcEndpointServicesResponse.Builder, DescribeVpcEndpointServicesResponse> {
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ServiceNames")
            .getter(getter(DescribeVpcEndpointServicesResponse::serviceNames))
            .setter(setter(Builder::serviceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNameSet")
                    .unmarshallLocationName("serviceNameSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ServiceDetail>> SERVICE_DETAILS_FIELD = SdkField
            .<List<ServiceDetail>> builder(MarshallingType.LIST)
            .memberName("ServiceDetails")
            .getter(getter(DescribeVpcEndpointServicesResponse::serviceDetails))
            .setter(setter(Builder::serviceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDetailSet")
                    .unmarshallLocationName("serviceDetailSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ServiceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVpcEndpointServicesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMES_FIELD,
            SERVICE_DETAILS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ServiceNameSet", SERVICE_NAMES_FIELD);
                    put("ServiceDetailSet", SERVICE_DETAILS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> serviceNames;

    private final List<ServiceDetail> serviceDetails;

    private final String nextToken;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceNames = builder.serviceNames;
        this.serviceDetails = builder.serviceDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceNames() {
        return serviceNames != null && !(serviceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceNames} method.
     * </p>
     * 
     * @return The supported services.
     */
    public final List<String> serviceNames() {
        return serviceNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceDetails() {
        return serviceDetails != null && !(serviceDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceDetails} method.
     * </p>
     * 
     * @return Information about the service.
     */
    public final List<ServiceDetail> serviceDetails() {
        return serviceDetails;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceNames() ? serviceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceDetails() ? serviceDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse) obj;
        return hasServiceNames() == other.hasServiceNames() && Objects.equals(serviceNames(), other.serviceNames())
                && hasServiceDetails() == other.hasServiceDetails() && Objects.equals(serviceDetails(), other.serviceDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcEndpointServicesResponse")
                .add("ServiceNames", hasServiceNames() ? serviceNames() : null)
                .add("ServiceDetails", hasServiceDetails() ? serviceDetails() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNames":
            return Optional.ofNullable(clazz.cast(serviceNames()));
        case "ServiceDetails":
            return Optional.ofNullable(clazz.cast(serviceDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointServicesResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        /**
         * <p>
         * The supported services.
         * </p>
         * 
         * @param serviceNames
         *        The supported services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(Collection<String> serviceNames);

        /**
         * <p>
         * The supported services.
         * </p>
         * 
         * @param serviceNames
         *        The supported services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(String... serviceNames);

        /**
         * <p>
         * Information about the service.
         * </p>
         * 
         * @param serviceDetails
         *        Information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDetails(Collection<ServiceDetail> serviceDetails);

        /**
         * <p>
         * Information about the service.
         * </p>
         * 
         * @param serviceDetails
         *        Information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDetails(ServiceDetail... serviceDetails);

        /**
         * <p>
         * Information about the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ServiceDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ServiceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ServiceDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceDetails(List<ServiceDetail>)}.
         * 
         * @param serviceDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ServiceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDetails(java.util.Collection<ServiceDetail>)
         */
        Builder serviceDetails(Consumer<ServiceDetail.Builder>... serviceDetails);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceDetail> serviceDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            super(model);
            serviceNames(model.serviceNames);
            serviceDetails(model.serviceDetails);
            nextToken(model.nextToken);
        }

        public final Collection<String> getServiceNames() {
            if (serviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceNames;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String... serviceNames) {
            serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final List<ServiceDetail.Builder> getServiceDetails() {
            List<ServiceDetail.Builder> result = ServiceDetailSetCopier.copyToBuilder(this.serviceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDetails(Collection<ServiceDetail.BuilderImpl> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copyFromBuilder(serviceDetails);
        }

        @Override
        public final Builder serviceDetails(Collection<ServiceDetail> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copy(serviceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(ServiceDetail... serviceDetails) {
            serviceDetails(Arrays.asList(serviceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(Consumer<ServiceDetail.Builder>... serviceDetails) {
            serviceDetails(Stream.of(serviceDetails).map(c -> ServiceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
