/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumeStatusRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVolumeStatusRequest.Builder, DescribeVolumeStatusRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeVolumeStatusRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVolumeStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VolumeIds")
            .getter(getter(DescribeVolumeStatusRequest::volumeIds))
            .setter(setter(Builder::volumeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VolumeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VolumeId").unmarshallLocationName("VolumeId").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeVolumeStatusRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVolumeStatusRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, VOLUME_IDS_FIELD, DRY_RUN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("VolumeId", VOLUME_IDS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("Filter", FILTERS_FIELD);
                }
            });

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> volumeIds;

    private final Boolean dryRun;

    private final List<Filter> filters;

    private DescribeVolumeStatusRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.volumeIds = builder.volumeIds;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumeIds() {
        return volumeIds != null && !(volumeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the volumes.
     * </p>
     * <p>
     * Default: Describes all your volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeIds} method.
     * </p>
     * 
     * @return The IDs of the volumes.</p>
     *         <p>
     *         Default: Describes all your volumes.
     */
    public final List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.description</code> - A description of the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.event-id</code> - The event ID associated with the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.description</code> - A description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-id</code> - The event ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-after</code> - The latest end time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-before</code> - The earliest start time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     * <code>io-enabled</code> | <code>io-performance</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     * <code>warning</code> | <code>insufficient-data</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.description</code> - A description of the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.event-id</code> - The event ID associated with the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.description</code> - A description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-id</code> - The event ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     *         <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     *         <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-after</code> - The latest end time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-before</code> - The earliest start time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     *         <code>io-enabled</code> | <code>io-performance</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     *         <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     *         <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     *         <code>warning</code> | <code>insufficient-data</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeIds() ? volumeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusRequest)) {
            return false;
        }
        DescribeVolumeStatusRequest other = (DescribeVolumeStatusRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasVolumeIds() == other.hasVolumeIds() && Objects.equals(volumeIds(), other.volumeIds())
                && Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVolumeStatusRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("VolumeIds", hasVolumeIds() ? volumeIds() : null).add("DryRun", dryRun())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VolumeIds":
            return Optional.ofNullable(clazz.cast(volumeIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumeStatusRequest, T> g) {
        return obj -> g.apply((DescribeVolumeStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumeStatusRequest> {
        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            volumeIds(model.volumeIds);
            dryRun(model.dryRun);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getVolumeIds() {
            if (volumeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return volumeIds;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumeStatusRequest build() {
            return new DescribeVolumeStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
