/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePublicIpv4PoolsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribePublicIpv4PoolsResponse.Builder, DescribePublicIpv4PoolsResponse> {
    private static final SdkField<List<PublicIpv4Pool>> PUBLIC_IPV4_POOLS_FIELD = SdkField
            .<List<PublicIpv4Pool>> builder(MarshallingType.LIST)
            .memberName("PublicIpv4Pools")
            .getter(getter(DescribePublicIpv4PoolsResponse::publicIpv4Pools))
            .setter(setter(Builder::publicIpv4Pools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4PoolSet")
                    .unmarshallLocationName("publicIpv4PoolSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PublicIpv4Pool> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicIpv4Pool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribePublicIpv4PoolsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IPV4_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PublicIpv4PoolSet", PUBLIC_IPV4_POOLS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<PublicIpv4Pool> publicIpv4Pools;

    private final String nextToken;

    private DescribePublicIpv4PoolsResponse(BuilderImpl builder) {
        super(builder);
        this.publicIpv4Pools = builder.publicIpv4Pools;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicIpv4Pools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublicIpv4Pools() {
        return publicIpv4Pools != null && !(publicIpv4Pools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the address pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicIpv4Pools} method.
     * </p>
     * 
     * @return Information about the address pools.
     */
    public final List<PublicIpv4Pool> publicIpv4Pools() {
        return publicIpv4Pools;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicIpv4Pools() ? publicIpv4Pools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublicIpv4PoolsResponse)) {
            return false;
        }
        DescribePublicIpv4PoolsResponse other = (DescribePublicIpv4PoolsResponse) obj;
        return hasPublicIpv4Pools() == other.hasPublicIpv4Pools() && Objects.equals(publicIpv4Pools(), other.publicIpv4Pools())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePublicIpv4PoolsResponse")
                .add("PublicIpv4Pools", hasPublicIpv4Pools() ? publicIpv4Pools() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicIpv4Pools":
            return Optional.ofNullable(clazz.cast(publicIpv4Pools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublicIpv4PoolsResponse, T> g) {
        return obj -> g.apply((DescribePublicIpv4PoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribePublicIpv4PoolsResponse> {
        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param publicIpv4Pools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pools(Collection<PublicIpv4Pool> publicIpv4Pools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param publicIpv4Pools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pools(PublicIpv4Pool... publicIpv4Pools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PublicIpv4Pool.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.PublicIpv4Pool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PublicIpv4Pool.Builder#build()} is called immediately and
         * its result is passed to {@link #publicIpv4Pools(List<PublicIpv4Pool>)}.
         * 
         * @param publicIpv4Pools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PublicIpv4Pool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicIpv4Pools(java.util.Collection<PublicIpv4Pool>)
         */
        Builder publicIpv4Pools(Consumer<PublicIpv4Pool.Builder>... publicIpv4Pools);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<PublicIpv4Pool> publicIpv4Pools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublicIpv4PoolsResponse model) {
            super(model);
            publicIpv4Pools(model.publicIpv4Pools);
            nextToken(model.nextToken);
        }

        public final List<PublicIpv4Pool.Builder> getPublicIpv4Pools() {
            List<PublicIpv4Pool.Builder> result = PublicIpv4PoolSetCopier.copyToBuilder(this.publicIpv4Pools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublicIpv4Pools(Collection<PublicIpv4Pool.BuilderImpl> publicIpv4Pools) {
            this.publicIpv4Pools = PublicIpv4PoolSetCopier.copyFromBuilder(publicIpv4Pools);
        }

        @Override
        public final Builder publicIpv4Pools(Collection<PublicIpv4Pool> publicIpv4Pools) {
            this.publicIpv4Pools = PublicIpv4PoolSetCopier.copy(publicIpv4Pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpv4Pools(PublicIpv4Pool... publicIpv4Pools) {
            publicIpv4Pools(Arrays.asList(publicIpv4Pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpv4Pools(Consumer<PublicIpv4Pool.Builder>... publicIpv4Pools) {
            publicIpv4Pools(Stream.of(publicIpv4Pools).map(c -> PublicIpv4Pool.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePublicIpv4PoolsResponse build() {
            return new DescribePublicIpv4PoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
