/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInternetGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInternetGatewaysResponse.Builder, DescribeInternetGatewaysResponse> {
    private static final SdkField<List<InternetGateway>> INTERNET_GATEWAYS_FIELD = SdkField
            .<List<InternetGateway>> builder(MarshallingType.LIST)
            .memberName("InternetGateways")
            .getter(getter(DescribeInternetGatewaysResponse::internetGateways))
            .setter(setter(Builder::internetGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewaySet")
                    .unmarshallLocationName("internetGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InternetGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(InternetGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInternetGatewaysResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_GATEWAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InternetGatewaySet", INTERNET_GATEWAYS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<InternetGateway> internetGateways;

    private final String nextToken;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.internetGateways = builder.internetGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InternetGateways property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInternetGateways() {
        return internetGateways != null && !(internetGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInternetGateways} method.
     * </p>
     * 
     * @return Information about the internet gateways.
     */
    public final List<InternetGateway> internetGateways() {
        return internetGateways;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInternetGateways() ? internetGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse) obj;
        return hasInternetGateways() == other.hasInternetGateways()
                && Objects.equals(internetGateways(), other.internetGateways()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInternetGatewaysResponse")
                .add("InternetGateways", hasInternetGateways() ? internetGateways() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGateways":
            return Optional.ofNullable(clazz.cast(internetGateways()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInternetGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeInternetGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        /**
         * <p>
         * Information about the internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about the internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(Collection<InternetGateway> internetGateways);

        /**
         * <p>
         * Information about the internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about the internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(InternetGateway... internetGateways);

        /**
         * <p>
         * Information about the internet gateways.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InternetGateway.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.InternetGateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InternetGateway.Builder#build()} is called immediately and
         * its result is passed to {@link #internetGateways(List<InternetGateway>)}.
         * 
         * @param internetGateways
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InternetGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateways(java.util.Collection<InternetGateway>)
         */
        Builder internetGateways(Consumer<InternetGateway.Builder>... internetGateways);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InternetGateway> internetGateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            super(model);
            internetGateways(model.internetGateways);
            nextToken(model.nextToken);
        }

        public final List<InternetGateway.Builder> getInternetGateways() {
            List<InternetGateway.Builder> result = InternetGatewayListCopier.copyToBuilder(this.internetGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInternetGateways(Collection<InternetGateway.BuilderImpl> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copyFromBuilder(internetGateways);
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway... internetGateways) {
            internetGateways(Arrays.asList(internetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(Consumer<InternetGateway.Builder>... internetGateways) {
            internetGateways(Stream.of(internetGateways).map(c -> InternetGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
