/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstanceAttributeResponse.Builder, DescribeInstanceAttributeResponse> {
    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(DescribeInstanceAttributeResponse::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AttributeBooleanValue> DISABLE_API_TERMINATION_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("DisableApiTermination")
            .getter(getter(DescribeInstanceAttributeResponse::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("disableApiTermination").build()).build();

    private static final SdkField<AttributeBooleanValue> ENA_SUPPORT_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSupport")
            .getter(getter(DescribeInstanceAttributeResponse::enaSupport))
            .setter(setter(Builder::enaSupport))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<EnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField
            .<EnclaveOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EnclaveOptions")
            .getter(getter(DescribeInstanceAttributeResponse::enclaveOptions))
            .setter(setter(Builder::enclaveOptions))
            .constructor(EnclaveOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions")
                    .unmarshallLocationName("enclaveOptions").build()).build();

    private static final SdkField<AttributeBooleanValue> EBS_OPTIMIZED_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("EbsOptimized")
            .getter(getter(DescribeInstanceAttributeResponse::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(DescribeInstanceAttributeResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<AttributeValue> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(DescribeInstanceAttributeResponse::instanceInitiatedShutdownBehavior))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("instanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<AttributeValue> INSTANCE_TYPE_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceType")
            .getter(getter(DescribeInstanceAttributeResponse::instanceType))
            .setter(setter(Builder::instanceType))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("KernelId")
            .getter(getter(DescribeInstanceAttributeResponse::kernelId))
            .setter(setter(Builder::kernelId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel")
                    .unmarshallLocationName("kernel").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(DescribeInstanceAttributeResponse::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("RamdiskId")
            .getter(getter(DescribeInstanceAttributeResponse::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk")
                    .unmarshallLocationName("ramdisk").build()).build();

    private static final SdkField<AttributeValue> ROOT_DEVICE_NAME_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("RootDeviceName")
            .getter(getter(DescribeInstanceAttributeResponse::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("SourceDestCheck")
            .getter(getter(DescribeInstanceAttributeResponse::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("SriovNetSupport")
            .getter(getter(DescribeInstanceAttributeResponse::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<AttributeValue> USER_DATA_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .memberName("UserData")
            .getter(getter(DescribeInstanceAttributeResponse::userData))
            .setter(setter(Builder::userData))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("userData").build()).build();

    private static final SdkField<AttributeBooleanValue> DISABLE_API_STOP_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .memberName("DisableApiStop")
            .getter(getter(DescribeInstanceAttributeResponse::disableApiStop))
            .setter(setter(Builder::disableApiStop))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop")
                    .unmarshallLocationName("disableApiStop").build()).build();

    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(DescribeInstanceAttributeResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            DISABLE_API_TERMINATION_FIELD, ENA_SUPPORT_FIELD, ENCLAVE_OPTIONS_FIELD, EBS_OPTIMIZED_FIELD, INSTANCE_ID_FIELD,
            INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, PRODUCT_CODES_FIELD,
            RAMDISK_ID_FIELD, ROOT_DEVICE_NAME_FIELD, SOURCE_DEST_CHECK_FIELD, SRIOV_NET_SUPPORT_FIELD, USER_DATA_FIELD,
            DISABLE_API_STOP_FIELD, GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("BlockDeviceMapping", BLOCK_DEVICE_MAPPINGS_FIELD);
                    put("DisableApiTermination", DISABLE_API_TERMINATION_FIELD);
                    put("EnaSupport", ENA_SUPPORT_FIELD);
                    put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
                    put("EbsOptimized", EBS_OPTIMIZED_FIELD);
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("InstanceInitiatedShutdownBehavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD);
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("Kernel", KERNEL_ID_FIELD);
                    put("ProductCodes", PRODUCT_CODES_FIELD);
                    put("Ramdisk", RAMDISK_ID_FIELD);
                    put("RootDeviceName", ROOT_DEVICE_NAME_FIELD);
                    put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
                    put("SriovNetSupport", SRIOV_NET_SUPPORT_FIELD);
                    put("UserData", USER_DATA_FIELD);
                    put("DisableApiStop", DISABLE_API_STOP_FIELD);
                    put("GroupSet", GROUPS_FIELD);
                }
            });

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final AttributeBooleanValue disableApiTermination;

    private final AttributeBooleanValue enaSupport;

    private final EnclaveOptions enclaveOptions;

    private final AttributeBooleanValue ebsOptimized;

    private final String instanceId;

    private final AttributeValue instanceInitiatedShutdownBehavior;

    private final AttributeValue instanceType;

    private final AttributeValue kernelId;

    private final List<ProductCode> productCodes;

    private final AttributeValue ramdiskId;

    private final AttributeValue rootDeviceName;

    private final AttributeBooleanValue sourceDestCheck;

    private final AttributeValue sriovNetSupport;

    private final AttributeValue userData;

    private final AttributeBooleanValue disableApiStop;

    private final List<GroupIdentifier> groups;

    private DescribeInstanceAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.enclaveOptions = builder.enclaveOptions;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.disableApiStop = builder.disableApiStop;
        this.groups = builder.groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping of the instance.
     */
    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or API;
     * otherwise, you can.
     * </p>
     * 
     * @return If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI,
     *         or API; otherwise, you can.
     */
    public final AttributeBooleanValue disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with ENA is enabled.
     */
    public final AttributeBooleanValue enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>;
     * otherwise, set it to <code>false</code>.
     * </p>
     * 
     * @return To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>;
     *         otherwise, set it to <code>false</code>.
     */
    public final EnclaveOptions enclaveOptions() {
        return enclaveOptions;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    public final AttributeBooleanValue ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     */
    public final AttributeValue instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public final AttributeValue instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public final AttributeValue kernelId() {
        return kernelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return A list of product codes.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public final AttributeValue ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public final AttributeValue rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the
     * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
     * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     * source/destination checks if the instance runs services such as network address translation, routing, or
     * firewalls.
     * </p>
     * 
     * @return Enable or disable source/destination checks, which ensure that the instance is either the source or the
     *         destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks
     *         are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
     *         source/destination checks if the instance runs services such as network address translation, routing, or
     *         firewalls.
     */
    public final AttributeBooleanValue sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public final AttributeValue sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The user data.
     * </p>
     * 
     * @return The user data.
     */
    public final AttributeValue userData() {
        return userData;
    }

    /**
     * <p>
     * To enable the instance for Amazon Web Services Stop Protection, set this parameter to <code>true</code>;
     * otherwise, set it to <code>false</code>.
     * </p>
     * 
     * @return To enable the instance for Amazon Web Services Stop Protection, set this parameter to <code>true</code>;
     *         otherwise, set it to <code>false</code>.
     */
    public final AttributeBooleanValue disableApiStop() {
        return disableApiStop;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The security groups associated with the instance.
     */
    public final List<GroupIdentifier> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeResponse)) {
            return false;
        }
        DescribeInstanceAttributeResponse other = (DescribeInstanceAttributeResponse) obj;
        return hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(enaSupport(), other.enaSupport()) && Objects.equals(enclaveOptions(), other.enclaveOptions())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && hasProductCodes() == other.hasProductCodes() && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(ramdiskId(), other.ramdiskId()) && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(userData(), other.userData())
                && Objects.equals(disableApiStop(), other.disableApiStop()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceAttributeResponse")
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("DisableApiTermination", disableApiTermination()).add("EnaSupport", enaSupport())
                .add("EnclaveOptions", enclaveOptions()).add("EbsOptimized", ebsOptimized()).add("InstanceId", instanceId())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehavior())
                .add("InstanceType", instanceType()).add("KernelId", kernelId())
                .add("ProductCodes", hasProductCodes() ? productCodes() : null).add("RamdiskId", ramdiskId())
                .add("RootDeviceName", rootDeviceName()).add("SourceDestCheck", sourceDestCheck())
                .add("SriovNetSupport", sriovNetSupport()).add("UserData", userData()).add("DisableApiStop", disableApiStop())
                .add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehavior()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "DisableApiStop":
            return Optional.ofNullable(clazz.cast(disableApiStop()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAttributeResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceAttributeResponse> {
        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or
         * API; otherwise, you can.
         * </p>
         * 
         * @param disableApiTermination
         *        If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console,
         *        CLI, or API; otherwise, you can.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(AttributeBooleanValue disableApiTermination);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or
         * API; otherwise, you can.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #disableApiTermination(AttributeBooleanValue)}.
         * 
         * @param disableApiTermination
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableApiTermination(AttributeBooleanValue)
         */
        default Builder disableApiTermination(Consumer<AttributeBooleanValue.Builder> disableApiTermination) {
            return disableApiTermination(AttributeBooleanValue.builder().applyMutation(disableApiTermination).build());
        }

        /**
         * <p>
         * Indicates whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Indicates whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(AttributeBooleanValue enaSupport);

        /**
         * <p>
         * Indicates whether enhanced networking with ENA is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enaSupport(AttributeBooleanValue)}.
         * 
         * @param enaSupport
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSupport(AttributeBooleanValue)
         */
        default Builder enaSupport(Consumer<AttributeBooleanValue.Builder> enaSupport) {
            return enaSupport(AttributeBooleanValue.builder().applyMutation(enaSupport).build());
        }

        /**
         * <p>
         * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>;
         * otherwise, set it to <code>false</code>.
         * </p>
         * 
         * @param enclaveOptions
         *        To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>
         *        ; otherwise, set it to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(EnclaveOptions enclaveOptions);

        /**
         * <p>
         * To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>;
         * otherwise, set it to <code>false</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnclaveOptions.Builder} avoiding the need
         * to create one manually via {@link EnclaveOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnclaveOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #enclaveOptions(EnclaveOptions)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link EnclaveOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(EnclaveOptions)
         */
        default Builder enclaveOptions(Consumer<EnclaveOptions.Builder> enclaveOptions) {
            return enclaveOptions(EnclaveOptions.builder().applyMutation(enclaveOptions).build());
        }

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(AttributeBooleanValue ebsOptimized);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #ebsOptimized(AttributeBooleanValue)}.
         * 
         * @param ebsOptimized
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptimized(AttributeBooleanValue)
         */
        default Builder ebsOptimized(Consumer<AttributeBooleanValue.Builder> ebsOptimized) {
            return ebsOptimized(AttributeBooleanValue.builder().applyMutation(ebsOptimized).build());
        }

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceInitiatedShutdownBehavior(AttributeValue)}.
         * 
         * @param instanceInitiatedShutdownBehavior
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInitiatedShutdownBehavior(AttributeValue)
         */
        default Builder instanceInitiatedShutdownBehavior(Consumer<AttributeValue.Builder> instanceInitiatedShutdownBehavior) {
            return instanceInitiatedShutdownBehavior(AttributeValue.builder().applyMutation(instanceInitiatedShutdownBehavior)
                    .build());
        }

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(AttributeValue instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceType(AttributeValue)}.
         * 
         * @param instanceType
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceType(AttributeValue)
         */
        default Builder instanceType(Consumer<AttributeValue.Builder> instanceType) {
            return instanceType(AttributeValue.builder().applyMutation(instanceType).build());
        }

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(AttributeValue kernelId);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #kernelId(AttributeValue)}.
         * 
         * @param kernelId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelId(AttributeValue)
         */
        default Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return kernelId(AttributeValue.builder().applyMutation(kernelId).build());
        }

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(AttributeValue ramdiskId);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #ramdiskId(AttributeValue)}.
         * 
         * @param ramdiskId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ramdiskId(AttributeValue)
         */
        default Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return ramdiskId(AttributeValue.builder().applyMutation(ramdiskId).build());
        }

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(AttributeValue rootDeviceName);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #rootDeviceName(AttributeValue)}.
         * 
         * @param rootDeviceName
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootDeviceName(AttributeValue)
         */
        default Builder rootDeviceName(Consumer<AttributeValue.Builder> rootDeviceName) {
            return rootDeviceName(AttributeValue.builder().applyMutation(rootDeviceName).build());
        }

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * 
         * @param sourceDestCheck
         *        Enable or disable source/destination checks, which ensure that the instance is either the source or
         *        the destination of any traffic that it receives. If the value is <code>true</code>, source/destination
         *        checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must
         *        disable source/destination checks if the instance runs services such as network address translation,
         *        routing, or firewalls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck);

        /**
         * <p>
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the
         * destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are
         * enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable
         * source/destination checks if the instance runs services such as network address translation, routing, or
         * firewalls.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDestCheck(AttributeBooleanValue)}.
         * 
         * @param sourceDestCheck
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDestCheck(AttributeBooleanValue)
         */
        default Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return sourceDestCheck(AttributeBooleanValue.builder().applyMutation(sourceDestCheck).build());
        }

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(AttributeValue sriovNetSupport);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #sriovNetSupport(AttributeValue)}.
         * 
         * @param sriovNetSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sriovNetSupport(AttributeValue)
         */
        default Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return sriovNetSupport(AttributeValue.builder().applyMutation(sriovNetSupport).build());
        }

        /**
         * <p>
         * The user data.
         * </p>
         * 
         * @param userData
         *        The user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(AttributeValue userData);

        /**
         * <p>
         * The user data.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValue.Builder} avoiding the need
         * to create one manually via {@link AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #userData(AttributeValue)}.
         * 
         * @param userData
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userData(AttributeValue)
         */
        default Builder userData(Consumer<AttributeValue.Builder> userData) {
            return userData(AttributeValue.builder().applyMutation(userData).build());
        }

        /**
         * <p>
         * To enable the instance for Amazon Web Services Stop Protection, set this parameter to <code>true</code>;
         * otherwise, set it to <code>false</code>.
         * </p>
         * 
         * @param disableApiStop
         *        To enable the instance for Amazon Web Services Stop Protection, set this parameter to
         *        <code>true</code>; otherwise, set it to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiStop(AttributeBooleanValue disableApiStop);

        /**
         * <p>
         * To enable the instance for Amazon Web Services Stop Protection, set this parameter to <code>true</code>;
         * otherwise, set it to <code>false</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding
         * the need to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #disableApiStop(AttributeBooleanValue)}.
         * 
         * @param disableApiStop
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disableApiStop(AttributeBooleanValue)
         */
        default Builder disableApiStop(Consumer<AttributeBooleanValue.Builder> disableApiStop) {
            return disableApiStop(AttributeBooleanValue.builder().applyMutation(disableApiStop).build());
        }

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private AttributeBooleanValue disableApiTermination;

        private AttributeBooleanValue enaSupport;

        private EnclaveOptions enclaveOptions;

        private AttributeBooleanValue ebsOptimized;

        private String instanceId;

        private AttributeValue instanceInitiatedShutdownBehavior;

        private AttributeValue instanceType;

        private AttributeValue kernelId;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private AttributeValue ramdiskId;

        private AttributeValue rootDeviceName;

        private AttributeBooleanValue sourceDestCheck;

        private AttributeValue sriovNetSupport;

        private AttributeValue userData;

        private AttributeBooleanValue disableApiStop;

        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAttributeResponse model) {
            super(model);
            blockDeviceMappings(model.blockDeviceMappings);
            disableApiTermination(model.disableApiTermination);
            enaSupport(model.enaSupport);
            enclaveOptions(model.enclaveOptions);
            ebsOptimized(model.ebsOptimized);
            instanceId(model.instanceId);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            productCodes(model.productCodes);
            ramdiskId(model.ramdiskId);
            rootDeviceName(model.rootDeviceName);
            sourceDestCheck(model.sourceDestCheck);
            sriovNetSupport(model.sriovNetSupport);
            userData(model.userData);
            disableApiStop(model.disableApiStop);
            groups(model.groups);
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableApiTermination() {
            return disableApiTermination != null ? disableApiTermination.toBuilder() : null;
        }

        public final void setDisableApiTermination(AttributeBooleanValue.BuilderImpl disableApiTermination) {
            this.disableApiTermination = disableApiTermination != null ? disableApiTermination.build() : null;
        }

        @Override
        public final Builder disableApiTermination(AttributeBooleanValue disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final AttributeBooleanValue.Builder getEnaSupport() {
            return enaSupport != null ? enaSupport.toBuilder() : null;
        }

        public final void setEnaSupport(AttributeBooleanValue.BuilderImpl enaSupport) {
            this.enaSupport = enaSupport != null ? enaSupport.build() : null;
        }

        @Override
        public final Builder enaSupport(AttributeBooleanValue enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final EnclaveOptions.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final AttributeBooleanValue.Builder getEbsOptimized() {
            return ebsOptimized != null ? ebsOptimized.toBuilder() : null;
        }

        public final void setEbsOptimized(AttributeBooleanValue.BuilderImpl ebsOptimized) {
            this.ebsOptimized = ebsOptimized != null ? ebsOptimized.build() : null;
        }

        @Override
        public final Builder ebsOptimized(AttributeBooleanValue ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AttributeValue.Builder getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior.toBuilder() : null;
        }

        public final void setInstanceInitiatedShutdownBehavior(AttributeValue.BuilderImpl instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior
                    .build() : null;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final AttributeValue.Builder getInstanceType() {
            return instanceType != null ? instanceType.toBuilder() : null;
        }

        public final void setInstanceType(AttributeValue.BuilderImpl instanceType) {
            this.instanceType = instanceType != null ? instanceType.build() : null;
        }

        @Override
        public final Builder instanceType(AttributeValue instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final AttributeValue.Builder getKernelId() {
            return kernelId != null ? kernelId.toBuilder() : null;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AttributeValue.Builder getRamdiskId() {
            return ramdiskId != null ? ramdiskId.toBuilder() : null;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final AttributeValue.Builder getRootDeviceName() {
            return rootDeviceName != null ? rootDeviceName.toBuilder() : null;
        }

        public final void setRootDeviceName(AttributeValue.BuilderImpl rootDeviceName) {
            this.rootDeviceName = rootDeviceName != null ? rootDeviceName.build() : null;
        }

        @Override
        public final Builder rootDeviceName(AttributeValue rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return sourceDestCheck != null ? sourceDestCheck.toBuilder() : null;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return sriovNetSupport != null ? sriovNetSupport.toBuilder() : null;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final AttributeValue.Builder getUserData() {
            return userData != null ? userData.toBuilder() : null;
        }

        public final void setUserData(AttributeValue.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public final Builder userData(AttributeValue userData) {
            this.userData = userData;
            return this;
        }

        public final AttributeBooleanValue.Builder getDisableApiStop() {
            return disableApiStop != null ? disableApiStop.toBuilder() : null;
        }

        public final void setDisableApiStop(AttributeBooleanValue.BuilderImpl disableApiStop) {
            this.disableApiStop = disableApiStop != null ? disableApiStop.build() : null;
        }

        @Override
        public final Builder disableApiStop(AttributeBooleanValue disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final List<GroupIdentifier.Builder> getGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInstanceAttributeResponse build() {
            return new DescribeInstanceAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
