/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInsightsPathRequest extends Ec2Request implements
        ToCopyableBuilder<CreateNetworkInsightsPathRequest.Builder, CreateNetworkInsightsPathRequest> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceIp")
            .getter(getter(CreateNetworkInsightsPathRequest::sourceIp))
            .setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp")
                    .unmarshallLocationName("SourceIp").build()).build();

    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationIp")
            .getter(getter(CreateNetworkInsightsPathRequest::destinationIp))
            .setter(setter(Builder::destinationIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIp")
                    .unmarshallLocationName("DestinationIp").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(CreateNetworkInsightsPathRequest::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("Source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(CreateNetworkInsightsPathRequest::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("Destination").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(CreateNetworkInsightsPathRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort")
            .getter(getter(CreateNetworkInsightsPathRequest::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort")
                    .unmarshallLocationName("DestinationPort").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateNetworkInsightsPathRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateNetworkInsightsPathRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateNetworkInsightsPathRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<PathRequestFilter> FILTER_AT_SOURCE_FIELD = SdkField
            .<PathRequestFilter> builder(MarshallingType.SDK_POJO)
            .memberName("FilterAtSource")
            .getter(getter(CreateNetworkInsightsPathRequest::filterAtSource))
            .setter(setter(Builder::filterAtSource))
            .constructor(PathRequestFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAtSource")
                    .unmarshallLocationName("FilterAtSource").build()).build();

    private static final SdkField<PathRequestFilter> FILTER_AT_DESTINATION_FIELD = SdkField
            .<PathRequestFilter> builder(MarshallingType.SDK_POJO)
            .memberName("FilterAtDestination")
            .getter(getter(CreateNetworkInsightsPathRequest::filterAtDestination))
            .setter(setter(Builder::filterAtDestination))
            .constructor(PathRequestFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAtDestination")
                    .unmarshallLocationName("FilterAtDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD,
            DESTINATION_IP_FIELD, SOURCE_FIELD, DESTINATION_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_FIELD,
            TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, FILTER_AT_SOURCE_FIELD, FILTER_AT_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SourceIp", SOURCE_IP_FIELD);
                    put("DestinationIp", DESTINATION_IP_FIELD);
                    put("Source", SOURCE_FIELD);
                    put("Destination", DESTINATION_FIELD);
                    put("Protocol", PROTOCOL_FIELD);
                    put("DestinationPort", DESTINATION_PORT_FIELD);
                    put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                    put("FilterAtSource", FILTER_AT_SOURCE_FIELD);
                    put("FilterAtDestination", FILTER_AT_DESTINATION_FIELD);
                }
            });

    private final String sourceIp;

    private final String destinationIp;

    private final String source;

    private final String destination;

    private final String protocol;

    private final Integer destinationPort;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean dryRun;

    private final String clientToken;

    private final PathRequestFilter filterAtSource;

    private final PathRequestFilter filterAtDestination;

    private CreateNetworkInsightsPathRequest(BuilderImpl builder) {
        super(builder);
        this.sourceIp = builder.sourceIp;
        this.destinationIp = builder.destinationIp;
        this.source = builder.source;
        this.destination = builder.destination;
        this.protocol = builder.protocol;
        this.destinationPort = builder.destinationPort;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.filterAtSource = builder.filterAtSource;
        this.filterAtDestination = builder.filterAtDestination;
    }

    /**
     * <p>
     * The IP address of the source.
     * </p>
     * 
     * @return The IP address of the source.
     */
    public final String sourceIp() {
        return sourceIp;
    }

    /**
     * <p>
     * The IP address of the destination.
     * </p>
     * 
     * @return The IP address of the destination.
     */
    public final String destinationIp() {
        return destinationIp;
    }

    /**
     * <p>
     * The ID or ARN of the source. If the resource is in another account, you must specify an ARN.
     * </p>
     * 
     * @return The ID or ARN of the source. If the resource is in another account, you must specify an ARN.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The ID or ARN of the destination. If the resource is in another account, you must specify an ARN.
     * </p>
     * 
     * @return The ID or ARN of the destination. If the resource is in another account, you must specify an ARN.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The destination port.
     * </p>
     * 
     * @return The destination port.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to add to the path.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How
     *         to ensure idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Scopes the analysis to network paths that match specific filters at the source. If you specify this parameter,
     * you can't specify the parameters for the source IP address or the destination port.
     * </p>
     * 
     * @return Scopes the analysis to network paths that match specific filters at the source. If you specify this
     *         parameter, you can't specify the parameters for the source IP address or the destination port.
     */
    public final PathRequestFilter filterAtSource() {
        return filterAtSource;
    }

    /**
     * <p>
     * Scopes the analysis to network paths that match specific filters at the destination. If you specify this
     * parameter, you can't specify the parameter for the destination IP address.
     * </p>
     * 
     * @return Scopes the analysis to network paths that match specific filters at the destination. If you specify this
     *         parameter, you can't specify the parameter for the destination IP address.
     */
    public final PathRequestFilter filterAtDestination() {
        return filterAtDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(filterAtSource());
        hashCode = 31 * hashCode + Objects.hashCode(filterAtDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInsightsPathRequest)) {
            return false;
        }
        CreateNetworkInsightsPathRequest other = (CreateNetworkInsightsPathRequest) obj;
        return Objects.equals(sourceIp(), other.sourceIp()) && Objects.equals(destinationIp(), other.destinationIp())
                && Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(destinationPort(), other.destinationPort())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(filterAtSource(), other.filterAtSource())
                && Objects.equals(filterAtDestination(), other.filterAtDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkInsightsPathRequest").add("SourceIp", sourceIp())
                .add("DestinationIp", destinationIp()).add("Source", source()).add("Destination", destination())
                .add("Protocol", protocolAsString()).add("DestinationPort", destinationPort())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DryRun", dryRun())
                .add("ClientToken", clientToken()).add("FilterAtSource", filterAtSource())
                .add("FilterAtDestination", filterAtDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        case "DestinationIp":
            return Optional.ofNullable(clazz.cast(destinationIp()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "FilterAtSource":
            return Optional.ofNullable(clazz.cast(filterAtSource()));
        case "FilterAtDestination":
            return Optional.ofNullable(clazz.cast(filterAtDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInsightsPathRequest, T> g) {
        return obj -> g.apply((CreateNetworkInsightsPathRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkInsightsPathRequest> {
        /**
         * <p>
         * The IP address of the source.
         * </p>
         * 
         * @param sourceIp
         *        The IP address of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);

        /**
         * <p>
         * The IP address of the destination.
         * </p>
         * 
         * @param destinationIp
         *        The IP address of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIp(String destinationIp);

        /**
         * <p>
         * The ID or ARN of the source. If the resource is in another account, you must specify an ARN.
         * </p>
         * 
         * @param source
         *        The ID or ARN of the source. If the resource is in another account, you must specify an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The ID or ARN of the destination. If the resource is in another account, you must specify an ARN.
         * </p>
         * 
         * @param destination
         *        The ID or ARN of the destination. If the resource is in another account, you must specify an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The destination port.
         * </p>
         * 
         * @param destinationPort
         *        The destination port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The tags to add to the path.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to add to the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to add to the path.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to add to the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to add to the path.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to
         * ensure idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the source. If you specify this
         * parameter, you can't specify the parameters for the source IP address or the destination port.
         * </p>
         * 
         * @param filterAtSource
         *        Scopes the analysis to network paths that match specific filters at the source. If you specify this
         *        parameter, you can't specify the parameters for the source IP address or the destination port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAtSource(PathRequestFilter filterAtSource);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the source. If you specify this
         * parameter, you can't specify the parameters for the source IP address or the destination port.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathRequestFilter.Builder} avoiding the
         * need to create one manually via {@link PathRequestFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathRequestFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filterAtSource(PathRequestFilter)}.
         * 
         * @param filterAtSource
         *        a consumer that will call methods on {@link PathRequestFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAtSource(PathRequestFilter)
         */
        default Builder filterAtSource(Consumer<PathRequestFilter.Builder> filterAtSource) {
            return filterAtSource(PathRequestFilter.builder().applyMutation(filterAtSource).build());
        }

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the destination. If you specify this
         * parameter, you can't specify the parameter for the destination IP address.
         * </p>
         * 
         * @param filterAtDestination
         *        Scopes the analysis to network paths that match specific filters at the destination. If you specify
         *        this parameter, you can't specify the parameter for the destination IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAtDestination(PathRequestFilter filterAtDestination);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the destination. If you specify this
         * parameter, you can't specify the parameter for the destination IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathRequestFilter.Builder} avoiding the
         * need to create one manually via {@link PathRequestFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathRequestFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filterAtDestination(PathRequestFilter)}.
         * 
         * @param filterAtDestination
         *        a consumer that will call methods on {@link PathRequestFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAtDestination(PathRequestFilter)
         */
        default Builder filterAtDestination(Consumer<PathRequestFilter.Builder> filterAtDestination) {
            return filterAtDestination(PathRequestFilter.builder().applyMutation(filterAtDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String sourceIp;

        private String destinationIp;

        private String source;

        private String destination;

        private String protocol;

        private Integer destinationPort;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private String clientToken;

        private PathRequestFilter filterAtSource;

        private PathRequestFilter filterAtDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInsightsPathRequest model) {
            super(model);
            sourceIp(model.sourceIp);
            destinationIp(model.destinationIp);
            source(model.source);
            destination(model.destination);
            protocol(model.protocol);
            destinationPort(model.destinationPort);
            tagSpecifications(model.tagSpecifications);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            filterAtSource(model.filterAtSource);
            filterAtDestination(model.filterAtDestination);
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getDestinationIp() {
            return destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final PathRequestFilter.Builder getFilterAtSource() {
            return filterAtSource != null ? filterAtSource.toBuilder() : null;
        }

        public final void setFilterAtSource(PathRequestFilter.BuilderImpl filterAtSource) {
            this.filterAtSource = filterAtSource != null ? filterAtSource.build() : null;
        }

        @Override
        public final Builder filterAtSource(PathRequestFilter filterAtSource) {
            this.filterAtSource = filterAtSource;
            return this;
        }

        public final PathRequestFilter.Builder getFilterAtDestination() {
            return filterAtDestination != null ? filterAtDestination.toBuilder() : null;
        }

        public final void setFilterAtDestination(PathRequestFilter.BuilderImpl filterAtDestination) {
            this.filterAtDestination = filterAtDestination != null ? filterAtDestination.build() : null;
        }

        @Override
        public final Builder filterAtDestination(PathRequestFilter filterAtDestination) {
            this.filterAtDestination = filterAtDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInsightsPathRequest build() {
            return new CreateNetworkInsightsPathRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
