/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayPolicyTablesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayPolicyTablesResponse> {
    private static final SdkField<List<TransitGatewayPolicyTable>> TRANSIT_GATEWAY_POLICY_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayPolicyTables").getter(DescribeTransitGatewayPolicyTablesResponse.getter(DescribeTransitGatewayPolicyTablesResponse::transitGatewayPolicyTables)).setter(DescribeTransitGatewayPolicyTablesResponse.setter(Builder::transitGatewayPolicyTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPolicyTables").unmarshallLocationName("transitGatewayPolicyTables").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayPolicyTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayPolicyTablesResponse.getter(DescribeTransitGatewayPolicyTablesResponse::nextToken)).setter(DescribeTransitGatewayPolicyTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_POLICY_TABLES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayPolicyTables", TRANSIT_GATEWAY_POLICY_TABLES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TransitGatewayPolicyTable> transitGatewayPolicyTables;
    private final String nextToken;

    private DescribeTransitGatewayPolicyTablesResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPolicyTables = builder.transitGatewayPolicyTables;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayPolicyTables() {
        return this.transitGatewayPolicyTables != null && !(this.transitGatewayPolicyTables instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayPolicyTable> transitGatewayPolicyTables() {
        return this.transitGatewayPolicyTables;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayPolicyTables() ? this.transitGatewayPolicyTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayPolicyTablesResponse)) {
            return false;
        }
        DescribeTransitGatewayPolicyTablesResponse other = (DescribeTransitGatewayPolicyTablesResponse)((Object)obj);
        return this.hasTransitGatewayPolicyTables() == other.hasTransitGatewayPolicyTables() && Objects.equals(this.transitGatewayPolicyTables(), other.transitGatewayPolicyTables()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayPolicyTablesResponse").add("TransitGatewayPolicyTables", this.hasTransitGatewayPolicyTables() ? this.transitGatewayPolicyTables() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayPolicyTables": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayPolicyTables()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayPolicyTablesResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayPolicyTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayPolicyTable> transitGatewayPolicyTables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayPolicyTablesResponse model) {
            super(model);
            this.transitGatewayPolicyTables(model.transitGatewayPolicyTables);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayPolicyTable.Builder> getTransitGatewayPolicyTables() {
            List<TransitGatewayPolicyTable.Builder> result = TransitGatewayPolicyTableListCopier.copyToBuilder(this.transitGatewayPolicyTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayPolicyTables(Collection<TransitGatewayPolicyTable.BuilderImpl> transitGatewayPolicyTables) {
            this.transitGatewayPolicyTables = TransitGatewayPolicyTableListCopier.copyFromBuilder(transitGatewayPolicyTables);
        }

        @Override
        public final Builder transitGatewayPolicyTables(Collection<TransitGatewayPolicyTable> transitGatewayPolicyTables) {
            this.transitGatewayPolicyTables = TransitGatewayPolicyTableListCopier.copy(transitGatewayPolicyTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPolicyTables(TransitGatewayPolicyTable ... transitGatewayPolicyTables) {
            this.transitGatewayPolicyTables(Arrays.asList(transitGatewayPolicyTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPolicyTables(Consumer<TransitGatewayPolicyTable.Builder> ... transitGatewayPolicyTables) {
            this.transitGatewayPolicyTables(Stream.of(transitGatewayPolicyTables).map(c -> (TransitGatewayPolicyTable)((TransitGatewayPolicyTable.Builder)TransitGatewayPolicyTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayPolicyTablesResponse build() {
            return new DescribeTransitGatewayPolicyTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayPolicyTablesResponse> {
        public Builder transitGatewayPolicyTables(Collection<TransitGatewayPolicyTable> var1);

        public Builder transitGatewayPolicyTables(TransitGatewayPolicyTable ... var1);

        public Builder transitGatewayPolicyTables(Consumer<TransitGatewayPolicyTable.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

